/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.ttsv2;

import com.alibaba.dashscope.api.SynchronizeFullDuplexApi;
import com.alibaba.dashscope.audio.tts.SpeechSynthesisResult;
import com.alibaba.dashscope.audio.ttsv2.SpeechSynthesisParam;
import com.alibaba.dashscope.audio.ttsv2.SpeechSynthesisState;
import com.alibaba.dashscope.base.FullDuplexParamBase;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.google.gson.JsonObject;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpeechSynthesizer {
    private static final Logger log = LoggerFactory.getLogger(SpeechSynthesizer.class);
    private final Queue<AsyncCmdBuffer> cmdBuffer = new LinkedList<AsyncCmdBuffer>();
    SynchronizeFullDuplexApi<SpeechSynthesisParam> duplexApi;
    private ApiServiceOption serviceOption;
    private Emitter<String> textEmitter;
    private ResultCallback<SpeechSynthesisResult> callback;
    private SpeechSynthesisState state = SpeechSynthesisState.IDLE;
    private AtomicReference<CountDownLatch> stopLatch = new AtomicReference<Object>(null);
    private SpeechSynthesisParam parameters;
    private ByteBuffer audioData;
    private ByteArrayOutputStream outputStream;
    private String preRequestId = null;
    private boolean isFirst = true;
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private boolean asyncCall = false;
    private long startStreamTimeStamp = -1L;
    private long firstPackageTimeStamp = -1L;
    private double recvAudioLength = 0.0;

    public SpeechSynthesizer(SpeechSynthesisParam param, ResultCallback<SpeechSynthesisResult> callback, String baseUrl, ConnectionOptions connectionOptions) {
        if (param == null) {
            throw new ApiException(new InputRequiredException("Parameter invalid: StreamInputTtsParam is null"));
        }
        this.parameters = param;
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.TEXT_TO_SPEECH.getValue())).function(Function.SPEECH_SYNTHESIZER.getValue())).baseWebSocketUrl(baseUrl)).build();
        this.duplexApi = new SynchronizeFullDuplexApi(connectionOptions, this.serviceOption);
        this.callback = callback;
        this.asyncCall = this.callback != null;
    }

    public SpeechSynthesizer(String baseUrl, ConnectionOptions connectionOptions) {
        this.parameters = null;
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.TEXT_TO_SPEECH.getValue())).function(Function.SPEECH_SYNTHESIZER.getValue())).baseWebSocketUrl(baseUrl)).build();
        this.duplexApi = new SynchronizeFullDuplexApi(connectionOptions, this.serviceOption);
        this.callback = null;
    }

    public SpeechSynthesizer() {
        this.parameters = null;
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.TEXT_TO_SPEECH.getValue())).function(Function.SPEECH_SYNTHESIZER.getValue())).build();
        this.duplexApi = new SynchronizeFullDuplexApi(this.serviceOption);
        this.callback = null;
    }

    public void updateParamAndCallback(SpeechSynthesisParam param, ResultCallback<SpeechSynthesisResult> callback) {
        this.parameters = param;
        this.callback = callback;
        this.stopLatch = new AtomicReference<Object>(null);
        this.cmdBuffer.clear();
        this.textEmitter = null;
        this.isFirst = true;
        this.asyncCall = this.callback != null;
    }

    public SpeechSynthesizer(SpeechSynthesisParam param, ResultCallback<SpeechSynthesisResult> callback, String baseUrl) {
        if (param == null) {
            throw new ApiException(new InputRequiredException("Parameter invalid: SpeechSynthesisParam is null"));
        }
        this.parameters = param;
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.TEXT_TO_SPEECH.getValue())).function(Function.SPEECH_SYNTHESIZER.getValue())).baseWebSocketUrl(baseUrl)).build();
        this.duplexApi = new SynchronizeFullDuplexApi(this.serviceOption);
        this.callback = callback;
        this.asyncCall = this.callback != null;
    }

    public SpeechSynthesizer(SpeechSynthesisParam param, ResultCallback<SpeechSynthesisResult> callback) {
        if (param == null) {
            throw new ApiException(new InputRequiredException("Parameter invalid: StreamInputTtsParam is null"));
        }
        this.parameters = param;
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.TEXT_TO_SPEECH.getValue())).function(Function.SPEECH_SYNTHESIZER.getValue())).build();
        this.duplexApi = new SynchronizeFullDuplexApi(this.serviceOption);
        this.callback = callback;
        this.asyncCall = this.callback != null;
    }

    public String getLastRequestId() {
        return this.preRequestId;
    }

    public Flowable<SpeechSynthesisResult> streamingCallAsFlowable(Flowable<String> textStream) throws ApiException, NoApiKeyException {
        this.startStreamTimeStamp = System.currentTimeMillis();
        this.recvAudioLength = 0.0;
        this.preRequestId = UUID.randomUUID().toString();
        return this.duplexApi.duplexCall(StreamInputTtsParamWithStream.fromStreamInputTtsParam(this.parameters, textStream, this.preRequestId)).map(SpeechSynthesisResult::fromDashScopeResult).filter(item -> !this.canceled.get()).doOnNext(result -> {
            if (result.getAudioFrame() != null) {
                if (this.recvAudioLength == 0.0) {
                    this.firstPackageTimeStamp = System.currentTimeMillis();
                    log.debug("[TtsV2] first package delay: " + this.getFirstPackageDelay() + " ms");
                }
                this.recvAudioLength += (double)result.getAudioFrame().capacity() / ((double)(2 * this.parameters.getFormat().getSampleRate()) / 1000.0);
                long current = System.currentTimeMillis();
                double currentRtf = (double)(current - this.startStreamTimeStamp) / this.recvAudioLength;
                log.debug("[TtsV2] Recv Audio Binary: " + result.getAudioFrame().capacity() + " bytes, total audio " + this.recvAudioLength + " ms, current_rtf: " + currentRtf);
            }
        });
    }

    public Flowable<SpeechSynthesisResult> callAsFlowable(String text) throws ApiException, NoApiKeyException {
        this.startStreamTimeStamp = System.currentTimeMillis();
        this.recvAudioLength = 0.0;
        this.preRequestId = UUID.randomUUID().toString();
        return this.duplexApi.duplexCall(StreamInputTtsParamWithStream.fromStreamInputTtsParam(this.parameters, (Flowable<String>)Flowable.create(emitter -> new Thread(() -> {
            emitter.onNext((Object)text);
            emitter.onComplete();
        }).start(), (BackpressureStrategy)BackpressureStrategy.BUFFER), this.preRequestId)).map(SpeechSynthesisResult::fromDashScopeResult).doOnNext(result -> {
            if (result.getAudioFrame() != null) {
                if (this.recvAudioLength == 0.0) {
                    this.firstPackageTimeStamp = System.currentTimeMillis();
                    log.debug("[TtsV2] first package delay: " + this.getFirstPackageDelay() + " ms");
                }
                this.recvAudioLength += (double)result.getAudioFrame().capacity() / ((double)(2 * this.parameters.getFormat().getSampleRate()) / 1000.0);
                long current = System.currentTimeMillis();
                double currentRtf = (double)(current - this.startStreamTimeStamp) / this.recvAudioLength;
                log.debug("[TtsV2] Recv Audio Binary: " + result.getAudioFrame().capacity() + " bytes, total audio " + this.recvAudioLength + " ms, current_rtf: " + currentRtf);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStream() {
        block6: {
            this.startStreamTimeStamp = System.currentTimeMillis();
            this.recvAudioLength = 0.0;
            this.canceled.set(false);
            if (this.callback == null) {
                throw new ApiException(new InputRequiredException("Parameter invalid: ResultCallback is null"));
            }
            this.outputStream = new ByteArrayOutputStream();
            this.audioData = null;
            final WritableByteChannel channel = Channels.newChannel(this.outputStream);
            Flowable textFrames = Flowable.create(emitter -> {
                SpeechSynthesizer speechSynthesizer = this;
                synchronized (speechSynthesizer) {
                    if (this.cmdBuffer.size() > 0) {
                        for (AsyncCmdBuffer buffer : this.cmdBuffer) {
                            if (buffer.isStop) {
                                emitter.onComplete();
                                return;
                            }
                            emitter.onNext((Object)buffer.text);
                        }
                        this.cmdBuffer.clear();
                    }
                    log.debug("set textEmitter");
                    this.textEmitter = emitter;
                }
            }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
            SpeechSynthesizer speechSynthesizer = this;
            synchronized (speechSynthesizer) {
                this.state = SpeechSynthesisState.TTS_STARTED;
                this.cmdBuffer.clear();
            }
            this.stopLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
            this.preRequestId = UUID.randomUUID().toString();
            try {
                this.duplexApi.duplexCall(StreamInputTtsParamWithStream.fromStreamInputTtsParam(this.parameters, (Flowable<String>)textFrames, this.preRequestId), new ResultCallback<DashScopeResult>(){

                    @Override
                    public void onEvent(DashScopeResult message) {
                        if (SpeechSynthesizer.this.canceled.get()) {
                            return;
                        }
                        SpeechSynthesisResult speechSynthesisResult = SpeechSynthesisResult.fromDashScopeResult(message);
                        try {
                            if (speechSynthesisResult.getAudioFrame() != null) {
                                if (SpeechSynthesizer.this.recvAudioLength == 0.0) {
                                    SpeechSynthesizer.this.firstPackageTimeStamp = System.currentTimeMillis();
                                    log.debug("[TtsV2] first package delay: " + SpeechSynthesizer.this.getFirstPackageDelay() + " ms");
                                }
                                SpeechSynthesizer.this.recvAudioLength = SpeechSynthesizer.this.recvAudioLength + (double)speechSynthesisResult.getAudioFrame().capacity() / ((double)(2 * SpeechSynthesizer.this.parameters.getFormat().getSampleRate()) / 1000.0);
                                long current = System.currentTimeMillis();
                                double currentRtf = (double)(current - SpeechSynthesizer.this.startStreamTimeStamp) / SpeechSynthesizer.this.recvAudioLength;
                                log.debug("[TtsV2] Recv Audio Binary: " + speechSynthesisResult.getAudioFrame().capacity() + " bytes, total audio " + SpeechSynthesizer.this.recvAudioLength + " ms, current_rtf: " + currentRtf);
                                if (!SpeechSynthesizer.this.asyncCall) {
                                    try {
                                        channel.write(speechSynthesisResult.getAudioFrame());
                                    }
                                    catch (IOException e) {
                                        log.error("Failed to write audio: {}", (Object)speechSynthesisResult.getAudioFrame(), (Object)e);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error("Failed to parse response: {}", (Object)message, (Object)e);
                            SpeechSynthesizer.this.callback.onError(e);
                        }
                        SpeechSynthesizer.this.callback.onEvent(speechSynthesisResult);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onComplete() {
                        log.debug("[TtsV2] onComplete");
                        if (SpeechSynthesizer.this.canceled.get()) {
                            return;
                        }
                        SpeechSynthesizer speechSynthesizer = SpeechSynthesizer.this;
                        synchronized (speechSynthesizer) {
                            SpeechSynthesizer.this.state = SpeechSynthesisState.IDLE;
                        }
                        SpeechSynthesizer.this.audioData = ByteBuffer.wrap(SpeechSynthesizer.this.outputStream.toByteArray());
                        try {
                            SpeechSynthesizer.this.outputStream.close();
                        }
                        catch (IOException e) {
                            log.error("Failed to close channel: {}", (Throwable)e);
                        }
                        SpeechSynthesizer.this.callback.onComplete();
                        if (SpeechSynthesizer.this.stopLatch.get() != null) {
                            ((CountDownLatch)SpeechSynthesizer.this.stopLatch.get()).countDown();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onError(Exception e) {
                        if (SpeechSynthesizer.this.canceled.get()) {
                            return;
                        }
                        SpeechSynthesizer speechSynthesizer = SpeechSynthesizer.this;
                        synchronized (speechSynthesizer) {
                            SpeechSynthesizer.this.state = SpeechSynthesisState.IDLE;
                        }
                        ApiException apiException = new ApiException(e);
                        apiException.setStackTrace(e.getStackTrace());
                        SpeechSynthesizer.this.callback.onError(apiException);
                        if (SpeechSynthesizer.this.stopLatch.get() != null) {
                            ((CountDownLatch)SpeechSynthesizer.this.stopLatch.get()).countDown();
                        }
                    }
                });
            }
            catch (NoApiKeyException e) {
                ApiException apiException = new ApiException(e);
                apiException.setStackTrace(e.getStackTrace());
                this.callback.onError(apiException);
                if (this.stopLatch.get() == null) break block6;
                this.stopLatch.get().countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitText(String text) {
        if (Objects.equals(text, "")) {
            throw new ApiException(new InputRequiredException("Parameter invalid: text is null"));
        }
        SpeechSynthesizer speechSynthesizer = this;
        synchronized (speechSynthesizer) {
            if (this.state != SpeechSynthesisState.TTS_STARTED) {
                throw new ApiException(new InputRequiredException("State invalid: expect stream input tts state is started but " + this.state.getValue()));
            }
            if (this.textEmitter == null) {
                log.debug("submitText to new emitter: " + text);
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().text(text)).build());
            } else {
                log.debug("submitText to emitter: " + text);
                this.textEmitter.onNext((Object)text);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamingComplete(long completeTimeoutMillis) throws RuntimeException {
        log.debug("streamingComplete with timeout: " + completeTimeoutMillis);
        SpeechSynthesizer speechSynthesizer = this;
        synchronized (speechSynthesizer) {
            if (this.state != SpeechSynthesisState.TTS_STARTED) {
                throw new ApiException(new RuntimeException("State invalid: expect stream input tts state is started but " + this.state.getValue()));
            }
            if (this.textEmitter == null) {
                log.debug("adding stop to new emitter");
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().isStop(true)).build());
            } else {
                log.debug("adding stop to emitter");
                this.textEmitter.onComplete();
            }
        }
        if (this.stopLatch.get() != null) {
            try {
                if (completeTimeoutMillis > 0L) {
                    log.debug("start waiting for stopLatch");
                    if (!this.stopLatch.get().await(completeTimeoutMillis, TimeUnit.MILLISECONDS)) {
                        throw new RuntimeException("TimeoutError: waiting for streaming complete");
                    }
                } else {
                    log.debug("start waiting for stopLatch");
                    this.stopLatch.get().await();
                }
                log.debug("stopLatch is done");
            }
            catch (InterruptedException ignored) {
                log.error("Interrupted while waiting for streaming complete");
            }
        }
    }

    public void streamingComplete() throws RuntimeException {
        this.streamingComplete(600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncStreamingComplete() {
        SpeechSynthesizer speechSynthesizer = this;
        synchronized (speechSynthesizer) {
            if (this.state != SpeechSynthesisState.TTS_STARTED) {
                throw new ApiException(new RuntimeException("State invalid: expect stream input tts state is started but " + this.state.getValue()));
            }
            if (this.textEmitter == null) {
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().isStop(true)).build());
            } else {
                this.textEmitter.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamingCancel() {
        this.canceled.set(true);
        SpeechSynthesizer speechSynthesizer = this;
        synchronized (speechSynthesizer) {
            if (this.state != SpeechSynthesisState.TTS_STARTED) {
                return;
            }
            if (this.textEmitter == null) {
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().isStop(true)).build());
            } else {
                this.textEmitter.onComplete();
            }
        }
    }

    public void streamingCall(String text) {
        if (this.isFirst) {
            this.isFirst = false;
            this.startStream();
        }
        this.submitText(text);
    }

    public ByteBuffer call(String text, long timeoutMillis) throws RuntimeException {
        if (this.callback == null) {
            this.callback = new ResultCallback<SpeechSynthesisResult>(){

                @Override
                public void onEvent(SpeechSynthesisResult message) {
                }

                @Override
                public void onComplete() {
                }

                @Override
                public void onError(Exception e) {
                }
            };
        }
        this.startStream();
        this.submitText(text);
        if (this.asyncCall) {
            this.asyncStreamingComplete();
            return null;
        }
        this.streamingComplete(timeoutMillis);
        return this.audioData;
    }

    public ByteBuffer call(String text) throws RuntimeException {
        return this.call(text, 0L);
    }

    public long getFirstPackageDelay() {
        return this.firstPackageTimeStamp - this.startStreamTimeStamp;
    }

    public SynchronizeFullDuplexApi<SpeechSynthesisParam> getDuplexApi() {
        return this.duplexApi;
    }

    public ByteBuffer getAudioData() {
        return this.audioData;
    }

    private static class StreamInputTtsParamWithStream
    extends SpeechSynthesisParam {
        @NonNull
        private Flowable<String> textStream;

        public static StreamInputTtsParamWithStream fromStreamInputTtsParam(SpeechSynthesisParam param, Flowable<String> textStream, String preRequestId) {
            return ((StreamInputTtsParamWithStreamBuilder)((StreamInputTtsParamWithStreamBuilder)((StreamInputTtsParamWithStreamBuilder)((FullDuplexParamBase.FullDuplexParamBaseBuilder)((StreamInputTtsParamWithStreamBuilder)((StreamInputTtsParamWithStreamBuilder)((StreamInputTtsParamWithStreamBuilder)((StreamInputTtsParamWithStreamBuilder)StreamInputTtsParamWithStream.builder().headers(param.getHeaders())).parameters(param.getParameters())).parameter("pre_task_id", preRequestId)).format(param.getFormat())).textStream(textStream)).model(param.getModel())).voice(param.getVoice())).apiKey(param.getApiKey())).build();
        }

        @Override
        public Flowable<Object> getStreamingData() {
            return this.textStream.map(text -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("text", text);
                return jsonObject;
            }).cast(Object.class);
        }

        protected StreamInputTtsParamWithStream(StreamInputTtsParamWithStreamBuilder<?, ?> b) {
            super((SpeechSynthesisParam.SpeechSynthesisParamBuilder<?, ?>)b);
            this.textStream = ((StreamInputTtsParamWithStreamBuilder)b).textStream;
            if (this.textStream == null) {
                throw new NullPointerException("textStream is marked non-null but is null");
            }
        }

        public static StreamInputTtsParamWithStreamBuilder<?, ?> builder() {
            return new StreamInputTtsParamWithStreamBuilderImpl();
        }

        private static final class StreamInputTtsParamWithStreamBuilderImpl
        extends StreamInputTtsParamWithStreamBuilder<StreamInputTtsParamWithStream, StreamInputTtsParamWithStreamBuilderImpl> {
            private StreamInputTtsParamWithStreamBuilderImpl() {
            }

            @Override
            protected StreamInputTtsParamWithStreamBuilderImpl self() {
                return this;
            }

            @Override
            public StreamInputTtsParamWithStream build() {
                return new StreamInputTtsParamWithStream(this);
            }
        }

        public static abstract class StreamInputTtsParamWithStreamBuilder<C extends StreamInputTtsParamWithStream, B extends StreamInputTtsParamWithStreamBuilder<C, B>>
        extends SpeechSynthesisParam.SpeechSynthesisParamBuilder<C, B> {
            private Flowable<String> textStream;

            public B textStream(@NonNull Flowable<String> textStream) {
                if (textStream == null) {
                    throw new NullPointerException("textStream is marked non-null but is null");
                }
                this.textStream = textStream;
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "SpeechSynthesizer.StreamInputTtsParamWithStream.StreamInputTtsParamWithStreamBuilder(super=" + super.toString() + ", textStream=" + this.textStream + ")";
            }
        }
    }

    private static class AsyncCmdBuffer {
        private boolean isStop;
        private String text;

        private static boolean $default$isStop() {
            return false;
        }

        protected AsyncCmdBuffer(AsyncCmdBufferBuilder<?, ?> b) {
            this.isStop = ((AsyncCmdBufferBuilder)b).isStop$set ? ((AsyncCmdBufferBuilder)b).isStop$value : AsyncCmdBuffer.$default$isStop();
            this.text = ((AsyncCmdBufferBuilder)b).text;
        }

        public static AsyncCmdBufferBuilder<?, ?> builder() {
            return new AsyncCmdBufferBuilderImpl();
        }

        private static final class AsyncCmdBufferBuilderImpl
        extends AsyncCmdBufferBuilder<AsyncCmdBuffer, AsyncCmdBufferBuilderImpl> {
            private AsyncCmdBufferBuilderImpl() {
            }

            @Override
            protected AsyncCmdBufferBuilderImpl self() {
                return this;
            }

            @Override
            public AsyncCmdBuffer build() {
                return new AsyncCmdBuffer(this);
            }
        }

        public static abstract class AsyncCmdBufferBuilder<C extends AsyncCmdBuffer, B extends AsyncCmdBufferBuilder<C, B>> {
            private boolean isStop$set;
            private boolean isStop$value;
            private String text;

            public B isStop(boolean isStop) {
                this.isStop$value = isStop;
                this.isStop$set = true;
                return this.self();
            }

            public B text(String text) {
                this.text = text;
                return this.self();
            }

            protected abstract B self();

            public abstract C build();

            public String toString() {
                return "SpeechSynthesizer.AsyncCmdBuffer.AsyncCmdBufferBuilder(isStop$value=" + this.isStop$value + ", text=" + this.text + ")";
            }
        }
    }
}

