/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.codegeneration;

import com.alibaba.dashscope.aigc.codegeneration.models.MessageParamBase;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodeGenerationParam
extends HalfDuplexServiceParam {
    private String scene;
    private List<MessageParamBase> message;

    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("scene", this.scene);
        jsonObject.add("message", (JsonElement)JsonUtils.toJsonArray(this.message));
        return jsonObject;
    }

    @Override
    public ByteBuffer getBinaryData() {
        return null;
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("model", this.getModel());
        requestObject.add("input", (JsonElement)this.getInput());
        Map<String, Object> params = this.getParameters();
        if (params == null || params.isEmpty()) {
            params = new HashMap<String, Object>();
            params.put("n", 1);
        }
        requestObject.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(params));
        return requestObject;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.getScene() == null || this.getScene().isEmpty() || this.getMessage() == null || this.getMessage().isEmpty()) {
            throw new InputRequiredException("scene and message must not all null");
        }
    }

    protected CodeGenerationParam(CodeGenerationParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.scene = ((CodeGenerationParamBuilder)b).scene;
        this.message = ((CodeGenerationParamBuilder)b).message;
    }

    public static CodeGenerationParamBuilder<?, ?> builder() {
        return new CodeGenerationParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeGenerationParam)) {
            return false;
        }
        CodeGenerationParam other = (CodeGenerationParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$scene = this.getScene();
        String other$scene = other.getScene();
        if (this$scene == null ? other$scene != null : !this$scene.equals(other$scene)) {
            return false;
        }
        List<MessageParamBase> this$message = this.getMessage();
        List<MessageParamBase> other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CodeGenerationParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $scene = this.getScene();
        result = result * 59 + ($scene == null ? 43 : $scene.hashCode());
        List<MessageParamBase> $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        return result;
    }

    public String getScene() {
        return this.scene;
    }

    public List<MessageParamBase> getMessage() {
        return this.message;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    public void setMessage(List<MessageParamBase> message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return "CodeGenerationParam(scene=" + this.getScene() + ", message=" + this.getMessage() + ")";
    }

    private static final class CodeGenerationParamBuilderImpl
    extends CodeGenerationParamBuilder<CodeGenerationParam, CodeGenerationParamBuilderImpl> {
        private CodeGenerationParamBuilderImpl() {
        }

        @Override
        protected CodeGenerationParamBuilderImpl self() {
            return this;
        }

        @Override
        public CodeGenerationParam build() {
            return new CodeGenerationParam(this);
        }
    }

    public static abstract class CodeGenerationParamBuilder<C extends CodeGenerationParam, B extends CodeGenerationParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private String scene;
        private List<MessageParamBase> message;

        public B scene(String scene) {
            this.scene = scene;
            return (B)this.self();
        }

        public B message(List<MessageParamBase> message) {
            this.message = message;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "CodeGenerationParam.CodeGenerationParamBuilder(super=" + super.toString() + ", scene=" + this.scene + ", message=" + this.message + ")";
        }
    }
}

