/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.codegeneration;

import com.alibaba.dashscope.aigc.codegeneration.CodeGenerationOutput;
import com.alibaba.dashscope.aigc.codegeneration.CodeGenerationUsage;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeGenerationResult {
    private static final Logger log = LoggerFactory.getLogger(CodeGenerationResult.class);
    private String requestId;
    private CodeGenerationUsage usage;
    private CodeGenerationOutput output;

    private CodeGenerationResult() {
    }

    public static CodeGenerationResult fromDashScopeResult(DashScopeResult dashScopeResult) {
        CodeGenerationResult result = new CodeGenerationResult();
        result.setRequestId(dashScopeResult.getRequestId());
        if (dashScopeResult.getUsage() != null) {
            result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), CodeGenerationUsage.class));
        }
        if (dashScopeResult.getOutput() != null) {
            result.setOutput(JsonUtils.fromJsonObject((JsonElement)((JsonObject)dashScopeResult.getOutput()), CodeGenerationOutput.class));
        } else {
            log.error(String.format("Result no output: %s", dashScopeResult));
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public CodeGenerationUsage getUsage() {
        return this.usage;
    }

    public CodeGenerationOutput getOutput() {
        return this.output;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setUsage(CodeGenerationUsage usage) {
        this.usage = usage;
    }

    public void setOutput(CodeGenerationOutput output) {
        this.output = output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeGenerationResult)) {
            return false;
        }
        CodeGenerationResult other = (CodeGenerationResult)o;
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        CodeGenerationUsage this$usage = this.getUsage();
        CodeGenerationUsage other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
            return false;
        }
        CodeGenerationOutput this$output = this.getOutput();
        CodeGenerationOutput other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !((Object)this$output).equals(other$output));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        CodeGenerationUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        CodeGenerationOutput $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        return result;
    }

    public String toString() {
        return "CodeGenerationResult(requestId=" + this.getRequestId() + ", usage=" + this.getUsage() + ", output=" + this.getOutput() + ")";
    }
}

