/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.filter;

import com.alibaba.druid.logging.Log;
import com.alibaba.druid.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class FilterManager {
    private static final Log LOG = LogFactory.getLog(FilterManager.class);
    private static final ConcurrentHashMap<String, String> aliasMap = new ConcurrentHashMap();

    public static final String getFilter(String alias) {
        return aliasMap.get(alias);
    }

    public static Properties loadFilterConfig() throws IOException {
        Properties filterProperties = new Properties();
        FilterManager.loadFilterConfig(filterProperties, ClassLoader.getSystemClassLoader());
        FilterManager.loadFilterConfig(filterProperties, Thread.currentThread().getContextClassLoader());
        return filterProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFilterConfig(Properties filterProperties, ClassLoader classLoader) throws IOException {
        Enumeration<URL> e = classLoader.getResources("META-INF/druid-filter.properties");
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            Properties property = new Properties();
            InputStream is = null;
            try {
                is = url.openStream();
                property.load(is);
            }
            finally {
                JdbcUtils.close(is);
            }
            filterProperties.putAll((Map<?, ?>)property);
        }
    }

    static {
        try {
            Properties filterProperties = FilterManager.loadFilterConfig();
            for (Map.Entry<Object, Object> entry : filterProperties.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("druid.filters.")) continue;
                String name = key.substring("druid.filters.".length());
                aliasMap.put(name, (String)entry.getValue());
            }
        }
        catch (Exception e) {
            LOG.error("load filter config error", e);
        }
    }
}

