/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.filter.stat;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.filter.stat.StatFilterMBean;
import com.alibaba.druid.logging.Log;
import com.alibaba.druid.logging.LogFactory;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxy;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.stat.JdbcConnectionStat;
import com.alibaba.druid.stat.JdbcDataSourceStat;
import com.alibaba.druid.stat.JdbcResultSetStat;
import com.alibaba.druid.stat.JdbcSqlStat;
import com.alibaba.druid.stat.JdbcStatContext;
import com.alibaba.druid.stat.JdbcStatManager;
import com.alibaba.druid.stat.JdbcStatementStat;
import com.alibaba.druid.util.TransactionInfo;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class StatFilter
extends FilterEventAdapter
implements StatFilterMBean {
    private static final Log LOG = LogFactory.getLog(StatFilter.class);
    public static final String ATTR_SQL = "stat.sql";
    public static final String ATTR_UPDATE_COUNT = "stat.updteCount";
    public static final String ATTR_TRANSACTION = "stat.tx";
    protected JdbcDataSourceStat dataSourceStat;
    protected final JdbcConnectionStat connectStat = JdbcStatManager.getInstance().getConnectionstat();
    protected final JdbcStatementStat statementStat = JdbcStatManager.getInstance().getStatementStat();
    protected final JdbcResultSetStat resultSetStat = JdbcStatManager.getInstance().getResultSetStat();
    private boolean connectionStackTraceEnable = false;
    protected DataSourceProxy dataSource;
    protected final AtomicLong resetCount = new AtomicLong();
    protected int maxSqlStatCount = 100000;
    public static final String ATTR_NAME_CONNECTION_STAT = "stat.conn";
    public static final String ATTR_NAME_STATEMENT_STAT = "stat.stmt";

    @Override
    public boolean isConnectionStackTraceEnable() {
        return this.connectionStackTraceEnable;
    }

    @Override
    public void setConnectionStackTraceEnable(boolean connectionStackTraceEnable) {
        this.connectionStackTraceEnable = connectionStackTraceEnable;
    }

    public JdbcDataSourceStat getDataSourceStat() {
        return this.dataSourceStat;
    }

    public int getMaxSqlStatCount() {
        return this.maxSqlStatCount;
    }

    public void setMaxSqlStatCount(int maxSqlStatCount) {
        this.maxSqlStatCount = maxSqlStatCount;
    }

    @Override
    public void reset() {
        this.dataSourceStat.reset();
        this.resetCount.incrementAndGet();
    }

    @Override
    public long getResetCount() {
        return this.resetCount.get();
    }

    @Override
    public void init(DataSourceProxy dataSource) {
        String url;
        this.dataSource = dataSource;
        ConcurrentMap<String, JdbcDataSourceStat> dataSourceStats = JdbcStatManager.getInstance().getDataSources();
        JdbcDataSourceStat stat = (JdbcDataSourceStat)dataSourceStats.get(url = dataSource.getUrl());
        if (stat == null) {
            dataSourceStats.putIfAbsent(url, new JdbcDataSourceStat(dataSource.getName(), url));
            stat = (JdbcDataSourceStat)dataSourceStats.get(url);
        }
        this.dataSourceStat = stat;
    }

    @Override
    public void connection_setAutoCommit(FilterChain chain, ConnectionProxy connection, boolean autoCommit) throws SQLException {
        Map<String, Object> attributes = connection.getAttributes();
        if (!autoCommit) {
            TransactionInfo transInfo = (TransactionInfo)attributes.get(ATTR_TRANSACTION);
            if (transInfo == null) {
                long transactionId = connection.getDirectDataSource().createTransactionId();
                transInfo = new TransactionInfo(transactionId);
                attributes.put(ATTR_TRANSACTION, transInfo);
                this.dataSourceStat.getConnectionStat().incrementConnectionCommitCount();
            }
        } else {
            attributes.remove(ATTR_TRANSACTION);
        }
        chain.connection_setAutoCommit(connection, autoCommit);
    }

    @Override
    public ConnectionProxy connection_connect(FilterChain chain, Properties info) throws SQLException {
        long nanoSpan;
        ConnectionProxy connection = null;
        long startNano = System.nanoTime();
        long startTime = System.currentTimeMillis();
        long nowTime = System.currentTimeMillis();
        this.connectStat.beforeConnect();
        this.dataSourceStat.getConnectionStat().beforeConnect();
        try {
            connection = super.connection_connect(chain, info);
            nanoSpan = System.nanoTime() - startNano;
        }
        catch (SQLException ex) {
            this.connectStat.connectError(ex);
            this.dataSourceStat.getConnectionStat().connectError(ex);
            throw ex;
        }
        this.connectStat.afterConnected(nanoSpan);
        this.dataSourceStat.getConnectionStat().afterConnected(nanoSpan);
        if (connection != null) {
            JdbcConnectionStat.Entry statEntry = this.getConnectionInfo(connection);
            this.dataSourceStat.getConnections().put(connection.getId(), statEntry);
            statEntry.setConnectTime(new Date(startTime));
            statEntry.setConnectTimespanNano(nanoSpan);
            statEntry.setEstablishNano(System.nanoTime());
            statEntry.setEstablishTime(nowTime);
            statEntry.setConnectStackTrace(new Exception());
            this.connectStat.setActiveCount(this.dataSourceStat.getConnections().size());
            this.dataSourceStat.getConnectionStat().setActiveCount(this.dataSourceStat.getConnections().size());
        }
        return connection;
    }

    @Override
    public void connection_close(FilterChain chain, ConnectionProxy connection) throws SQLException {
        long nowNano = System.nanoTime();
        this.connectStat.incrementConnectionCloseCount();
        this.dataSourceStat.getConnectionStat().incrementConnectionCloseCount();
        JdbcConnectionStat.Entry connectionInfo = this.getConnectionInfo(connection);
        long aliveNanoSpan = nowNano - connectionInfo.getEstablishNano();
        JdbcConnectionStat.Entry existsConnection = (JdbcConnectionStat.Entry)this.dataSourceStat.getConnections().remove(connection.getId());
        if (existsConnection != null) {
            this.connectStat.afterClose(aliveNanoSpan);
            this.dataSourceStat.getConnectionStat().afterClose(aliveNanoSpan);
        }
        super.connection_close(chain, connection);
    }

    @Override
    public void connection_commit(FilterChain chain, ConnectionProxy connection) throws SQLException {
        super.connection_commit(chain, connection);
        this.handleEndTransaction(connection);
        this.connectStat.incrementConnectionCommitCount();
        this.dataSourceStat.getConnectionStat().incrementConnectionCommitCount();
    }

    private void handleEndTransaction(ConnectionProxy connection) {
        Map<String, Object> attributes = connection.getAttributes();
        TransactionInfo transInfo = (TransactionInfo)attributes.remove(ATTR_TRANSACTION);
        if (transInfo != null) {
            transInfo.setEndTimeMillis(System.currentTimeMillis());
        }
    }

    @Override
    public void connection_rollback(FilterChain chain, ConnectionProxy connection) throws SQLException {
        super.connection_rollback(chain, connection);
        this.handleEndTransaction(connection);
        this.connectStat.incrementConnectionRollbackCount();
        this.dataSourceStat.getConnectionStat().incrementConnectionRollbackCount();
        this.dataSourceStat.getConnectionStat().incrementConnectionRollbackCount();
    }

    @Override
    public void connection_rollback(FilterChain chain, ConnectionProxy connection, Savepoint savepoint) throws SQLException {
        super.connection_rollback(chain, connection, savepoint);
        this.handleEndTransaction(connection);
        this.connectStat.incrementConnectionRollbackCount();
        this.dataSourceStat.getConnectionStat().incrementConnectionRollbackCount();
    }

    @Override
    public void statementCreateAfter(StatementProxy statement) {
        this.statementStat.incrementCreateCounter();
        this.dataSourceStat.getStatementStat().incrementCreateCounter();
        super.statementCreateAfter(statement);
    }

    @Override
    public void statementPrepareCallAfter(CallableStatementProxy statement) {
        this.statementStat.incrementPrepareCallCount();
        this.dataSourceStat.getStatementStat().incrementPrepareCallCount();
        JdbcSqlStat sqlStat = this.createSqlStat(statement, statement.getSql());
        statement.getAttributes().put(ATTR_SQL, sqlStat);
    }

    @Override
    public void statementPrepareAfter(PreparedStatementProxy statement) {
        this.statementStat.incrementPrepareCounter();
        this.dataSourceStat.getStatementStat().incrementPrepareCounter();
        JdbcSqlStat sqlStat = this.createSqlStat(statement, statement.getSql());
        statement.getAttributes().put(ATTR_SQL, sqlStat);
    }

    @Override
    public void statement_close(FilterChain chain, StatementProxy statement) throws SQLException {
        super.statement_close(chain, statement);
        this.statementStat.incrementStatementCloseCounter();
        this.dataSourceStat.getStatementStat().incrementStatementCloseCounter();
    }

    @Override
    protected void statementExecuteUpdateBefore(StatementProxy statement, String sql) {
        this.internalBeforeStatementExecute(statement, sql);
    }

    @Override
    protected void statementExecuteUpdateAfter(StatementProxy statement, String sql, int updateCount) {
        this.internalAfterStatementExecute(statement, updateCount);
    }

    @Override
    protected void statementExecuteQueryBefore(StatementProxy statement, String sql) {
        this.internalBeforeStatementExecute(statement, sql);
    }

    @Override
    protected void statementExecuteQueryAfter(StatementProxy statement, String sql, ResultSetProxy resultSet) {
        this.internalAfterStatementExecute(statement, new int[0]);
    }

    @Override
    protected void statementExecuteBefore(StatementProxy statement, String sql) {
        this.internalBeforeStatementExecute(statement, sql);
    }

    @Override
    protected void statementExecuteAfter(StatementProxy statement, String sql, boolean result) {
        this.internalAfterStatementExecute(statement, new int[0]);
    }

    @Override
    protected void statementExecuteBatchBefore(StatementProxy statement) {
        String sql = statement.getBatchSql();
        int batchSize = statement.getBatchSqlList().size();
        JdbcSqlStat sqlStat = StatFilter.getSqlStat(statement);
        if (sqlStat == null) {
            sqlStat = this.createSqlStat(statement, sql);
            statement.getAttributes().put(ATTR_SQL, sqlStat);
        }
        if (sqlStat != null) {
            sqlStat.addExecuteBatchCount(batchSize);
        }
        this.internalBeforeStatementExecute(statement, sql);
    }

    @Override
    protected void statementExecuteBatchAfter(StatementProxy statement, int[] result) {
        this.internalAfterStatementExecute(statement, result);
    }

    private final void internalBeforeStatementExecute(StatementProxy statement, String sql) {
        JdbcStatContext statContext;
        JdbcSqlStat sqlStat;
        this.statementStat.beforeExecute();
        this.dataSourceStat.getStatementStat().beforeExecute();
        JdbcStatementStat.Entry statementStat = this.getStatementInfo(statement);
        ConnectionProxy connection = statement.getConnectionProxy();
        JdbcConnectionStat.Entry connectionCounter = this.getConnectionInfo(connection);
        statementStat.setLastExecuteStartNano(System.nanoTime());
        statementStat.setLastExecuteSql(sql);
        connectionCounter.setLastSql(sql);
        if (this.connectionStackTraceEnable) {
            connectionCounter.setLastStatementStatckTrace(new Exception());
        }
        if ((sqlStat = StatFilter.getSqlStat(statement)) == null) {
            sqlStat = this.createSqlStat(statement, sql);
            statement.getAttributes().put(ATTR_SQL, sqlStat);
        }
        if ((statContext = JdbcStatManager.getInstance().getStatContext()) != null) {
            sqlStat.setName(statContext.getName());
            sqlStat.setFile(statContext.getFile());
        }
        if (sqlStat != null) {
            sqlStat.setExecuteLastStartTime(System.currentTimeMillis());
            sqlStat.incrementRunningCount();
        }
        statement.getAttributes().put(ATTR_UPDATE_COUNT, 0);
    }

    @Override
    public int statement_getUpdateCount(FilterChain chain, StatementProxy statement) throws SQLException {
        int updateCount = chain.statement_getUpdateCount(statement);
        Integer attr = (Integer)statement.getAttributes().get(ATTR_UPDATE_COUNT);
        if (attr == null) {
            statement.getAttributes().put(ATTR_UPDATE_COUNT, updateCount);
            JdbcSqlStat sqlStat = StatFilter.getSqlStat(statement);
            if (sqlStat != null) {
                sqlStat.addUpdateCount(updateCount);
            }
        }
        return updateCount;
    }

    private final void internalAfterStatementExecute(StatementProxy statement, int ... updateCountArray) {
        JdbcStatementStat.Entry entry = this.getStatementInfo(statement);
        long nowNano = System.nanoTime();
        long nanoSpan = nowNano - entry.getLastExecuteStartNano();
        this.statementStat.afterExecute(nanoSpan);
        this.dataSourceStat.getStatementStat().afterExecute(nanoSpan);
        JdbcSqlStat sqlStat = StatFilter.getSqlStat(statement);
        if (sqlStat != null) {
            sqlStat.incrementExecuteSuccessCount();
            for (int updateCount : updateCountArray) {
                sqlStat.addUpdateCount(updateCount);
            }
            sqlStat.decrementExecutingCount();
            sqlStat.addExecuteTime(nanoSpan);
        }
        if (updateCountArray.length == 1) {
            statement.getAttributes().put(ATTR_UPDATE_COUNT, updateCountArray[0]);
        }
    }

    @Override
    protected void statement_executeErrorAfter(StatementProxy statement, String sql, Throwable error) {
        JdbcStatementStat.Entry counter = this.getStatementInfo(statement);
        ConnectionProxy connection = statement.getConnectionProxy();
        JdbcConnectionStat.Entry connectionCounter = this.getConnectionInfo(connection);
        long nanoSpan = System.nanoTime() - counter.getLastExecuteStartNano();
        this.statementStat.error(error);
        this.dataSourceStat.getStatementStat().error(error);
        this.statementStat.afterExecute(nanoSpan);
        this.dataSourceStat.getStatementStat().afterExecute(nanoSpan);
        connectionCounter.error(error);
        JdbcSqlStat sqlStat = StatFilter.getSqlStat(statement);
        if (sqlStat != null) {
            sqlStat.error(error);
            sqlStat.addExecuteTime(nanoSpan);
        }
        super.statement_executeErrorAfter(statement, sql, error);
    }

    @Override
    protected void resultSetOpenAfter(ResultSetProxy resultSet) {
        this.resultSetStat.beforeOpen();
        this.dataSourceStat.getResultSetStat().beforeOpen();
        resultSet.setConstructNano(System.nanoTime());
    }

    @Override
    public void resultSet_close(FilterChain chain, ResultSetProxy resultSet) throws SQLException {
        JdbcSqlStat sqlStat;
        long nanoSpan = System.nanoTime() - resultSet.getConstructNano();
        int fetchCount = resultSet.getFetchRowCount();
        this.resultSetStat.afterClose(nanoSpan);
        this.dataSourceStat.getResultSetStat().afterClose(nanoSpan);
        this.resultSetStat.addFetchRowCount(fetchCount);
        this.dataSourceStat.getResultSetStat().addFetchRowCount(fetchCount);
        this.resultSetStat.incrementCloseCounter();
        this.dataSourceStat.getResultSetStat().incrementCloseCounter();
        String sql = resultSet.getSql();
        if (sql != null && (sqlStat = (JdbcSqlStat)this.dataSourceStat.getSqlStatMap().get(sql)) != null) {
            sqlStat.addFetchRowCount(fetchCount);
        }
        super.resultSet_close(chain, resultSet);
    }

    public JdbcConnectionStat.Entry getConnectionInfo(ConnectionProxy connection) {
        JdbcConnectionStat.Entry counter = (JdbcConnectionStat.Entry)connection.getAttributes().get(ATTR_NAME_CONNECTION_STAT);
        if (counter == null) {
            connection.getAttributes().put(ATTR_NAME_CONNECTION_STAT, new JdbcConnectionStat.Entry(this.dataSource.getName(), connection.getId()));
            counter = (JdbcConnectionStat.Entry)connection.getAttributes().get(ATTR_NAME_CONNECTION_STAT);
        }
        return counter;
    }

    public JdbcStatementStat.Entry getStatementInfo(StatementProxy statement) {
        JdbcStatementStat.Entry counter = (JdbcStatementStat.Entry)statement.getAttributes().get(ATTR_NAME_STATEMENT_STAT);
        if (counter == null) {
            statement.getAttributes().put(ATTR_NAME_STATEMENT_STAT, new JdbcStatementStat.Entry());
            counter = (JdbcStatementStat.Entry)statement.getAttributes().get(ATTR_NAME_STATEMENT_STAT);
        }
        return counter;
    }

    @Override
    public long getConnectionActiveCount() {
        return this.dataSourceStat.getConnections().size();
    }

    @Override
    public long getConnectionCloseCount() {
        return this.dataSourceStat.getConnectionStat().getCloseCount();
    }

    @Override
    public long getConnectionCommitCount() {
        return this.dataSourceStat.getConnectionStat().getCommitCount();
    }

    @Override
    public long getConnectionConnectCount() {
        return this.dataSourceStat.getConnectionStat().getConnectCount();
    }

    @Override
    public long getConnectionConnectMillis() {
        return this.dataSourceStat.getConnectionStat().getConnectMillis();
    }

    @Override
    public long getConnectionConnectingMax() {
        return this.dataSourceStat.getConnectionStat().getConnectingMax();
    }

    @Override
    public long getConnectionRollbackCount() {
        return this.dataSourceStat.getConnectionStat().getConnectMillis();
    }

    @Override
    public long getConnectionConnectAliveMillis() {
        return this.dataSourceStat.getConnectionConnectAliveMillis();
    }

    @Override
    public long getConnectionConnectErrorCount() {
        return this.dataSourceStat.getConnectionStat().getConnectErrorCount();
    }

    @Override
    public Date getConnectionConnectLastTime() {
        return this.dataSourceStat.getConnectionStat().getConnectLastTime();
    }

    @Override
    public long getStatementCloseCount() {
        return this.dataSourceStat.getStatementStat().getCloseCount();
    }

    @Override
    public long getStatementCreateCount() {
        return this.dataSourceStat.getStatementStat().getCreateCount();
    }

    @Override
    public long getStatementExecuteMillisTotal() {
        return this.dataSourceStat.getStatementStat().getExecuteMillisTotal();
    }

    @Override
    public Date getStatementExecuteErrorLastTime() {
        return this.dataSourceStat.getStatementStat().getLastErrorTime();
    }

    @Override
    public Date getStatementExecuteLastTime() {
        return this.dataSourceStat.getStatementStat().getExecuteLastTime();
    }

    @Override
    public long getStatementPrepareCallCount() {
        return this.dataSourceStat.getStatementStat().getPrepareCallCount();
    }

    @Override
    public long getStatementPrepareCount() {
        return this.dataSourceStat.getStatementStat().getPrepareCount();
    }

    @Override
    public long getStatementExecuteErrorCount() {
        return this.dataSourceStat.getStatementStat().getErrorCount();
    }

    @Override
    public long getStatementExecuteSuccessCount() {
        return this.dataSourceStat.getStatementStat().getExecuteSuccessCount();
    }

    @Override
    public long getResultSetHoldMillisTotal() {
        return this.dataSourceStat.getResultSetStat().getHoldMillisTotal();
    }

    @Override
    public long getResultSetFetchRowCount() {
        return this.dataSourceStat.getResultSetStat().getFetchRowCount();
    }

    @Override
    public long getResultSetOpenCount() {
        return this.dataSourceStat.getResultSetStat().getOpenCount();
    }

    @Override
    public long getResultSetCloseCount() {
        return this.dataSourceStat.getResultSetStat().getCloseCount();
    }

    @Override
    public String getConnectionUrl() {
        return this.dataSource.getUrl();
    }

    public JdbcSqlStat createSqlStat(StatementProxy statement, String sql) {
        ConcurrentMap<String, JdbcSqlStat> sqlStatMap = this.dataSourceStat.getSqlStatMap();
        JdbcSqlStat sqlStat = (JdbcSqlStat)sqlStatMap.get(sql);
        if (sqlStat == null) {
            if (this.dataSourceStat.getSqlStatMap().size() >= this.maxSqlStatCount) {
                return null;
            }
            JdbcSqlStat newSqlStat = new JdbcSqlStat(sql);
            if (this.dataSourceStat.getSqlStatMap().putIfAbsent(sql, newSqlStat) == null) {
                newSqlStat.setId(JdbcStatManager.getInstance().generateSqlId());
                newSqlStat.setDataSource(this.dataSource.getUrl());
            }
            sqlStat = (JdbcSqlStat)this.dataSourceStat.getSqlStatMap().get(sql);
        }
        if (sqlStat == null) {
            LOG.error("stat is null");
        }
        return sqlStat;
    }

    public static JdbcSqlStat getSqlStat(StatementProxy statement) {
        if (statement == null) {
            return null;
        }
        return (JdbcSqlStat)statement.getAttributes().get(ATTR_SQL);
    }

    public JdbcSqlStat getSqlCounter(String sql) {
        return (JdbcSqlStat)this.dataSourceStat.getSqlStatMap().get(sql);
    }

    public ConcurrentMap<String, JdbcSqlStat> getSqlStatisticMap() {
        return this.dataSourceStat.getSqlStatMap();
    }

    @Override
    public TabularData getSqlList() throws JMException {
        return this.dataSourceStat.getSqlList();
    }

    public static StatFilter getStatFilter(DataSourceProxy dataSource) {
        for (Filter filter : dataSource.getProxyFilters()) {
            if (!(filter instanceof StatFilter)) continue;
            return (StatFilter)filter;
        }
        return null;
    }

    public JdbcSqlStat getSqlStat(long id) {
        return this.dataSourceStat.getSqlStat(id);
    }

    @Override
    public CompositeData getStatementExecuteLastError() throws JMException {
        return this.dataSourceStat.getStatementStat().getLastError();
    }

    public final ConcurrentMap<Long, JdbcConnectionStat.Entry> getConnections() {
        return this.dataSourceStat.getConnections();
    }

    @Override
    public TabularData getConnectionList() throws JMException {
        return this.dataSourceStat.getConnectionList();
    }

    public static enum Feature {

        private final int mask = 1 << this.ordinal();

        public final int getMask() {
            return this.mask;
        }

        public static boolean isEnabled(int features, Feature feature) {
            return (features & feature.getMask()) != 0;
        }

        public static int config(int features, Feature feature, boolean state) {
            features = state ? (features |= feature.getMask()) : (features &= ~feature.getMask());
            return features;
        }
    }
}

