/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.filter.trace;

import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.trace.TraceAfterEvent;
import com.alibaba.druid.filter.trace.TraceErrorEvent;
import com.alibaba.druid.filter.trace.TraceEvent;
import com.alibaba.druid.filter.trace.TraceFilterMBean;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxy;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.stat.JdbcStatContext;
import com.alibaba.druid.stat.JdbcStatManager;
import com.alibaba.druid.stat.JdbcTraceManager;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class TraceFilter
extends FilterAdapter
implements TraceFilterMBean {
    public static final String ATTR_NAME_RESULT_SET = "trace.rs";
    public static final String TRACE_CONN_ID = "conn.id";
    public static final String TRACE_CONN_INFO = "conn.info";
    public static final String TRACE_CONN_CONNECTED_TIME = "conn.connectedTime";
    public static final String TRACE_STMT_ID = "stmt.id";
    public static final String TRACE_STMT_SQL = "stmt.sql";
    public static final String TRACE_STMT_PARAMS = "stmt.params";
    public static final String TRACE_STMT_UPDATE_COUNT = "stmt.updateCount";
    public static final String TRACE_STMT_COLUMN_INDEXES = "stmt.columnIndexes";
    public static final String TRACE_RS_ID = "rs.id";
    public static final String TRACE_RS_CURSOR_INDEX = "rs.cusorIndex";

    public boolean isTraceConnectionEnable() {
        return this.isTraceEnable();
    }

    public boolean isTraceStatementEnable() {
        return this.isTraceEnable();
    }

    public boolean isTraceResultSetEnable() {
        return this.isTraceEnable();
    }

    public boolean isTraceEnable() {
        JdbcStatContext statContext = JdbcStatManager.getInstance().getStatContext();
        if (statContext == null) {
            return JdbcTraceManager.getInstance().isTraceEnable();
        }
        return statContext.isTraceEnable();
    }

    public static String getAttrNameResultSet() {
        return ATTR_NAME_RESULT_SET;
    }

    @Override
    public ConnectionProxy connection_connect(FilterChain chain, Properties info) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_connect(info);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionConnectBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, info.clone());
        this.fireEvent(event);
        try {
            ConnectionProxy conn = chain.connection_connect(info);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionConnectAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, info.clone());
            event2.putContext(TRACE_CONN_ID, conn.getId());
            this.fireEvent(event2);
            return conn;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionConnectError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, info.clone());
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionConnectError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, info.clone());
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public void connection_close(FilterChain chain, ConnectionProxy connection) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            chain.connection_close(connection);
            return;
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionCloseBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        this.fireEvent(event);
        try {
            chain.connection_close(connection);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionCloseAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event2);
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionCloseError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionCloseError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public void connection_commit(FilterChain chain, ConnectionProxy connection) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            chain.connection_commit(connection);
            return;
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionCommitBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        this.fireEvent(event);
        try {
            chain.connection_commit(connection);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionCommitAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event2);
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionCommitError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionCommitError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public void connection_rollback(FilterChain chain, ConnectionProxy connection) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            chain.connection_rollback(connection);
            return;
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionRollbackBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        this.fireEvent(event);
        try {
            chain.connection_rollback(connection);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionRollbackAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event2);
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionRollbackError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionRollbackError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public void connection_rollback(FilterChain chain, ConnectionProxy connection, Savepoint savepoint) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            chain.connection_rollback(connection, savepoint);
            return;
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionRollbackBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        if (savepoint != null) {
            event.putContext("savepointId", savepoint.getSavepointId());
            event.putContext("savepointName", savepoint.getSavepointName());
        }
        this.fireEvent(event);
        try {
            chain.connection_rollback(connection, savepoint);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionRollbackAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            if (savepoint != null) {
                event2.putContext("savepointId", savepoint.getSavepointId());
                event2.putContext("savepointName", savepoint.getSavepointName());
            }
            this.fireEvent(event2);
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionRollbackError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            if (savepoint != null) {
                event3.putContext("savepointId", savepoint.getSavepointId());
                event3.putContext("savepointName", savepoint.getSavepointName());
            }
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionRollbackError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            if (savepoint != null) {
                event4.putContext("savepointId", savepoint.getSavepointId());
                event4.putContext("savepointName", savepoint.getSavepointName());
            }
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_prepareStatement(connection, sql);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionPrepareStatementBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        this.fireEvent(event);
        try {
            PreparedStatementProxy statement = chain.connection_prepareStatement(connection, sql);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionPrepareStatementAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int autoGeneratedKeys) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_prepareStatement(connection, sql, autoGeneratedKeys);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionPrepareStatementBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
        this.fireEvent(event);
        try {
            PreparedStatementProxy statement = chain.connection_prepareStatement(connection, sql, autoGeneratedKeys);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionPrepareStatementAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionPrepareStatementBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext("stmt.resultSetType", resultSetType);
        event.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
        this.fireEvent(event);
        try {
            PreparedStatementProxy statement = chain.connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionPrepareStatementAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext("stmt.resultSetType", resultSetType);
            event2.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext("stmt.resultSetType", resultSetType);
            event3.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext("stmt.resultSetType", resultSetType);
            event4.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionPrepareStatementBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext("stmt.resultSetType", resultSetType);
        event.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
        event.putContext("stmt.resultSetHoldability", resultSetHoldability);
        this.fireEvent(event);
        try {
            PreparedStatementProxy statement = chain.connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionPrepareStatementAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext("stmt.resultSetType", resultSetType);
            event2.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            event2.putContext("stmt.resultSetHoldability", resultSetHoldability);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext("stmt.resultSetType", resultSetType);
            event3.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            event3.putContext("stmt.resultSetHoldability", resultSetHoldability);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext("stmt.resultSetType", resultSetType);
            event4.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            event4.putContext("stmt.resultSetHoldability", resultSetHoldability);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int[] columnIndexes) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_prepareStatement(connection, sql, columnIndexes);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionPrepareStatementBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
        this.fireEvent(event);
        try {
            PreparedStatementProxy statement = chain.connection_prepareStatement(connection, sql, columnIndexes);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionPrepareStatementAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, String[] columnNames) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_prepareStatement(connection, sql, columnNames);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionPrepareStatementBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext("stmt.columnNames", columnNames);
        this.fireEvent(event);
        try {
            PreparedStatementProxy statement = chain.connection_prepareStatement(connection, sql, columnNames);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionPrepareStatementAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext("stmt.columnNames", columnNames);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext("stmt.columnNames", columnNames);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionPrepareStatementError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext("stmt.columnNames", columnNames);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_prepareCall(connection, sql);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionPrecallBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        this.fireEvent(event);
        try {
            CallableStatementProxy statement = chain.connection_prepareCall(connection, sql);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionPrecallAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionPrecallError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionPrecallError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionPrecallBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext("stmt.resultSetType", resultSetType);
        event.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
        this.fireEvent(event);
        try {
            CallableStatementProxy statement = chain.connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionPrecallAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext("stmt.resultSetType", resultSetType);
            event2.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionPrecallError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext("stmt.resultSetType", resultSetType);
            event3.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionPrecallError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext("stmt.resultSetType", resultSetType);
            event4.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionPrecallBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext("stmt.resultSetType", resultSetType);
        event.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
        event.putContext("stmt.resultSetHoldability", resultSetHoldability);
        this.fireEvent(event);
        try {
            CallableStatementProxy statement = chain.connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionPrecallAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext("stmt.resultSetType", resultSetType);
            event2.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            event2.putContext("stmt.resultSetHoldability", resultSetHoldability);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionPrecallError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext("stmt.resultSetType", resultSetType);
            event3.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            event3.putContext("stmt.resultSetHoldability", resultSetHoldability);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionPrecallError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext("stmt.resultSetType", resultSetType);
            event4.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            event4.putContext("stmt.resultSetHoldability", resultSetHoldability);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public StatementProxy connection_createStatement(FilterChain chain, ConnectionProxy connection) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_createStatement(connection);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionCreateStatementBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        this.fireEvent(event);
        try {
            StatementProxy statement = chain.connection_createStatement(connection);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionCreateStatementAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionCreateStatementError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionCreateStatementError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public StatementProxy connection_createStatement(FilterChain chain, ConnectionProxy connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_createStatement(connection, resultSetType, resultSetConcurrency);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionCreateStatementBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext("stmt.resultSetType", resultSetType);
        event.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
        this.fireEvent(event);
        try {
            StatementProxy statement = chain.connection_createStatement(connection, resultSetType, resultSetType);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionCreateStatementAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext("stmt.resultSetType", resultSetType);
            event2.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionCreateStatementError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext("stmt.resultSetType", resultSetType);
            event3.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionCreateStatementError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext("stmt.resultSetType", resultSetType);
            event4.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public StatementProxy connection_createStatement(FilterChain chain, ConnectionProxy connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.isTraceConnectionEnable()) {
            return chain.connection_createStatement(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        long startMillis = System.currentTimeMillis();
        TraceEvent event = new TraceEvent("ConnectionCreateStatementBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext("stmt.resultSetType", resultSetType);
        event.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
        event.putContext("stmt.resultSetHoldability", resultSetHoldability);
        this.fireEvent(event);
        try {
            StatementProxy statement = chain.connection_createStatement(connection, resultSetType, resultSetType, resultSetHoldability);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("ConnectionCreateStatementAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext("stmt.resultSetType", resultSetType);
            event2.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            event2.putContext("stmt.resultSetHoldability", resultSetHoldability);
            this.fireEvent(event2);
            return statement;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("ConnectionCreateStatementError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext("stmt.resultSetType", resultSetType);
            event3.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            event3.putContext("stmt.resultSetHoldability", resultSetHoldability);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("ConnectionCreateStatementError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext("stmt.resultSetType", resultSetType);
            event4.putContext("stmt.resultSetConcurrency", resultSetConcurrency);
            event4.putContext("stmt.resultSetHoldability", resultSetHoldability);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.statement_execute(statement, sql);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementExecuteBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        this.fireEvent(event);
        try {
            boolean result = chain.statement_execute(statement, sql);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementExecuteAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event2);
            return result;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementExecuteError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementExecuteError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.statement_execute(statement, sql, autoGeneratedKeys);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementExecuteBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
        this.fireEvent(event);
        try {
            boolean result = chain.statement_execute(statement, sql, autoGeneratedKeys);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementExecuteAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
            this.fireEvent(event2);
            return result;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementExecuteError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementExecuteError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.statement_execute(statement, sql, columnIndexes);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementExecuteBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
        this.fireEvent(event);
        try {
            boolean result = chain.statement_execute(statement, sql, columnIndexes);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementExecuteAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
            this.fireEvent(event2);
            return result;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementExecuteError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementExecuteError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.statement_execute(statement, sql, columnNames);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementExecuteBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext(TRACE_STMT_COLUMN_INDEXES, columnNames);
        this.fireEvent(event);
        try {
            boolean result = chain.statement_execute(statement, sql, columnNames);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementExecuteAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext("stmt.columnNames", columnNames);
            this.fireEvent(event2);
            return result;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementExecuteError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext(TRACE_STMT_COLUMN_INDEXES, columnNames);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementExecuteError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext(TRACE_STMT_COLUMN_INDEXES, columnNames);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public int[] statement_executeBatch(FilterChain chain, StatementProxy statement) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.statement_executeBatch(statement);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementExecuteBatchBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        this.fireEvent(event);
        try {
            int[] updateCounts = chain.statement_executeBatch(statement);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementExecuteBatchAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext("stmt.updateCounts", updateCounts);
            this.fireEvent(event2);
            return updateCounts;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementExecuteBatchError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementExecuteBatchError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public ResultSetProxy statement_executeQuery(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.statement_executeQuery(statement, sql);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementExecuteQueryBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        this.fireEvent(event);
        try {
            ResultSetProxy resultSet = chain.statement_executeQuery(statement, sql);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementExecuteQueryAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext(TRACE_RS_ID, resultSet.getId());
            this.fireEvent(event2);
            this.resultSetOpenAfter(resultSet);
            return resultSet;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementExecuteQueryError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementExecuteQueryError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.statement_executeUpdate(statement, sql);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementExecuteUpdateBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        this.fireEvent(event);
        try {
            int updateCount = chain.statement_executeUpdate(statement, sql);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementExecuteUpdateAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext(TRACE_STMT_UPDATE_COUNT, updateCount);
            this.fireEvent(event2);
            return updateCount;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementExecuteUpdateError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementExecuteUpdateError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.statement_executeUpdate(statement, sql, autoGeneratedKeys);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementExecuteUpdateBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
        this.fireEvent(event);
        try {
            int updateCount = chain.statement_executeUpdate(statement, sql, autoGeneratedKeys);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementExecuteUpdateAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
            event2.putContext(TRACE_STMT_UPDATE_COUNT, updateCount);
            this.fireEvent(event2);
            return updateCount;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementExecuteUpdateError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementExecuteUpdateError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext("stmt.autoGeneratedKeys", autoGeneratedKeys);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.statement_executeUpdate(statement, sql, columnIndexes);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementExecuteUpdateBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
        this.fireEvent(event);
        try {
            int updateCount = chain.statement_executeUpdate(statement, sql, columnIndexes);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementExecuteUpdateAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
            event2.putContext(TRACE_STMT_UPDATE_COUNT, updateCount);
            this.fireEvent(event2);
            return updateCount;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementExecuteUpdateError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementExecuteUpdateError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext(TRACE_STMT_COLUMN_INDEXES, columnIndexes);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.statement_executeUpdate(statement, sql, columnNames);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementExecuteUpdateBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        event.putContext("stmt.columnNames", columnNames);
        this.fireEvent(event);
        try {
            int updateCount = chain.statement_executeUpdate(statement, sql, columnNames);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementExecuteUpdateAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            event2.putContext("stmt.columnNames", columnNames);
            event2.putContext(TRACE_STMT_UPDATE_COUNT, updateCount);
            this.fireEvent(event2);
            return updateCount;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementExecuteUpdateError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            event3.putContext("stmt.columnNames", columnNames);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementExecuteUpdateError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            event4.putContext("stmt.columnNames", columnNames);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public void statement_addBatch(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            chain.statement_addBatch(statement, sql);
            return;
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementAddBatchBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, sql);
        this.fireEvent(event);
        try {
            chain.statement_addBatch(statement, sql);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementAddBatchAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event2);
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementAddBatchError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementAddBatchError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, sql);
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public void statement_cancel(FilterChain chain, StatementProxy statement) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            chain.statement_cancel(statement);
            return;
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementCancelBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        this.fireEvent(event);
        try {
            chain.statement_cancel(statement);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementCancelAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event2);
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementCancelError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementCancelError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public void statement_clearBatch(FilterChain chain, StatementProxy statement) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            chain.statement_clearBatch(statement);
            return;
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementClearBatchBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        this.fireEvent(event);
        try {
            chain.statement_clearBatch(statement);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementClearBatchAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event2);
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementClearBatchError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementClearBatchError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public void statement_close(FilterChain chain, StatementProxy statement) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            chain.statement_close(statement);
            return;
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("StatementCloseBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        this.fireEvent(event);
        try {
            chain.statement_close(statement);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("StatementCloseAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event2);
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("StatementCloseError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("StatementCloseError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public ResultSetProxy statement_getGeneratedKeys(FilterChain chain, StatementProxy statement) throws SQLException {
        ResultSetProxy resultSet = super.statement_getGeneratedKeys(chain, statement);
        if (resultSet != null) {
            this.resultSetOpenAfter(resultSet);
        }
        return resultSet;
    }

    @Override
    public ResultSetProxy statement_getResultSet(FilterChain chain, StatementProxy statement) throws SQLException {
        ResultSetProxy resultSet = super.statement_getResultSet(chain, statement);
        if (resultSet != null) {
            this.resultSetOpenAfter(resultSet);
        }
        return resultSet;
    }

    protected SortedMap<Integer, Object> getParameters(PreparedStatementProxy statement) throws SQLException {
        TreeMap parameters = (TreeMap)statement.getAttributes().get("trace.stmt.params");
        if (parameters == null) {
            parameters = new TreeMap();
            statement.getAttributes().put("trace.stmt.params", parameters);
        }
        return parameters;
    }

    @Override
    public boolean preparedStatement_execute(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.preparedStatement_execute(statement);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("PreparedStatementExecuteBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, statement.getSql());
        event.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
        this.fireEvent(event);
        try {
            boolean firstResultSet = chain.preparedStatement_execute(statement);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("PreparedStatementExecuteAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, statement.getSql());
            event2.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            event2.putContext("stmt.firstResultSet", firstResultSet);
            this.fireEvent(event2);
            return firstResultSet;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("PreparedStatementExecuteError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, statement.getSql());
            event3.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("PreparedStatementExecuteError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, statement.getSql());
            event4.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public ResultSetProxy preparedStatement_executeQuery(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.preparedStatement_executeQuery(statement);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("PreparedStatementExecuteQueryBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, statement.getSql());
        event.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
        this.fireEvent(event);
        try {
            ResultSetProxy resultSet = chain.preparedStatement_executeQuery(statement);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("PreparedStatementExecuteQueryAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, statement.getSql());
            event2.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            event2.putContext(TRACE_RS_ID, resultSet.getId());
            this.fireEvent(event2);
            this.resultSetOpenAfter(resultSet);
            return resultSet;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("PreparedStatementExecuteQueryError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, statement.getSql());
            event3.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("PreparedStatementExecuteQueryError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, statement.getSql());
            event4.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public int preparedStatement_executeUpdate(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            return chain.preparedStatement_executeUpdate(statement);
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("PreparedStatementExecuteUpdateBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, statement.getSql());
        event.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
        this.fireEvent(event);
        try {
            int updateCount = chain.preparedStatement_executeUpdate(statement);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("PreparedStatementExecuteQueryAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, statement.getSql());
            event2.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            event2.putContext(TRACE_STMT_UPDATE_COUNT, updateCount);
            this.fireEvent(event2);
            return updateCount;
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("PreparedStatementExecuteUpdateError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, statement.getSql());
            event3.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("PreparedStatementExecuteUpdateError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, statement.getSql());
            event4.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public void preparedStatement_clearParameters(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            chain.preparedStatement_clearParameters(statement);
            return;
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("PreparedStatementClearParametersBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
        event.putContext(TRACE_STMT_SQL, statement.getSql());
        this.fireEvent(event);
        try {
            chain.preparedStatement_clearParameters(statement);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("PreparedStatementClearParametersAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, statement.getSql());
            event2.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event2);
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("PreparedStatementClearParametersError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, statement.getSql());
            event3.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("PreparedStatementClearParametersError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, statement.getSql());
            event4.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event4);
            throw ex;
        }
    }

    @Override
    public void preparedStatement_addBatch(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            chain.preparedStatement_addBatch(statement);
            return;
        }
        long startMillis = System.currentTimeMillis();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("PreparedStatementAddBatchBefore", new java.util.Date(startMillis));
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_STMT_SQL, statement.getSql());
        event.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
        this.fireEvent(event);
        try {
            chain.preparedStatement_addBatch(statement);
            long timespan = System.currentTimeMillis() - startMillis;
            TraceAfterEvent event2 = new TraceAfterEvent("PreparedStatementAddBatchAfter", new java.util.Date(startMillis), timespan);
            event2.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event2.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event2.putContext(TRACE_CONN_ID, connection.getId());
            event2.putContext(TRACE_STMT_ID, statement.getId());
            event2.putContext(TRACE_STMT_SQL, statement.getSql());
            event2.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event2);
        }
        catch (SQLException ex) {
            TraceErrorEvent event3 = new TraceErrorEvent("PreparedStatementAddBatchError", new java.util.Date(startMillis), ex);
            event3.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event3.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event3.putContext(TRACE_CONN_ID, connection.getId());
            event3.putContext(TRACE_STMT_ID, statement.getId());
            event3.putContext(TRACE_STMT_SQL, statement.getSql());
            event3.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event3);
            throw ex;
        }
        catch (RuntimeException ex) {
            TraceErrorEvent event4 = new TraceErrorEvent("PreparedStatementAddBatchError", new java.util.Date(startMillis), ex);
            event4.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
            event4.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
            event4.putContext(TRACE_CONN_ID, connection.getId());
            event4.putContext(TRACE_STMT_ID, statement.getId());
            event4.putContext(TRACE_STMT_SQL, statement.getSql());
            event4.putContext(TRACE_STMT_PARAMS, this.getParameters(statement));
            this.fireEvent(event4);
            throw ex;
        }
    }

    public void fireEvent(TraceEvent event) {
        JdbcTraceManager.getInstance().fireTraceEvent(event);
    }

    @Override
    public void preparedStatement_setArray(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Array x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setArray(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Array> param = new HashMap<String, Array>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setArray(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setAsciiStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, InputStream x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setAsciiStream(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "InputStream");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setAsciiStream(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setAsciiStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, InputStream x, int length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setAsciiStream(chain, statement, parameterIndex, x, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "InputStream");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setAsciiStream(statement, parameterIndex, x, length);
    }

    @Override
    public void preparedStatement_setAsciiStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, InputStream x, long length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setAsciiStream(chain, statement, parameterIndex, x, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "InputStream");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setAsciiStream(statement, parameterIndex, x, length);
    }

    @Override
    public void preparedStatement_setBigDecimal(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, BigDecimal x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setBigDecimal(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, BigDecimal> param = new HashMap<String, BigDecimal>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setBigDecimal(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setBinaryStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, InputStream x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setBinaryStream(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "<InputStream>");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setBinaryStream(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setBinaryStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, InputStream x, int length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setBinaryStream(chain, statement, parameterIndex, x, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "<InputStream>");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setBinaryStream(statement, parameterIndex, x, length);
    }

    @Override
    public void preparedStatement_setBinaryStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, InputStream x, long length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setBinaryStream(chain, statement, parameterIndex, x, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "<InputStream>");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setBinaryStream(statement, parameterIndex, x, length);
    }

    @Override
    public void preparedStatement_setBlob(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Blob x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setBlob(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "<Blob>");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setBlob(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setBlob(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, InputStream inputStream) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setBlob(chain, statement, parameterIndex, inputStream);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "<InputStream>");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setBlob(statement, parameterIndex, inputStream);
    }

    @Override
    public void preparedStatement_setBlob(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setBlob(chain, statement, parameterIndex, inputStream, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "<InputStream>");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setBlob(statement, parameterIndex, inputStream, length);
    }

    @Override
    public void preparedStatement_setBoolean(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, boolean x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setBoolean(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setBoolean(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setByte(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, byte x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setByte(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Byte> param = new HashMap<String, Byte>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setByte(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setBytes(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, byte[] x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setBytes(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, byte[]> param = new HashMap<String, byte[]>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setBytes(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setCharacterStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader reader) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setCharacterStream(chain, statement, parameterIndex, reader);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "<Reader>");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setCharacterStream(statement, parameterIndex, reader);
    }

    @Override
    public void preparedStatement_setCharacterStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader reader, int length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setCharacterStream(chain, statement, parameterIndex, reader, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "<Reader>");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setCharacterStream(statement, parameterIndex, reader, length);
    }

    @Override
    public void preparedStatement_setCharacterStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader reader, long length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setCharacterStream(chain, statement, parameterIndex, reader, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "<Reader>");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setCharacterStream(statement, parameterIndex, reader, length);
    }

    @Override
    public void preparedStatement_setClob(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Clob x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setClob(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "<Clob>");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setClob(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setClob(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader reader) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setClob(chain, statement, parameterIndex, reader);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "<Reader>");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setClob(statement, parameterIndex, reader);
    }

    @Override
    public void preparedStatement_setClob(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader reader, long length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setClob(chain, statement, parameterIndex, reader, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "<Clob>");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setClob(statement, parameterIndex, reader, length);
    }

    @Override
    public void preparedStatement_setDate(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Date x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setDate(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Date> param = new HashMap<String, Date>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setDate(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setDate(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Date x, Calendar calendar) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setDate(chain, statement, parameterIndex, x, calendar);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Comparable<java.util.Date>> param = new HashMap<String, Comparable<java.util.Date>>();
        param.put("value", x);
        param.put("calendar", calendar);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setDate(statement, parameterIndex, x, calendar);
    }

    @Override
    public void preparedStatement_setDouble(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, double x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setDouble(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Double> param = new HashMap<String, Double>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setDouble(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setFloat(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, float x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setFloat(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Float> param = new HashMap<String, Float>();
        param.put("value", Float.valueOf(x));
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setFloat(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setInt(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, int x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setInt(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setInt(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setLong(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, long x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setLong(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setLong(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setNCharacterStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader value) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setNCharacterStream(chain, statement, parameterIndex, value);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "<Clob>");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setNCharacterStream(statement, parameterIndex, value);
    }

    @Override
    public void preparedStatement_setNCharacterStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader value, long length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setNCharacterStream(chain, statement, parameterIndex, value, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "<Clob>");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setNCharacterStream(statement, parameterIndex, value, length);
    }

    @Override
    public void preparedStatement_setNClob(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, NClob value) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setNClob(chain, statement, parameterIndex, value);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "<Clob>");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setNClob(statement, parameterIndex, value);
    }

    @Override
    public void preparedStatement_setNClob(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader reader) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setNClob(chain, statement, parameterIndex, reader);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "<Clob>");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setNClob(statement, parameterIndex, reader);
    }

    @Override
    public void preparedStatement_setNClob(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader reader, long length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setNClob(chain, statement, parameterIndex, reader, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "<Clob>");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setNClob(statement, parameterIndex, reader, length);
    }

    @Override
    public void preparedStatement_setNString(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, String value) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setNString(chain, statement, parameterIndex, value);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", value);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setNString(statement, parameterIndex, value);
    }

    @Override
    public void preparedStatement_setNull(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, int sqlType) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setNull(chain, statement, parameterIndex, sqlType);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("value", null);
        param.put("sqlType", sqlType);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setNull(statement, parameterIndex, sqlType);
    }

    @Override
    public void preparedStatement_setNull(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setNull(chain, statement, parameterIndex, sqlType, typeName);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", null);
        param.put("sqlType", sqlType);
        param.put("typeName", typeName);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setNull(statement, parameterIndex, sqlType, typeName);
    }

    @Override
    public void preparedStatement_setObject(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Object x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setObject(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (x instanceof InputStream) {
            param.put("value", "<InputStream>");
        } else if (x instanceof Reader) {
            param.put("value", "<Reader>");
        } else if (x instanceof Clob) {
            param.put("value", "<Clob>");
        } else if (x instanceof NClob) {
            param.put("value", "<NClob>");
        } else if (x instanceof Blob) {
            param.put("value", "<Blob>");
        } else {
            param.put("value", x);
        }
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setObject(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setObject(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setObject(chain, statement, parameterIndex, x, targetSqlType);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (x instanceof InputStream) {
            param.put("value", "<InputStream>");
        } else if (x instanceof Reader) {
            param.put("value", "<Reader>");
        } else if (x instanceof Clob) {
            param.put("value", "<Clob>");
        } else if (x instanceof NClob) {
            param.put("value", "<NClob>");
        } else if (x instanceof Blob) {
            param.put("value", "<Blob>");
        } else {
            param.put("value", x);
        }
        param.put("targetSqlType", targetSqlType);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setObject(statement, parameterIndex, x, targetSqlType);
    }

    @Override
    public void preparedStatement_setObject(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setObject(chain, statement, parameterIndex, x, targetSqlType, scaleOrLength);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (x instanceof InputStream) {
            param.put("value", "<InputStream>");
        } else if (x instanceof Reader) {
            param.put("value", "<Reader>");
        } else if (x instanceof Clob) {
            param.put("value", "<Clob>");
        } else if (x instanceof NClob) {
            param.put("value", "<NClob>");
        } else if (x instanceof Blob) {
            param.put("value", "<Blob>");
        } else {
            param.put("value", x);
        }
        param.put("targetSqlType", targetSqlType);
        param.put("scaleOrLength", scaleOrLength);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setObject(statement, parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void preparedStatement_setRef(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Ref x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setRef(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Ref> param = new HashMap<String, Ref>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setRef(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setRowId(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, RowId x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setRowId(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, RowId> param = new HashMap<String, RowId>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setRowId(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setShort(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, short x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setShort(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Short> param = new HashMap<String, Short>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setShort(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setSQLXML(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setSQLXML(chain, statement, parameterIndex, xmlObject);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", "<SQLXML>");
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setSQLXML(statement, parameterIndex, xmlObject);
    }

    @Override
    public void preparedStatement_setString(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, String x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setString(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setString(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setTime(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Time x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setTime(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Time> param = new HashMap<String, Time>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setTime(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setTime(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Time x, Calendar calendar) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setTime(chain, statement, parameterIndex, x, calendar);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Comparable<java.util.Date>> param = new HashMap<String, Comparable<java.util.Date>>();
        param.put("value", x);
        param.put("calendar", calendar);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setTime(statement, parameterIndex, x, calendar);
    }

    @Override
    public void preparedStatement_setTimestamp(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Timestamp x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setTimestamp(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Timestamp> param = new HashMap<String, Timestamp>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setTimestamp(statement, parameterIndex, x);
    }

    @Override
    public void preparedStatement_setTimestamp(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Timestamp x, Calendar calendar) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setTimestamp(chain, statement, parameterIndex, x, calendar);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Comparable<java.util.Date>> param = new HashMap<String, Comparable<java.util.Date>>();
        param.put("value", x);
        param.put("calendar", calendar);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setTimestamp(statement, parameterIndex, x, calendar);
    }

    @Override
    public void preparedStatement_setUnicodeStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, InputStream x, int length) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setUnicodeStream(chain, statement, parameterIndex, x, length);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("value", "<InputStream>");
        param.put("length", length);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setUnicodeStream(statement, parameterIndex, x, length);
    }

    @Override
    public void preparedStatement_setURL(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, URL x) throws SQLException {
        if (!this.isTraceStatementEnable()) {
            super.preparedStatement_setURL(chain, statement, parameterIndex, x);
            return;
        }
        SortedMap<Integer, Object> parameters = this.getParameters(statement);
        HashMap<String, URL> param = new HashMap<String, URL>();
        param.put("value", x);
        parameters.put(parameterIndex, param);
        chain.preparedStatement_setURL(statement, parameterIndex, x);
    }

    @Override
    public boolean resultSet_next(FilterChain chain, ResultSetProxy resultSet) throws SQLException {
        if (!this.isTraceResultSetEnable()) {
            return chain.resultSet_next(resultSet);
        }
        boolean hasMore = chain.resultSet_next(resultSet);
        StatementProxy statement = resultSet.getStatementProxy();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("ResultSetNext", new java.util.Date());
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, resultSet.getSql());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_RS_ID, resultSet.getId());
        event.putContext("rs.hasMore", hasMore);
        if (hasMore) {
            List<Object> row = this.getCurrentRow(resultSet);
            event.putContext("rs.row", row);
            ResultSetTraceInfo traceInfo = TraceFilter.getResultSetTraceInfo(resultSet);
            if (traceInfo != null) {
                traceInfo.incrementCusorIndex();
                event.putContext(TRACE_RS_CURSOR_INDEX, traceInfo.getCusorIndex());
                if (traceInfo.getCusorIndex() > traceInfo.getFetchRowCount()) {
                    traceInfo.setFetchRowCount(traceInfo.getCusorIndex());
                }
            }
        }
        this.fireEvent(event);
        return hasMore;
    }

    @Override
    public boolean resultSet_previous(FilterChain chain, ResultSetProxy resultSet) throws SQLException {
        if (!this.isTraceResultSetEnable()) {
            return chain.resultSet_previous(resultSet);
        }
        boolean hasMore = chain.resultSet_previous(resultSet);
        StatementProxy statement = resultSet.getStatementProxy();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("ResultSetPrevious", new java.util.Date());
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, resultSet.getSql());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_RS_ID, resultSet.getId());
        event.putContext("rs.hasMore", hasMore);
        if (hasMore) {
            event.putContext("rs.row", this.getCurrentRow(resultSet));
            ResultSetTraceInfo traceInfo = TraceFilter.getResultSetTraceInfo(resultSet);
            if (traceInfo != null) {
                traceInfo.decrementCusorIndex();
                event.putContext(TRACE_RS_CURSOR_INDEX, traceInfo.getCusorIndex());
            }
        }
        this.fireEvent(event);
        return hasMore;
    }

    @Override
    public void resultSet_close(FilterChain chain, ResultSetProxy resultSet) throws SQLException {
        if (!this.isTraceResultSetEnable()) {
            chain.resultSet_close(resultSet);
            return;
        }
        chain.resultSet_close(resultSet);
        StatementProxy statement = resultSet.getStatementProxy();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("ResultSetCloseAfter", new java.util.Date());
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, resultSet.getSql());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_RS_ID, resultSet.getId());
        ResultSetTraceInfo traceInfo = TraceFilter.getResultSetTraceInfo(resultSet);
        if (traceInfo != null) {
            traceInfo.decrementCusorIndex();
            event.putContext(TRACE_RS_CURSOR_INDEX, traceInfo.getCusorIndex());
            event.putContext("rs.fetchRowIndex", traceInfo.getFetchRowCount());
        }
        this.fireEvent(event);
    }

    private List<Object> getCurrentRow(ResultSetProxy resultSet) throws SQLException {
        ResultSetMetaData meta = resultSet.getMetaData();
        int columnCount = meta.getColumnCount();
        ArrayList<Object> row = new ArrayList<Object>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            Object value = resultSet.getObject(i);
            if (value instanceof Blob) {
                value = "<BLOB>";
            }
            row.add(value);
        }
        return row;
    }

    public static ResultSetTraceInfo getResultSetTraceInfo(ResultSetProxy resultSet) {
        if (resultSet == null) {
            return null;
        }
        ResultSetTraceInfo traceInfo = (ResultSetTraceInfo)resultSet.getAttributes().get(ATTR_NAME_RESULT_SET);
        return traceInfo;
    }

    protected void resultSetOpenAfter(ResultSetProxy resultSet) throws SQLException {
        if (!this.isTraceResultSetEnable()) {
            return;
        }
        ResultSetTraceInfo resultSetTraceInfo = new ResultSetTraceInfo();
        resultSet.getAttributes().put(ATTR_NAME_RESULT_SET, resultSetTraceInfo);
        StatementProxy statement = resultSet.getStatementProxy();
        ConnectionProxy connection = statement.getConnectionProxy();
        TraceEvent event = new TraceEvent("ResultSetPrevious", new java.util.Date());
        event.putContext(TRACE_CONN_INFO, connection.getProperties().clone());
        event.putContext(TRACE_CONN_CONNECTED_TIME, connection.getConnectedTime());
        event.putContext(TRACE_CONN_ID, connection.getId());
        event.putContext(TRACE_STMT_SQL, resultSet.getSql());
        event.putContext(TRACE_STMT_ID, statement.getId());
        event.putContext(TRACE_RS_ID, resultSet.getId());
        ArrayList columns = new ArrayList();
        ResultSetMetaData meta = resultSet.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            HashMap<String, Object> column = new HashMap<String, Object>();
            column.put("name", meta.getColumnName(i));
            column.put("type", meta.getColumnType(i));
            columns.add(column);
        }
        event.putContext("rs.columns", columns);
        this.fireEvent(event);
    }

    public static class ResultSetTraceInfo {
        protected final long constructNano = System.nanoTime();
        protected int cusorIndex = 0;
        protected int fetchRowCount = 0;

        public void incrementCusorIndex() {
            ++this.cusorIndex;
        }

        public void decrementCusorIndex() {
            --this.cusorIndex;
        }

        public long getConstructNano() {
            return this.constructNano;
        }

        public int getCusorIndex() {
            return this.cusorIndex;
        }

        public void setCusorIndex(int cusorIndex) {
            this.cusorIndex = cusorIndex;
        }

        public int getFetchRowCount() {
            return this.fetchRowCount;
        }

        public void setFetchRowCount(int fetchRowCount) {
            this.fetchRowCount = fetchRowCount;
        }
    }
}

