/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.jconsole;

import com.alibaba.druid.jconsole.ConnectionsPanel;
import com.alibaba.druid.jconsole.DataSourceInfo;
import com.alibaba.druid.jconsole.DataSourcePanel;
import com.alibaba.druid.jconsole.NodeInfo;
import com.alibaba.druid.jconsole.NodeType;
import com.alibaba.druid.jconsole.SQLPanel;
import com.alibaba.druid.logging.Log;
import com.alibaba.druid.logging.LogFactory;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.stat.JdbcStatManager;
import com.sun.tools.jconsole.JConsoleContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class DruidPanel
extends JPanel {
    private static final Log LOG = LogFactory.getLog(DruidPanel.class);
    private static final long serialVersionUID = 1L;
    protected JSplitPane mainSplit;
    protected JTree tree;
    protected JPanel sheet;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultMutableTreeNode dataSourcesNode;

    public DruidPanel() {
        this.setLayout(new BorderLayout());
        this.mainSplit = new JSplitPane(1);
        this.mainSplit.setDividerLocation(160);
        this.mainSplit.setBorder(BorderFactory.createEmptyBorder());
        this.rootNode = new DefaultMutableTreeNode("root", true);
        this.dataSourcesNode = new DefaultMutableTreeNode(new NodeInfo(null, null, NodeType.DataSources, null, "DataSources"), true);
        this.rootNode.add(this.dataSourcesNode);
        this.tree = new JTree(this.rootNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DruidPanel.this.treeSelect(e);
            }
        });
        JScrollPane theScrollPane = new JScrollPane(this.tree, 20, 30);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)theScrollPane, "Center");
        this.mainSplit.setLeftComponent(treePanel);
        this.sheet = new JPanel();
        this.mainSplit.setRightComponent(this.sheet);
        this.add(this.mainSplit);
    }

    private void treeSelect(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        Object userObject = node.getUserObject();
        NodeInfo nodeInfo = (NodeInfo)userObject;
        if (nodeInfo == null) {
            this.mainSplit.setRightComponent(this.sheet);
            return;
        }
        if (nodeInfo.getType() == NodeType.DataSource) {
            DataSourceInfo dataSourceInfo = (DataSourceInfo)nodeInfo.getData();
            this.mainSplit.setRightComponent(new DataSourcePanel(dataSourceInfo));
        } else if (nodeInfo.getType() == NodeType.Connections) {
            DataSourceInfo dataSourceInfo = (DataSourceInfo)nodeInfo.getData();
            ConnectionsPanel connectionsPanel = new ConnectionsPanel(nodeInfo.getConnection(), nodeInfo.getObjectInstance(), dataSourceInfo);
            this.mainSplit.setRightComponent(connectionsPanel);
        } else if (nodeInfo.getType() == NodeType.SQL) {
            DataSourceInfo dataSourceInfo = (DataSourceInfo)nodeInfo.getData();
            SQLPanel connectionsPanel = new SQLPanel(nodeInfo.getConnection(), nodeInfo.getObjectInstance(), dataSourceInfo);
            this.mainSplit.setRightComponent(connectionsPanel);
        } else {
            this.mainSplit.setRightComponent(this.sheet);
        }
    }

    public void init() {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(JdbcStatManager.getInstance(), new ObjectName("com.alibaba.druid:type=JdbcStatManager"));
            DruidDataSource dataSource = new DruidDataSource();
            ManagementFactory.getPlatformMBeanServer().registerMBean(dataSource, new ObjectName("com.alibaba.druid:type=DataSource"));
            dataSource.setUrl("jdbc:mock:");
            dataSource.setFilters("stat,trace");
            Connection conn = dataSource.getConnection();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT 1");
            while (rs.next()) {
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Object doInBackground(JConsoleContext context) throws Exception {
        this.doInBackground(context.getMBeanServerConnection());
        return null;
    }

    protected void doInBackground(MBeanServerConnection conn) throws Exception {
        ArrayList<ObjectInstance> stats = new ArrayList<ObjectInstance>();
        Set<ObjectInstance> instances = conn.queryMBeans(null, null);
        for (ObjectInstance instance : instances) {
            MBeanInfo info = conn.getMBeanInfo(instance.getObjectName());
            if (!"com.alibaba.druid.stat.JdbcStatManager".equals(info.getClassName())) continue;
            stats.add(instance);
        }
        if (stats.size() == 0) {
            // empty if block
        }
        for (ObjectInstance statInstance : stats) {
            TabularData tabularValue = (TabularData)conn.getAttribute(statInstance.getObjectName(), "DataSourceList");
            for (Object item : tabularValue.values()) {
                CompositeData rowData = (CompositeData)item;
                DataSourceInfo dataSourceInfo = new DataSourceInfo(conn, rowData);
                NodeInfo dataSourceNodeInfo = new NodeInfo(conn, statInstance, NodeType.DataSource, dataSourceInfo, dataSourceInfo.getName());
                DefaultMutableTreeNode dataSourceNode = new DefaultMutableTreeNode(dataSourceNodeInfo, true);
                NodeInfo connectionsNodeInfo = new NodeInfo(conn, statInstance, NodeType.Connections, dataSourceInfo, "Connections");
                DefaultMutableTreeNode connections = new DefaultMutableTreeNode(connectionsNodeInfo, true);
                dataSourceNode.add(connections);
                NodeInfo sqlNodeInfo = new NodeInfo(conn, statInstance, NodeType.SQL, dataSourceInfo, "SQL");
                DefaultMutableTreeNode sqlListNode = new DefaultMutableTreeNode(sqlNodeInfo, true);
                dataSourceNode.add(sqlListNode);
                this.dataSourcesNode.add(dataSourceNode);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JFrame frame = new JFrame();
                    DruidPanel panel = new DruidPanel();
                    frame.getContentPane().add(panel);
                    frame.pack();
                    frame.setSize(1024, 768);
                    String urlPath = "/jndi/rmi://10.20.138.25:9006/jmxrmi";
                    JMXServiceURL jmxUrl = new JMXServiceURL("rmi", "", 0, "/jndi/rmi://10.20.138.25:9006/jmxrmi");
                    JMXConnector connector = JMXConnectorFactory.connect(jmxUrl);
                    panel.doInBackground(connector.getMBeanServerConnection());
                    frame.setDefaultCloseOperation(3);
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        });
    }
}

