/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.jconsole;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.springframework.util.Assert;

public class SQLDetailDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextArea textArea = new JTextArea();

    public SQLDetailDialog(CompositeData rowData) {
        JScrollPane textAreaScrollPane = new JScrollPane(this.textArea, 20, 30);
        this.getContentPane().add(textAreaScrollPane);
        String sql = (String)rowData.get("SQL");
        sql = SQLDetailDialog.format(sql);
        this.textArea.setText(sql);
    }

    public static String format(String sql) {
        if (sql == null || sql.length() == 0) {
            return sql;
        }
        try {
            return SQLDetailDialog.mergeMySql(sql);
        }
        catch (Exception ex) {
            try {
                return SQLDetailDialog.mergeOracle(sql);
            }
            catch (Exception exception) {
                return sql;
            }
        }
    }

    public static String mergeMySql(String sql) {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        List<SQLStatement> statementList = parser.parseStatementList();
        SQLStatement statemen = statementList.get(0);
        Assert.isTrue((1 == statementList.size() ? 1 : 0) != 0);
        StringBuilder out = new StringBuilder();
        MySqlOutputVisitor visitor = new MySqlOutputVisitor(out);
        statemen.accept(visitor);
        return out.toString();
    }

    public static String mergeOracle(String sql) {
        OracleStatementParser parser = new OracleStatementParser(sql);
        List<SQLStatement> statementList = parser.parseStatementList();
        SQLStatement statemen = statementList.get(0);
        Assert.isTrue((1 == statementList.size() ? 1 : 0) != 0);
        StringBuilder out = new StringBuilder();
        OracleOutputVisitor visitor = new OracleOutputVisitor(out);
        statemen.accept(visitor);
        return out.toString();
    }
}

