/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.jconsole;

import com.alibaba.druid.jconsole.DataSourceInfo;
import com.alibaba.druid.jconsole.SQLDetailDialog;
import com.alibaba.druid.logging.Log;
import com.alibaba.druid.logging.LogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class SQLPanel
extends JPanel {
    private static final Log LOG = LogFactory.getLog(SQLPanel.class);
    private static final long serialVersionUID = 1L;
    private MBeanServerConnection connection;
    private ObjectInstance objectInstance;
    private DataSourceInfo dataSourceInfo;
    private JTable table;
    private SQLTableModel tableModel;
    private SQLTableRowSorter sorter;
    private String[] columnNames = new String[]{"ID", "File", "Name", "SQL", "ExecCount", "TotalTime", "EffectedRows", "FetchRowCount", "Running", "ConcurrentMax", "MaxTimespan", "LastTime", "LastError", "ErrorCount"};

    public SQLPanel(MBeanServerConnection connection, ObjectInstance objectInstance, DataSourceInfo dataSourceInfo) {
        this.connection = connection;
        this.objectInstance = objectInstance;
        this.dataSourceInfo = dataSourceInfo;
        try {
            TabularData connectionTabularData = (TabularData)connection.getAttribute(objectInstance.getObjectName(), "SqlList");
            ArrayList<Object[]> rowList = new ArrayList<Object[]>();
            for (Object item : connectionTabularData.values()) {
                CompositeData rowData = (CompositeData)item;
                String url = (String)rowData.get("DataSource");
                if (!dataSourceInfo.getUrl().equals(url)) continue;
                Object[] row = new Object[this.columnNames.length];
                int columnIndex = 0;
                row[columnIndex++] = rowData;
                row[columnIndex++] = rowData.get("File");
                row[columnIndex++] = rowData.get("Name");
                row[columnIndex++] = rowData.get("SQL");
                row[columnIndex++] = rowData.get("ExecuteCount");
                row[columnIndex++] = rowData.get("TotalTime");
                row[columnIndex++] = rowData.get("EffectedRowCount");
                row[columnIndex++] = rowData.get("FetchRowCount");
                row[columnIndex++] = rowData.get("RunningCount");
                row[columnIndex++] = rowData.get("ConcurrentMax");
                row[columnIndex++] = rowData.get("MaxTimespan");
                row[columnIndex++] = rowData.get("LastTime");
                row[columnIndex++] = rowData.get("LastError");
                row[columnIndex++] = rowData.get("ErrorCount");
                rowList.add(row);
            }
            Object[][] rows = new Object[rowList.size()][];
            rowList.toArray((T[])rows);
            TableColumnModel columnModel = new TableColumnModel();
            this.tableModel = new SQLTableModel(rows);
            this.sorter = new SQLTableRowSorter(this.tableModel);
            this.table = new JTable(this.tableModel, columnModel);
            this.table.setAutoResizeMode(2);
            this.table.setRowSorter(this.sorter);
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SQLPanel.this.tableMouseClicked(e);
                }
            });
            this.table.setSelectionMode(0);
            JScrollPane tableScrollPane = new JScrollPane(this.table, 20, 30);
            this.setLayout(new BorderLayout());
            this.add((Component)tableScrollPane, "Center");
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    void refresh() {
        try {
            TabularData connectionTabularData = (TabularData)this.connection.getAttribute(this.objectInstance.getObjectName(), "SqlList");
            ArrayList<Object[]> rowList = new ArrayList<Object[]>();
            for (Object item : connectionTabularData.values()) {
                CompositeData rowData = (CompositeData)item;
                String url = (String)rowData.get("DataSource");
                if (!this.dataSourceInfo.getUrl().equals(url)) continue;
                Object[] row = new Object[this.columnNames.length];
                int columnIndex = 0;
                row[columnIndex++] = rowData;
                row[columnIndex++] = rowData.get("File");
                row[columnIndex++] = rowData.get("Name");
                row[columnIndex++] = rowData.get("SQL");
                row[columnIndex++] = rowData.get("ExecuteCount");
                row[columnIndex++] = rowData.get("ErrorCount");
                row[columnIndex++] = rowData.get("TotalTime");
                row[columnIndex++] = rowData.get("LastTime");
                row[columnIndex++] = rowData.get("MaxTimespan");
                row[columnIndex++] = rowData.get("LastError");
                row[columnIndex++] = rowData.get("EffectedRowCount");
                row[columnIndex++] = rowData.get("FetchRowCount");
                row[columnIndex++] = rowData.get("ConcurrentMax");
                row[columnIndex++] = rowData.get("RunningCount");
                rowList.add(row);
            }
            Object[][] rows = new Object[rowList.size()][];
            rowList.toArray((T[])rows);
            int rowCount = this.tableModel.getRowCount();
            this.tableModel.setRowData(rows);
            this.tableModel.fireTableRowsDeleted(0, rowCount - 1);
            this.tableModel.setRowData(rows);
            this.tableModel.fireTableRowsInserted(0, rows.length);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public void tableMouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        int rowIndex = this.table.getSelectedRow();
        if (rowIndex < 0) {
            return;
        }
        CompositeData rowData = (CompositeData)this.table.getValueAt(rowIndex, 0);
        SQLDetailDialog dialog = new SQLDetailDialog(rowData);
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int width = (int)screenSize.getWidth();
        int height = (int)screenSize.getHeight();
        dialog.setSize(800, 600);
        int w = dialog.getWidth();
        int h = dialog.getHeight();
        dialog.setLocation((width - w) / 2, (height - h) / 2);
        dialog.setVisible(true);
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    public ObjectInstance getObjectInstance() {
        return this.objectInstance;
    }

    public DataSourceInfo getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    static class LongComparator
    implements Comparator<Object> {
        LongComparator() {
        }

        @Override
        public int compare(Object a, Object b) {
            long bValue;
            long aValue = Long.parseLong(a.toString());
            if (aValue == (bValue = Long.parseLong(b.toString()))) {
                return 0;
            }
            return aValue > bValue ? 1 : -1;
        }
    }

    static class SQLTableRowSorter
    extends TableRowSorter<SQLTableModel> {
        public SQLTableRowSorter(SQLTableModel model) {
            super(model);
        }

        @Override
        public Comparator<?> getComparator(int column) {
            switch (column) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: {
                    return new LongComparator();
                }
            }
            return super.getComparator(column);
        }
    }

    static class IDRender
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        IDRender() {
        }

        @Override
        public void setValue(Object value) {
            CompositeData rowData = (CompositeData)value;
            Object id = rowData.get("ID");
            this.setText(id == null ? "" : id.toString());
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        DateFormat formatter;

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    static class SQLRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object value) {
            String sql = (String)value;
            String formattedSql = SQLDetailDialog.format(sql);
            this.setText(sql);
            this.setToolTipText("<html><pre>" + formattedSql + "</pre></html>");
        }
    }

    class TableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1L;

        public TableColumnModel() {
            for (int i = 0; i < SQLPanel.this.columnNames.length; ++i) {
                TableColumn column = new TableColumn();
                column.setModelIndex(i);
                column.setHeaderValue(SQLPanel.this.columnNames[i]);
                this.addColumn(column);
            }
            TableColumn column = this.getColumn(0);
            column.setMinWidth(50);
            column.setMaxWidth(50);
            column.setCellRenderer(new IDRender());
            column = this.getColumn(3);
            column.setPreferredWidth(400);
            column.setCellRenderer(new SQLRenderer());
            column = this.getColumn(4);
            column.setPreferredWidth(60);
            column = this.getColumn(11);
            column.setCellRenderer(new DateRenderer());
            column.setPreferredWidth(120);
        }
    }

    class SQLTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private Object[][] rowData;

        public SQLTableModel(Object[][] rows) {
            this.rowData = rows;
        }

        @Override
        public String getColumnName(int column) {
            return SQLPanel.this.columnNames[column].toString();
        }

        @Override
        public int getRowCount() {
            return this.rowData.length;
        }

        @Override
        public int getColumnCount() {
            return SQLPanel.this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.rowData[row][col];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }

        public void setRowData(Object[][] rowData) {
            this.rowData = rowData;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.rowData[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

