/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.logging;

import com.alibaba.druid.logging.Log;
import com.alibaba.druid.logging.Resources;
import java.lang.reflect.Constructor;

public class LogFactory {
    private static Constructor logConstructor;

    private static void tryImplementation(String testClassName, String implClassName) {
        if (logConstructor == null) {
            try {
                Resources.classForName(testClassName);
                Class<?> implClass = Resources.classForName(implClassName);
                logConstructor = implClass.getConstructor(Class.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Log getLog(Class aClass) {
        try {
            return (Log)logConstructor.newInstance(aClass);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating logger for class " + aClass + ".  Cause: " + t, t);
        }
    }

    public static synchronized void selectLog4JLogging() {
        try {
            Resources.classForName("org.apache.log4j.Logger");
            Class<?> implClass = Resources.classForName("com.ibatis.common.logging.log4j.Log4jImpl");
            logConstructor = implClass.getConstructor(Class.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static synchronized void selectJavaLogging() {
        try {
            Resources.classForName("java.util.logging.Logger");
            Class<?> implClass = Resources.classForName("com.ibatis.common.logging.jdk14.Jdk14LoggingImpl");
            logConstructor = implClass.getConstructor(Class.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        LogFactory.tryImplementation("org.apache.commons.logging.LogFactory", "com.alibaba.druid.logging.JakartaCommonsLoggingImpl");
        LogFactory.tryImplementation("org.apache.log4j.Logger", "com.alibaba.druid.logging.Log4jImpl");
        LogFactory.tryImplementation("java.util.logging.Logger", "com.alibaba.druid.logging.Jdk14LoggingImpl");
        LogFactory.tryImplementation("java.lang.Object", "com.alibaba.druid.logging.NoLoggingImpl");
    }
}

