/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mock;

import com.alibaba.druid.logging.Log;
import com.alibaba.druid.logging.LogFactory;
import com.alibaba.druid.mock.MockBlob;
import com.alibaba.druid.mock.MockClob;
import com.alibaba.druid.mock.MockConnection;
import com.alibaba.druid.mock.MockNClob;
import com.alibaba.druid.mock.MockPreparedStatement;
import com.alibaba.druid.mock.MockResultSet;
import com.alibaba.druid.mock.MockSQLXML;
import com.alibaba.druid.mock.MockStatement;
import com.alibaba.druid.mock.handler.MockExecuteHandler;
import com.alibaba.druid.mock.handler.MySqlMockExecuteHandlerImpl;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class MockDriver
implements Driver {
    private static final Log LOG = LogFactory.getLog(MockDriver.class);
    public static final MockExecuteHandler DEFAULT_HANDLER = new MySqlMockExecuteHandlerImpl();
    private String prefix = "jdbc:fake:";
    private String mockPrefix = "jdbc:mock:";
    private MockExecuteHandler executeHandler = DEFAULT_HANDLER;
    public static final MockDriver instance = new MockDriver();
    private final AtomicLong connectCount = new AtomicLong();
    private final AtomicLong connectionCloseCount = new AtomicLong();
    private final AtomicLong connectionIdSeed = new AtomicLong(1000L);
    private final List<MockConnection> connections = new CopyOnWriteArrayList<MockConnection>();
    private long idleTimeCount = 180000L;
    private boolean logExecuteQueryEnable = true;

    public boolean isLogExecuteQueryEnable() {
        return this.logExecuteQueryEnable;
    }

    public void setLogExecuteQueryEnable(boolean logExecuteQueryEnable) {
        this.logExecuteQueryEnable = logExecuteQueryEnable;
    }

    public long getIdleTimeCount() {
        return this.idleTimeCount;
    }

    public void setIdleTimeCount(long idleTimeCount) {
        this.idleTimeCount = idleTimeCount;
    }

    public long generateConnectionId() {
        return this.connectionIdSeed.incrementAndGet();
    }

    public List<MockConnection> getConnections() {
        return this.connections;
    }

    protected void incrementConnectionCloseCount() {
        this.connectionCloseCount.incrementAndGet();
    }

    public long getConnectionCloseCount() {
        return this.connectionCloseCount.get();
    }

    protected void afterConnectionClose(MockConnection conn) {
        this.connectionCloseCount.incrementAndGet();
        this.connections.remove(conn);
        if (LOG.isDebugEnabled()) {
            LOG.debug("conn-" + conn.getId() + " close");
        }
    }

    public static boolean registerDriver(Driver driver) {
        try {
            DriverManager.registerDriver(driver);
            return true;
        }
        catch (Exception e) {
            LOG.error("registerDriver error", e);
            return false;
        }
    }

    public MockExecuteHandler getExecuteHandler() {
        return this.executeHandler;
    }

    public void setExecuteHandler(MockExecuteHandler executeHandler) {
        this.executeHandler = executeHandler;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Object val;
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (info != null && (val = info.get("connectSleep")) != null) {
            long millis = Long.parseLong(val.toString());
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        MockConnection conn = new MockConnection(this, url, info);
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect, url " + url + ", id " + conn.getId());
        }
        if (url == null) {
            this.connectCount.incrementAndGet();
            this.connections.add(conn);
            return conn;
        }
        if (url.startsWith(this.prefix)) {
            String catalog = url.substring(this.prefix.length());
            conn.setCatalog(catalog);
            this.connectCount.incrementAndGet();
            this.connections.add(conn);
            return conn;
        }
        if (url.startsWith(this.mockPrefix)) {
            String catalog = url.substring(this.mockPrefix.length());
            conn.setCatalog(catalog);
            this.connectCount.incrementAndGet();
            this.connections.add(conn);
            return conn;
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.startsWith(this.prefix) || url.startsWith(this.mockPrefix);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    protected ResultSet executeQuery(MockStatement stmt, String sql) throws SQLException {
        Object propertyValue;
        if (this.logExecuteQueryEnable && LOG.isDebugEnabled()) {
            LOG.debug("executeQuery " + sql);
        }
        MockConnection conn = stmt.getMockConnection();
        long idleTimeMillis = System.currentTimeMillis() - conn.getLastActiveTimeMillis();
        if (idleTimeMillis >= this.idleTimeCount) {
            throw new SQLException("connection is idle time count");
        }
        conn.setLastActiveTimeMillis(System.currentTimeMillis());
        if (conn != null && conn.getConnectProperties() != null && (propertyValue = conn.getConnectProperties().get("executeSleep")) != null) {
            long millis = Long.parseLong(propertyValue.toString());
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if ("SELECT value FROM _int_1000_".equalsIgnoreCase(sql)) {
            MockResultSet rs = new MockResultSet(stmt);
            for (int i = 0; i < 1000; ++i) {
                rs.getRows().add(new Object[]{i});
            }
            return rs;
        }
        return this.executeHandler.executeQuery(stmt, sql);
    }

    protected ResultSet createResultSet(MockPreparedStatement stmt) {
        MockResultSet rs = new MockResultSet(stmt);
        String sql = stmt.getSql();
        if ("SELECT 1".equalsIgnoreCase(sql)) {
            rs.getRows().add(new Object[]{1});
        } else if ("SELECT NOW()".equalsIgnoreCase(sql)) {
            rs.getRows().add(new Object[]{new Timestamp(System.currentTimeMillis())});
        } else if ("SELECT ?".equalsIgnoreCase(sql)) {
            rs.getRows().add(new Object[]{stmt.getParameters().get(0)});
        }
        return rs;
    }

    protected Clob createClob(MockConnection conn) throws SQLException {
        return new MockClob();
    }

    protected Blob createBlob(MockConnection conn) throws SQLException {
        return new MockBlob();
    }

    protected NClob createNClob(MockConnection conn) throws SQLException {
        return new MockNClob();
    }

    protected SQLXML createSQLXML(MockConnection conn) throws SQLException {
        return new MockSQLXML();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        MockDriver.registerDriver(instance);
    }
}

