/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mock;

import com.alibaba.druid.mock.MockConnection;
import com.alibaba.druid.mock.MockConnectionClosedException;
import com.alibaba.druid.mock.MockResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class MockStatement
implements Statement {
    public static final String ERROR_SQL = "THROW ERROR";
    protected boolean closed = false;
    private Connection connection;
    protected MockConnection mockConnection;
    private int maxFieldSize;
    private int maxRows;
    private int queryTimeout;
    private boolean escapeProcessing;
    private SQLWarning warnings;
    private String cursorName;
    private int updateCount;
    private int fetchDirection;
    private int fetchSize;
    private int resultSetType;
    private int resultSetConcurrency;
    private int resultSetHoldability;

    public MockStatement(Connection connection) {
        this.connection = connection;
        if (connection instanceof MockConnection) {
            this.mockConnection = (MockConnection)connection;
        }
    }

    protected void checkOpen() throws SQLException, MockConnectionClosedException {
        if (this.closed) {
            throw new SQLException();
        }
        if (this.mockConnection != null && this.mockConnection.isClosed()) {
            throw new MockConnectionClosedException();
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this.resultSetType;
    }

    public void setResultSetType(int resultType) {
        this.resultSetType = resultType;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public MockConnection getMockConnection() {
        return this.mockConnection;
    }

    public void setFakeConnection(MockConnection fakeConnection) {
        this.mockConnection = fakeConnection;
        this.connection = fakeConnection;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            return null;
        }
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == null) {
            return false;
        }
        return iface.isInstance(this);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        if (this.mockConnection != null && this.mockConnection.getDriver() != null) {
            return this.mockConnection.getDriver().executeQuery(this, sql);
        }
        return new MockResultSet(this);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this.escapeProcessing = enable;
    }

    public boolean isEscapeProcessing() {
        return this.escapeProcessing;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.warnings = null;
    }

    public void setWarning(SQLWarning warning) {
        this.warnings = warning;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        this.cursorName = name;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        if (ERROR_SQL.equals(sql)) {
            throw new SQLException();
        }
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return new MockResultSet(this);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this.updateCount;
    }

    public void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this.resultSetConcurrency;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        return new int[0];
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        return new MockResultSet(this);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

