/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.logging.Log;
import com.alibaba.druid.logging.LogFactory;
import com.alibaba.druid.pool.ConnectionHolder;
import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidPooledCallableStatement;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.pool.PreparedStatementPool;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.util.TransactionInfo;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class DruidPooledConnection
implements PooledConnection,
Connection {
    private static final Log LOG = LogFactory.getLog(DruidPooledConnection.class);
    protected Connection conn;
    protected ConnectionHolder holder;
    protected TransactionInfo transactionInfo;
    private final boolean dupCloseLogEnable;
    private boolean traceEnable = false;
    private boolean diable = false;
    private boolean closed = false;
    private final Thread ownerThread;

    public DruidPooledConnection(ConnectionHolder holder) {
        this.conn = holder.getConnection();
        this.holder = holder;
        this.dupCloseLogEnable = holder.getDataSource().isDupCloseLogEnable();
        this.ownerThread = Thread.currentThread();
    }

    public Thread getOwnerThread() {
        return this.ownerThread;
    }

    public boolean isTraceEnable() {
        return this.traceEnable;
    }

    public void setTraceEnable(boolean traceEnable) {
        this.traceEnable = traceEnable;
    }

    public SQLException handleException(Throwable t) throws SQLException {
        ConnectionHolder holder = this.holder;
        if (holder != null) {
            DruidAbstractDataSource dataSource = holder.getDataSource();
            dataSource.handleConnectionException(this, t);
        }
        if (t instanceof SQLException) {
            throw (SQLException)t;
        }
        throw new SQLException("Error", t);
    }

    public boolean isOracle() {
        return this.holder.getDataSource().isOracle();
    }

    void closePoolableStatement(DruidPooledPreparedStatement stmt) throws SQLException {
        if (this.holder == null) {
            return;
        }
        PreparedStatement rawStatement = stmt.getRawPreparedStatement();
        try {
            rawStatement.clearParameters();
        }
        catch (SQLException ex) {
            LOG.error("clear parameter error", ex);
        }
        if (this.holder == null) {
            return;
        }
        if (this.holder.isPoolPreparedStatements()) {
            this.holder.getStatementPool().put(stmt.getPreparedStatementHolder());
            stmt.clearResultSet();
            this.holder.removeTrace(stmt);
            stmt.getPreparedStatementHolder().setFetchRowPeak(stmt.getFetchRowPeak());
            stmt.setClosed(true);
        } else {
            stmt.closeInternal();
            this.holder.getDataSource().incrementClosedPreparedStatementCount();
        }
    }

    public ConnectionHolder getConnectionHolder() {
        return this.holder;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    void disable() {
        this.traceEnable = false;
        this.holder = null;
        this.transactionInfo = null;
        this.diable = true;
    }

    public boolean isDiable() {
        return this.diable;
    }

    @Override
    public void close() throws SQLException {
        ConnectionHolder holder = this.holder;
        if (this.diable) {
            return;
        }
        if (holder == null && this.dupCloseLogEnable) {
            LOG.error("dup close");
            return;
        }
        for (ConnectionEventListener listener : holder.getConnectionEventListeners()) {
            listener.connectionClosed(new ConnectionEvent(this));
        }
        holder.getDataSource().recycle(this);
        this.holder = null;
        this.conn = null;
        this.transactionInfo = null;
        this.closed = true;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M1);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.holder.getDataSource().initStatement(this, stmtHolder.getStatement());
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M2, resultSetType, resultSetConcurrency);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.holder.getDataSource().initStatement(this, stmtHolder.getStatement());
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M3, resultSetType, resultSetConcurrency, resultSetHoldability);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.holder.getDataSource().initStatement(this, stmtHolder.getStatement());
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkState();
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M4, columnIndexes);
        PreparedStatementHolder stmtHolder = null;
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, columnIndexes));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.holder.getDataSource().initStatement(this, stmtHolder.getStatement());
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkState();
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M5, columnNames);
        PreparedStatementHolder stmtHolder = null;
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, columnNames));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.holder.getDataSource().initStatement(this, stmtHolder.getStatement());
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkState();
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M6, autoGeneratedKeys);
        PreparedStatementHolder stmtHolder = null;
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, autoGeneratedKeys));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.holder.getDataSource().initStatement(this, stmtHolder.getStatement());
        DruidPooledPreparedStatement rtnVal = new DruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.Precall_1);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareCall(sql));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.holder.getDataSource().initStatement(this, stmtHolder.getStatement());
        DruidPooledCallableStatement rtnVal = new DruidPooledCallableStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.Precall_2, resultSetType, resultSetConcurrency, resultSetHoldability);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.holder.getDataSource().initStatement(this, stmtHolder.getStatement());
        DruidPooledCallableStatement rtnVal = new DruidPooledCallableStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.Precall_3, resultSetType, resultSetConcurrency);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareCall(sql, resultSetType, resultSetConcurrency));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex);
            }
        }
        this.holder.getDataSource().initStatement(this, stmtHolder.getStatement());
        DruidPooledCallableStatement rtnVal = new DruidPooledCallableStatement(this, stmtHolder);
        this.holder.addTrace(rtnVal);
        return rtnVal;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkState();
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        this.holder.getDataSource().initStatement(this, stmt);
        DruidPooledStatement poolableStatement = new DruidPooledStatement(this, stmt);
        this.holder.addTrace(poolableStatement);
        return poolableStatement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkState();
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        this.holder.getDataSource().initStatement(this, stmt);
        DruidPooledStatement poolableStatement = new DruidPooledStatement(this, stmt);
        this.holder.addTrace(poolableStatement);
        return poolableStatement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkState();
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        this.holder.getDataSource().initStatement(this, stmt);
        DruidPooledStatement poolableStatement = new DruidPooledStatement(this, stmt);
        this.holder.addTrace(poolableStatement);
        return poolableStatement;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            return null;
        }
        if (iface == Connection.class) {
            if (this.conn instanceof ConnectionProxy) {
                return this.conn.unwrap(iface);
            }
            return (T)this.conn;
        }
        if (iface.isInstance(this.conn)) {
            return (T)this.conn;
        }
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return this.conn.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == null) {
            return false;
        }
        if (iface.isInstance(this)) {
            return true;
        }
        return this.conn.isWrapperFor(iface);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkState();
        return this.conn.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkState();
        try {
            this.conn.setAutoCommit(autoCommit);
            this.holder.setUnderlyingAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
    }

    protected void transactionRecord(String sql) throws SQLException {
        if (this.transactionInfo == null && !this.conn.getAutoCommit()) {
            DruidAbstractDataSource dataSource = this.holder.getDataSource();
            dataSource.incrementStartTransactionCount();
            this.transactionInfo = new TransactionInfo(dataSource.createTransactionId());
        }
        if (this.transactionInfo != null) {
            this.transactionInfo.getSqlList().add(sql);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkState();
        return this.conn.getAutoCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        this.checkState();
        DruidAbstractDataSource dataSource = this.holder.getDataSource();
        dataSource.incrementCommitCount();
        try {
            this.conn.commit();
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        finally {
            this.handleEndTransaction(dataSource);
        }
    }

    public TransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        if (this.transactionInfo == null) {
            return;
        }
        if (this.holder == null) {
            return;
        }
        DruidAbstractDataSource dataSource = this.holder.getDataSource();
        dataSource.incrementRollbackCount();
        try {
            this.conn.rollback();
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        finally {
            this.handleEndTransaction(dataSource);
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkState();
        return this.conn.setSavepoint(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.holder == null) {
            return;
        }
        DruidAbstractDataSource dataSource = this.holder.getDataSource();
        dataSource.incrementRollbackCount();
        try {
            this.conn.rollback(savepoint);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        finally {
            this.handleEndTransaction(dataSource);
        }
    }

    private void handleEndTransaction(DruidAbstractDataSource dataSource) {
        if (this.transactionInfo != null) {
            long currentTimeMillis = System.currentTimeMillis();
            this.transactionInfo.setEndTimeMillis(currentTimeMillis);
            long transactionMillis = currentTimeMillis - this.transactionInfo.getStartTimeMillis();
            dataSource.getTransactionHistogram().recode(transactionMillis);
            dataSource.logTransaction(this.transactionInfo);
            this.transactionInfo = null;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkState();
        try {
            this.conn.releaseSavepoint(savepoint);
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkState();
        return this.conn.createClob();
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.holder == null) {
            return true;
        }
        return this.conn.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkState();
        return this.conn.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkState();
        this.conn.setReadOnly(readOnly);
        this.holder.setUnderlyingReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkState();
        return this.conn.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkState();
        this.conn.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkState();
        return this.conn.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkState();
        this.conn.setTransactionIsolation(level);
        this.holder.setUnderlyingTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkState();
        return this.conn.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        return this.conn.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkState();
        this.conn.clearWarnings();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkState();
        return this.conn.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkState();
        this.conn.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkState();
        this.conn.setHoldability(holdability);
        this.holder.setUnderlyingHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkState();
        return this.conn.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkState();
        return this.conn.setSavepoint();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkState();
        return this.conn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkState();
        return this.conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkState();
        return this.conn.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkState();
        return this.conn.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.holder == null) {
            throw new SQLClientInfoException();
        }
        this.conn.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.holder == null) {
            throw new SQLClientInfoException();
        }
        this.conn.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkState();
        return this.conn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkState();
        return this.conn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkState();
        return this.conn.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkState();
        return this.conn.createStruct(typeName, attributes);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.holder == null) {
            throw new IllegalStateException();
        }
        this.holder.getConnectionEventListeners().add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.holder == null) {
            throw new IllegalStateException();
        }
        this.holder.getConnectionEventListeners().remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (this.holder == null) {
            throw new IllegalStateException();
        }
        this.holder.getStatementEventListeners().add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (this.holder == null) {
            throw new IllegalStateException();
        }
        this.holder.getStatementEventListeners().remove(listener);
    }

    public void checkState() throws SQLException {
        if (this.holder == null || this.closed || this.diable) {
            throw new SQLException("connection is closed");
        }
    }

    public String toString() {
        if (this.conn != null) {
            return this.conn.toString();
        }
        return "closed-conn-" + System.identityHashCode(this);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

