/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha;

import com.alibaba.druid.logging.Log;
import com.alibaba.druid.logging.LogFactory;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.ManagedDataSource;
import com.alibaba.druid.pool.ha.DataSourceHolder;
import com.alibaba.druid.pool.ha.HADataSourceMBean;
import com.alibaba.druid.pool.ha.MultiDataSource;
import javax.sql.DataSource;

public class HADataSource
extends MultiDataSource
implements HADataSourceMBean,
ManagedDataSource,
DataSource {
    private static final Log LOG = LogFactory.getLog(HADataSource.class);
    protected DataSourceHolder master;
    protected DataSourceHolder slave;

    @Override
    public void resetStat() {
        super.resetStat();
        this.master.resetState();
        this.slave.resetState();
    }

    public boolean isMasterWritable() {
        return this.master != null && this.master.isWritable();
    }

    public boolean isSlaveWritable() {
        return this.slave != null && this.slave.isWritable();
    }

    @Override
    public long getMasterConnectCount() {
        return this.master.getConnectCount();
    }

    @Override
    public long getSlaveConnectCount() {
        return this.slave.getConnectCount();
    }

    public DataSourceHolder getMaster() {
        return this.master;
    }

    @Override
    public void restartMaster() {
        this.restartDataSource("master");
    }

    @Override
    public void restartSlave() {
        this.restartDataSource("slave");
    }

    public DataSourceHolder setMaster(DruidDataSource master) {
        DataSourceHolder holder = new DataSourceHolder(this, master);
        this.setMaster(holder);
        return holder;
    }

    public void setMaster(DataSourceHolder master) {
        this.addDataSource("master", master);
        this.master = master;
    }

    public DataSourceHolder getSlave() {
        return this.slave;
    }

    public DataSourceHolder setSlave(DruidDataSource slave) {
        DataSourceHolder holder = new DataSourceHolder(this, slave);
        this.setSlave(holder);
        return holder;
    }

    public void setSlave(DataSourceHolder slave) {
        this.addDataSource("slave", slave);
        this.slave = slave;
    }

    @Override
    public boolean isMasterEnable() {
        if (this.master == null) {
            return false;
        }
        return this.master.isEnable();
    }

    @Override
    public boolean isMasterFail() {
        if (this.master == null) {
            return false;
        }
        return this.master.isFail();
    }

    @Override
    public boolean isSlaveFail() {
        if (this.slave == null) {
            return false;
        }
        return this.slave.isFail();
    }

    @Override
    public void setMasterEnable(boolean value) {
        if (this.master == null) {
            throw new IllegalStateException("slave is null");
        }
        this.master.setEnable(value);
    }

    @Override
    public String getMasterUrl() {
        if (this.master == null) {
            return null;
        }
        return this.master.getUrl();
    }

    @Override
    public String getSlaveUrl() {
        if (this.slave == null) {
            return null;
        }
        return this.slave.getUrl();
    }

    @Override
    public int getMasterWeight() {
        return this.master.getWeight();
    }

    @Override
    public int getSlaveWeight() {
        return this.slave.getWeight();
    }

    @Override
    public int getMasterWeightRegionBegin() {
        return this.master.getWeightRegionBegin();
    }

    @Override
    public int getMasterWeightRegionEnd() {
        return this.master.getWeightRegionEnd();
    }

    @Override
    public int getSlaveWeightRegionBegin() {
        return this.slave.getWeightRegionBegin();
    }

    @Override
    public int getSlaveWeightRegionEnd() {
        return this.slave.getWeightRegionEnd();
    }

    @Override
    public boolean isSlaveEnable() {
        if (this.slave == null) {
            return false;
        }
        return this.slave.isEnable();
    }

    @Override
    public void setSlaveEnable(boolean value) {
        if (this.slave == null) {
            throw new IllegalStateException("slave is null");
        }
        this.slave.setEnable(value);
    }

    @Override
    public void switchMasterSlave() {
        DataSourceHolder tmp = this.getMaster();
        this.setMaster(this.getSlave());
        this.setSlave(tmp);
    }

    @Override
    public void close() {
        super.close();
        if (LOG.isDebugEnabled()) {
            LOG.debug("HADataSource closed");
        }
    }
}

