/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha;

import com.alibaba.druid.pool.WrapperAdapter;
import com.alibaba.druid.pool.ha.DataSourceHolder;
import com.alibaba.druid.pool.ha.MultiConnectionHolder;
import com.alibaba.druid.pool.ha.MultiDataSource;
import com.alibaba.druid.pool.ha.MultiDataSourcePreparedStatement;
import com.alibaba.druid.pool.ha.MultiDataSourceStatement;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxyImpl;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class MultiDataSourceConnection
extends WrapperAdapter
implements Connection,
ConnectionProxy {
    private final MultiDataSource multiDataSource;
    private Connection conn;
    private DataSourceHolder dataSourceHolder;
    private final long id;
    private Boolean autoCommit = null;
    private Boolean readOnly = null;
    private String catalog = null;
    private Integer transactionLeval = null;
    private Map<String, Class<?>> typeMap = null;
    private Integer holdability = null;
    private Properties clientInfo = null;
    private Map<String, Object> attributes = null;
    private Date connectedTime = null;
    private boolean closed = false;

    public MultiDataSourceConnection(MultiDataSource multiDataSource, long id) {
        this.multiDataSource = multiDataSource;
        this.id = id;
    }

    public DataSourceHolder getDataSourceHolder() {
        return this.dataSourceHolder;
    }

    public void checkConnection(String sql) throws SQLException {
        if (this.conn == null) {
            MultiConnectionHolder connHolder = this.multiDataSource.getRealConnection(this, sql);
            this.conn = connHolder.getConnection();
            this.dataSourceHolder = connHolder.getDataSourceHolder();
        }
        if (this.autoCommit != null) {
            this.conn.setAutoCommit(this.autoCommit);
        }
        if (this.readOnly != null) {
            this.conn.setReadOnly(this.readOnly);
        }
        if (this.catalog != null) {
            this.conn.setCatalog(this.catalog);
        }
        if (this.transactionLeval != null) {
            this.conn.setTransactionIsolation(this.transactionLeval);
        }
        if (this.typeMap != null) {
            this.conn.setTypeMap(this.typeMap);
        }
        if (this.holdability != null) {
            this.conn.setHoldability(this.holdability);
        }
        if (this.clientInfo != null) {
            this.conn.setClientInfo(this.clientInfo);
        }
        this.connectedTime = new Date();
    }

    public MultiDataSource getMultiDataSource() {
        return this.multiDataSource;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkConnection(sql);
        return this.conn.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.conn != null) {
            this.conn.setAutoCommit(autoCommit);
        } else {
            this.autoCommit = autoCommit;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.conn != null) {
            return this.conn.getAutoCommit();
        }
        if (this.autoCommit != null) {
            return this.autoCommit;
        }
        return false;
    }

    @Override
    public void commit() throws SQLException {
        if (this.conn != null) {
            this.conn.commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.conn != null) {
            this.conn.rollback();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.conn != null) {
            this.conn.close();
        }
        this.closed = true;
        this.multiDataSource.afterConnectionClosed(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.conn != null) {
            return this.conn.getMetaData();
        }
        throw new SQLException("connection not init");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.conn != null) {
            this.conn.setReadOnly(readOnly);
        } else {
            this.readOnly = readOnly;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.conn != null) {
            return this.conn.isReadOnly();
        }
        if (this.readOnly != null) {
            return this.readOnly;
        }
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.conn != null) {
            this.conn.setCatalog(catalog);
        } else {
            this.catalog = catalog;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.conn != null) {
            return this.conn.getCatalog();
        }
        return this.catalog;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.conn != null) {
            this.conn.setTransactionIsolation(level);
        } else {
            this.transactionLeval = level;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.conn != null) {
            return this.conn.getTransactionIsolation();
        }
        if (this.transactionLeval != null) {
            return this.transactionLeval;
        }
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.conn != null) {
            return this.conn.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.conn != null) {
            this.conn.clearWarnings();
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (this.conn != null) {
            return this.conn.getTypeMap();
        }
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (this.conn != null) {
            this.conn.setTypeMap(map);
        } else {
            this.typeMap = map;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (this.conn != null) {
            this.conn.setHoldability(holdability);
        } else {
            this.holdability = holdability;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.conn != null) {
            return this.conn.getHoldability();
        }
        if (this.holdability != null) {
            return this.holdability;
        }
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.conn != null) {
            return this.conn.setSavepoint();
        }
        throw new SQLException("connection not init");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.conn != null) {
            return this.conn.setSavepoint(name);
        }
        throw new SQLException("connection not init");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.conn != null) {
            this.conn.rollback(savepoint);
        }
        throw new SQLException("connection not init");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.conn != null) {
            this.conn.releaseSavepoint(savepoint);
        }
        throw new SQLException("connection not init");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        long stmtId = this.multiDataSource.createStatementId();
        MultiDataSourceStatement stmt = new MultiDataSourceStatement(this, stmtId, resultSetType, resultSetConcurrency);
        return stmt;
    }

    @Override
    public Statement createStatement() throws SQLException {
        long stmtId = this.multiDataSource.createStatementId();
        MultiDataSourceStatement stmt = new MultiDataSourceStatement(this, stmtId);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkConnection(sql);
        PreparedStatement stmt = this.conn.prepareStatement(sql);
        long stmtId = this.multiDataSource.createStatementId();
        return new MultiDataSourcePreparedStatement(this, stmt, sql, stmtId);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkConnection(sql);
        CallableStatement stmt = this.conn.prepareCall(sql);
        long stmtId = this.multiDataSource.createStatementId();
        return new CallableStatementProxyImpl((ConnectionProxy)this, stmt, sql, stmtId);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection(sql);
        PreparedStatement stmt = this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        long stmtId = this.multiDataSource.createStatementId();
        return new MultiDataSourcePreparedStatement(this, stmt, sql, stmtId);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection(sql);
        CallableStatement stmt = this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        long stmtId = this.multiDataSource.createStatementId();
        return new CallableStatementProxyImpl((ConnectionProxy)this, stmt, sql, stmtId);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        long stmtId = this.multiDataSource.createStatementId();
        MultiDataSourceStatement stmt = new MultiDataSourceStatement(this, stmtId, resultSetType, resultSetConcurrency, resultSetHoldability);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnection(sql);
        PreparedStatement stmt = this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        long stmtId = this.multiDataSource.createStatementId();
        return new MultiDataSourcePreparedStatement(this, stmt, sql, stmtId);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnection(sql);
        CallableStatement stmt = this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        long stmtId = this.multiDataSource.createStatementId();
        return new CallableStatementProxyImpl((ConnectionProxy)this, stmt, sql, stmtId);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkConnection(sql);
        PreparedStatement stmt = this.conn.prepareStatement(sql, autoGeneratedKeys);
        long stmtId = this.multiDataSource.createStatementId();
        return new MultiDataSourcePreparedStatement(this, stmt, sql, stmtId);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkConnection(sql);
        PreparedStatement stmt = this.conn.prepareStatement(sql, columnIndexes);
        long stmtId = this.multiDataSource.createStatementId();
        return new MultiDataSourcePreparedStatement(this, stmt, sql, stmtId);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkConnection(sql);
        PreparedStatement stmt = this.conn.prepareStatement(sql, columnNames);
        long stmtId = this.multiDataSource.createStatementId();
        return new MultiDataSourcePreparedStatement(this, stmt, sql, stmtId);
    }

    @Override
    public Clob createClob() throws SQLException {
        if (this.conn != null) {
            return this.conn.createClob();
        }
        throw new SQLException("connection not init");
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (this.conn != null) {
            return this.conn.createBlob();
        }
        throw new SQLException("connection not init");
    }

    @Override
    public NClob createNClob() throws SQLException {
        if (this.conn != null) {
            return this.conn.createNClob();
        }
        throw new SQLException("connection not init");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (this.conn != null) {
            return this.conn.createSQLXML();
        }
        throw new SQLException("connection not init");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.conn != null) {
            return this.conn.isValid(timeout);
        }
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.conn != null) {
            this.conn.setClientInfo(name, value);
            return;
        }
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.conn != null) {
            this.conn.setClientInfo(properties);
            return;
        }
        this.clientInfo = properties;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.conn != null) {
            return this.conn.getClientInfo(name);
        }
        if (this.clientInfo == null) {
            return null;
        }
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.conn != null) {
            return this.conn.getClientInfo();
        }
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        if (this.conn != null) {
            return this.conn.createArrayOf(typeName, elements);
        }
        throw new SQLException("connection not init");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        if (this.conn != null) {
            return this.conn.createStruct(typeName, attributes);
        }
        throw new SQLException("connection not init");
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Connection getRawObject() {
        return this.conn;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    @Override
    public Properties getProperties() {
        return this.multiDataSource.getProperties();
    }

    @Override
    public DataSourceProxy getDirectDataSource() {
        return this.multiDataSource;
    }

    @Override
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean result = super.isWrapperFor(iface);
        if (!result && this.conn != null) {
            result = this.conn.isWrapperFor(iface);
        }
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T object = super.unwrap(iface);
        if (object == null && this.conn != null) {
            object = this.conn.unwrap(iface);
        }
        return object;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

