/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.config;

import com.alibaba.druid.pool.ha.config.ConfigLoader;
import com.alibaba.druid.util.JdbcUtils;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public abstract class URLConnectionConfigLoader
implements ConfigLoader {
    private URL url;
    private int connectTimeout = 3000;
    private int readTimeout;
    protected String responseMessage;

    public URLConnectionConfigLoader(URL configServerURL) {
        this.url = configServerURL;
    }

    public URLConnectionConfigLoader(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public void load() throws SQLException {
        if (this.url == null) {
            throw new IllegalStateException("configServerURL is null");
        }
        HttpURLConnection conn = null;
        InputStreamReader reader = null;
        try {
            conn = (HttpURLConnection)this.url.openConnection();
            conn.setConnectTimeout(this.connectTimeout);
            conn.setReadTimeout(this.readTimeout);
            conn.connect();
            reader = new InputStreamReader(conn.getInputStream());
            this.responseMessage = JdbcUtils.read(reader);
            this.handleResponseMessage();
        }
        catch (Exception e) {
            try {
                throw new SQLException("load config error, url : " + this.url.toString(), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(reader);
                conn.disconnect();
                throw throwable;
            }
        }
        JdbcUtils.close(reader);
        conn.disconnect();
    }

    protected abstract void handleResponseMessage() throws SQLException;
}

