/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.proxy.jdbc;

import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.WrapperProxyImpl;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ConnectionProxyImpl
extends WrapperProxyImpl
implements ConnectionProxy {
    private final Connection connection;
    private final DataSourceProxy dataSource;
    private final Properties properties;
    private final long connectedTime;

    public ConnectionProxyImpl(DataSourceProxy dataSource, Connection connection, Properties properties, long id) {
        super(connection, id);
        this.dataSource = dataSource;
        this.connection = connection;
        this.properties = properties;
        this.connectedTime = System.currentTimeMillis();
    }

    @Override
    public Date getConnectedTime() {
        return new Date(this.connectedTime);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public Connection getConnectionRaw() {
        return this.connection;
    }

    @Override
    public Connection getRawObject() {
        return this.connection;
    }

    @Override
    public DataSourceProxy getDirectDataSource() {
        return this.dataSource;
    }

    @Override
    public FilterChain createChain() {
        return new FilterChainImpl(this.dataSource);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.createChain().connection_clearWarnings(this);
    }

    @Override
    public void close() throws SQLException {
        this.createChain().connection_close(this);
    }

    @Override
    public void commit() throws SQLException {
        this.createChain().connection_commit(this);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.createChain().connection_createArrayOf(this, typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.createChain().connection_createBlob(this);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.createChain().connection_createClob(this);
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.createChain().connection_createNClob(this);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.createChain().connection_createSQLXML(this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createChain().connection_createStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createChain().connection_createStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createChain().connection_createStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.createChain().connection_createStruct(this, typeName, attributes);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.createChain().connection_getAutoCommit(this);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.createChain().connection_getCatalog(this);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.createChain().connection_getClientInfo(this);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.createChain().connection_getClientInfo(this, name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.createChain().connection_getHoldability(this);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.createChain().connection_getMetaData(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.createChain().connection_getTransactionIsolation(this);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.createChain().connection_getTypeMap(this);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.createChain().connection_getWarnings(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.createChain().connection_isClosed(this);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.createChain().connection_isReadOnly(this);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.createChain().connection_isValid(this, timeout);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.createChain().connection_nativeSQL(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.createChain().connection_prepareCall(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createChain().connection_prepareCall(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createChain().connection_prepareCall(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.createChain().connection_prepareStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.createChain().connection_prepareStatement((ConnectionProxy)this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.createChain().connection_prepareStatement((ConnectionProxy)this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.createChain().connection_prepareStatement((ConnectionProxy)this, sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createChain().connection_prepareStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createChain().connection_prepareStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.createChain().connection_releaseSavepoint(this, savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.createChain().connection_rollback(this);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.createChain().connection_rollback(this, savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.createChain().connection_setAutoCommit(this, autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.createChain().connection_setCatalog(this, catalog);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.createChain().connection_setClientInfo(this, properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.createChain().connection_setClientInfo(this, name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.createChain().connection_setHoldability(this, holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.createChain().connection_setReadOnly(this, readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.createChain().connection_setSavepoint(this);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.createChain().connection_setSavepoint(this, name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.createChain().connection_setTransactionIsolation(this, level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.createChain().connection_setTypeMap(this, map);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == Connection.class) {
            return (T)this.connection;
        }
        return super.unwrap(iface);
    }
}

