/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.proxy.jdbc;

import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.proxy.jdbc.WrapperProxyImpl;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class StatementProxyImpl
extends WrapperProxyImpl
implements StatementProxy {
    private final ConnectionProxy connection;
    private final Statement statement;
    protected long lastExecuteStartTime;
    protected long lastExecuteStartNano;
    protected long lastExecuteCompleteTime;
    protected long lastExecuteCompleteNano;
    protected String lastExecuteSql;
    protected ArrayList<String> batchSqlList;

    public StatementProxyImpl(ConnectionProxy connection, Statement statement, long id) {
        super(statement, id);
        this.connection = connection;
        this.statement = statement;
    }

    @Override
    public ConnectionProxy getConnectionProxy() {
        return this.connection;
    }

    @Override
    public Statement getRawObject() {
        return this.statement;
    }

    @Override
    public FilterChain createChain() {
        return new FilterChainImpl(this.connection.getDirectDataSource());
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchSqlList == null) {
            this.batchSqlList = new ArrayList();
        }
        this.createChain().statement_addBatch(this, sql);
        this.batchSqlList.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.createChain().statement_cancel(this);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchSqlList == null) {
            this.batchSqlList = new ArrayList();
        }
        this.createChain().statement_clearBatch(this);
        this.batchSqlList.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.createChain().statement_clearWarnings(this);
    }

    @Override
    public void close() throws SQLException {
        this.createChain().statement_close(this);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.lastExecuteSql = sql;
        return this.createChain().statement_execute(this, sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.lastExecuteSql = sql;
        return this.createChain().statement_execute((StatementProxy)this, sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.lastExecuteSql = sql;
        return this.createChain().statement_execute((StatementProxy)this, sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.lastExecuteSql = sql;
        return this.createChain().statement_execute((StatementProxy)this, sql, columnNames);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.createChain().statement_executeBatch(this);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.lastExecuteSql = sql;
        return this.createChain().statement_executeQuery(this, sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.lastExecuteSql = sql;
        return this.createChain().statement_executeUpdate(this, sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.lastExecuteSql = sql;
        return this.createChain().statement_executeUpdate((StatementProxy)this, sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.lastExecuteSql = sql;
        return this.createChain().statement_executeUpdate((StatementProxy)this, sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.lastExecuteSql = sql;
        return this.createChain().statement_executeUpdate((StatementProxy)this, sql, columnNames);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.createChain().statement_getConnection(this);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.createChain().statement_getFetchDirection(this);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.createChain().statement_getFetchSize(this);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.createChain().statement_getGeneratedKeys(this);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.createChain().statement_getMaxFieldSize(this);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.createChain().statement_getMaxRows(this);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.createChain().statement_getMoreResults(this);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.createChain().statement_getMoreResults(this, current);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.createChain().statement_getQueryTimeout(this);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.createChain().statement_getResultSet(this);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.createChain().statement_getResultSetConcurrency(this);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.createChain().statement_getResultSetHoldability(this);
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.createChain().statement_getResultSetType(this);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.createChain().statement_getUpdateCount(this);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.createChain().statement_getWarnings(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.createChain().statement_isClosed(this);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.createChain().statement_isPoolable(this);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.createChain().statement_setCursorName(this, name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.createChain().statement_setEscapeProcessing(this, enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.createChain().statement_setFetchDirection(this, direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.createChain().statement_setFetchSize(this, rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.createChain().statement_setMaxFieldSize(this, max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.createChain().statement_setMaxRows(this, max);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.createChain().statement_setPoolable(this, poolable);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.createChain().statement_setQueryTimeout(this, seconds);
    }

    @Override
    public List<String> getBatchSqlList() {
        if (this.batchSqlList == null) {
            this.batchSqlList = new ArrayList();
        }
        return this.batchSqlList;
    }

    @Override
    public String getBatchSql() {
        List<String> sqlList = this.getBatchSqlList();
        StringBuffer buf = new StringBuffer();
        for (String item : sqlList) {
            if (buf.length() > 0) {
                buf.append("\n;\n");
            }
            buf.append(item);
        }
        return buf.toString();
    }

    @Override
    public String getLastExecuteSql() {
        return this.lastExecuteSql;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == Statement.class) {
            return (T)this.statement;
        }
        return super.unwrap(iface);
    }
}

