/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLSetStatement
extends SQLStatementImpl {
    private static final long serialVersionUID = 1L;
    private List<Item> items = new ArrayList<Item>();

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.items);
        }
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append("SET ");
        for (int i = 0; i < this.items.size(); ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            Item item = this.items.get(i);
            item.output(buf);
        }
    }

    public static class Item
    extends SQLObjectImpl {
        private static final long serialVersionUID = 1L;
        private SQLExpr target;
        private SQLExpr value;

        public Item() {
        }

        public Item(SQLExpr target, SQLExpr value) {
            this.target = target;
            this.value = value;
        }

        public SQLExpr getTarget() {
            return this.target;
        }

        public void setTarget(SQLExpr target) {
            this.target = target;
        }

        public SQLExpr getValue() {
            return this.value;
        }

        public void setValue(SQLExpr value) {
            this.value = value;
        }

        @Override
        public void output(StringBuffer buf) {
            this.target.output(buf);
            buf.append(" = ");
            this.value.output(buf);
        }

        @Override
        protected void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild(visitor, this.target);
                this.acceptChild(visitor, this.value);
            }
            visitor.endVisit(this);
        }
    }
}

