/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableConstaint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSQLColumnDefinition;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.Token;

public class MySqlCreateTableParser
extends SQLCreateTableParser {
    public MySqlCreateTableParser(String sql) throws ParserException {
        super(sql);
    }

    public MySqlCreateTableParser(Lexer lexer) {
        super(lexer);
    }

    @Override
    public SQLCreateTableStatement parseCrateTable() throws ParserException {
        return this.parseCrateTable(true);
    }

    @Override
    public SQLCreateTableStatement parseCrateTable(boolean acceptCreate) throws ParserException {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        MySqlCreateTableStatement createTable = new MySqlCreateTableStatement();
        if (this.identifierEquals("TEMPORARY")) {
            this.lexer.nextToken();
            createTable.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        }
        this.accept(Token.TABLE);
        if (this.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createTable.setIfNotExiists(true);
        }
        createTable.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                if (this.lexer.token() == Token.IDENTIFIER) {
                    SQLColumnDefinition column = this.parseColumn();
                    createTable.getTableElementList().add(column);
                } else if (this.lexer.token() == Token.CONSTRAINT) {
                    createTable.getTableElementList().add(this.parseConstraint());
                } else if (this.lexer.token() == Token.INDEX) {
                    this.lexer.nextToken();
                    MySqlTableIndex idx = new MySqlTableIndex();
                    if (this.lexer.token() == Token.IDENTIFIER) {
                        idx.setName(this.exprParser.name());
                    }
                    if (this.identifierEquals("USING")) {
                        this.lexer.nextToken();
                        idx.setIndexType(this.lexer.stringVal());
                        this.lexer.nextToken();
                    }
                    this.accept(Token.LPAREN);
                    while (true) {
                        idx.getColumns().add(this.exprParser.expr());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    createTable.getTableElementList().add(idx);
                } else if (this.lexer.token() == Token.KEY) {
                    createTable.getTableElementList().add(this.parseConstraint());
                } else if (this.lexer.token() == Token.PRIMARY) {
                    createTable.getTableElementList().add(this.parseConstraint());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        while (true) {
            if (this.identifierEquals("ENGINE")) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                createTable.getTableOptions().put("ENGINE", this.lexer.stringVal());
                this.lexer.nextToken();
                continue;
            }
            if (!this.identifierEquals("TYPE")) break;
            this.lexer.nextToken();
            this.accept(Token.EQ);
            createTable.getTableOptions().put("TYPE", this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.ON) {
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.SELECT) {
            SQLSelect query = new MySqlSelectParser(this.lexer).select();
            createTable.setQuery(query);
        }
        return createTable;
    }

    @Override
    protected SQLColumnDefinition parseColumn() throws ParserException {
        MySqlSQLColumnDefinition column = new MySqlSQLColumnDefinition();
        column.setName(this.exprParser.name());
        column.setDataType(this.exprParser.parseDataType());
        return this.parseColumnRest(column);
    }

    @Override
    protected SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) throws ParserException {
        if (this.identifierEquals("AUTO_INCREMENT")) {
            this.lexer.nextToken();
            if (column instanceof MySqlSQLColumnDefinition) {
                ((MySqlSQLColumnDefinition)column).setAutoIncrement(true);
            }
            return this.parseColumnRest(column);
        }
        super.parseColumnRest(column);
        return column;
    }

    @Override
    protected SQLTableConstaint parseConstraint() throws ParserException {
        SQLName name = null;
        if (this.lexer.token() == Token.CONSTRAINT) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            name = this.exprParser.name();
        }
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
            MySqlKey key = new MySqlKey();
            if (this.identifierEquals("USING")) {
                this.lexer.nextToken();
                key.setIndexType(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            this.accept(Token.LPAREN);
            while (true) {
                key.getColumns().add(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            return key;
        }
        if (this.lexer.token() == Token.PRIMARY) {
            this.lexer.nextToken();
            this.accept(Token.KEY);
            MySqlPrimaryKey primaryKey = new MySqlPrimaryKey();
            if (this.identifierEquals("USING")) {
                this.lexer.nextToken();
                primaryKey.setIndexType(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            this.accept(Token.LPAREN);
            while (true) {
                primaryKey.getColumns().add(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            return primaryKey;
        }
        throw new ParserException("TODO");
    }
}

