/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLParseException;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class MySqlLexer
extends Lexer {
    public static final Keywords DEFAULT_MYSQL_KEYWORDS;

    public MySqlLexer(char[] input, int inputLength, boolean skipComment) {
        super(input, inputLength, skipComment);
        this.keywods = DEFAULT_MYSQL_KEYWORDS;
    }

    public MySqlLexer(String input) {
        super(input);
        this.keywods = DEFAULT_MYSQL_KEYWORDS;
    }

    @Override
    public void scanIdentifier() {
        int first = this.ch;
        if (this.ch == '`') {
            char ch;
            int hash = first;
            this.np = this.bp;
            this.sp = 1;
            while (true) {
                if ((ch = this.buf[++this.bp]) == '`') {
                    ++this.sp;
                    break;
                }
                if (ch == '\u001a') {
                    throw new SQLParseException("illegal identifier");
                }
                hash = 31 * hash + ch;
                ++this.sp;
            }
            ch = this.buf[++this.bp];
            this.ch = this.buf[this.bp];
            this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
            Token tok = this.keywods.getKeyword(this.stringVal);
            this.token = tok != null ? tok : Token.IDENTIFIER;
        } else {
            char ch;
            boolean firstFlag = CharTypes.isFirstIdentifierChar((char)first);
            if (!firstFlag) {
                throw new SQLParseException("illegal identifier");
            }
            int hash = first;
            this.np = this.bp;
            this.sp = 1;
            while (CharTypes.isIdentifierChar(ch = this.buf[++this.bp])) {
                hash = 31 * hash + ch;
                ++this.sp;
            }
            this.ch = this.buf[this.bp];
            this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
            Token tok = this.keywods.getKeyword(this.stringVal);
            this.token = tok != null ? tok : Token.IDENTIFIER;
        }
    }

    @Override
    protected void scanString() {
        this.np = this.bp;
        boolean hasSpecial = false;
        while (true) {
            if (this.bp >= this.buflen) {
                this.lexError(this.tokenPos, "unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.buf[++this.bp];
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '\u0000': {
                        this.putChar('\u0000');
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        break;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        break;
                    }
                    default: {
                        this.putChar(this.ch);
                    }
                }
                this.scanChar();
            }
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                hasSpecial = true;
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.sbuf[this.sp++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? new String(this.buf, this.np + 1, this.sp) : new String(this.sbuf, 0, this.sp);
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.put("EXISTS", Token.EXISTS);
        map.put("THEN", Token.THEN);
        map.put("AS", Token.AS);
        map.put("GROUP", Token.GROUP);
        map.put("BY", Token.BY);
        map.put("HAVING", Token.HAVING);
        map.put("DELETE", Token.DELETE);
        map.put("ORDER", Token.ORDER);
        map.put("INDEX", Token.INDEX);
        map.put("FOR", Token.FOR);
        map.put("SCHEMA", Token.SCHEMA);
        map.put("FOREIGN", Token.FOREIGN);
        map.put("REFERENCE", Token.REFERENCE);
        map.put("REFERENCES", Token.REFERENCES);
        map.put("CHECK", Token.CHECK);
        map.put("PRIMARY", Token.PRIMARY);
        map.put("KEY", Token.KEY);
        map.put("CONSTRAINT", Token.CONSTRAINT);
        map.put("DEFAULT", Token.DEFAULT);
        map.put("VIEW", Token.VIEW);
        map.put("CREATE", Token.CREATE);
        map.put("VALUES", Token.VALUES);
        map.put("ALTER", Token.ALTER);
        map.put("TABLE", Token.TABLE);
        map.put("DROP", Token.DROP);
        map.put("SET", Token.SET);
        map.put("INTO", Token.INTO);
        map.put("UPDATE", Token.UPDATE);
        map.put("NULL", Token.NULL);
        map.put("IS", Token.IS);
        map.put("NOT", Token.NOT);
        map.put("SELECT", Token.SELECT);
        map.put("INSERT", Token.INSERT);
        map.put("FROM", Token.FROM);
        map.put("WHERE", Token.WHERE);
        map.put("AND", Token.AND);
        map.put("OR", Token.OR);
        map.put("XOR", Token.XOR);
        map.put("DISTINCT", Token.DISTINCT);
        map.put("UNIQUE", Token.UNIQUE);
        map.put("ALL", Token.ALL);
        map.put("UNION", Token.UNION);
        map.put("INTERSECT", Token.INTERSECT);
        map.put("MINUS", Token.MINUS);
        map.put("INNER", Token.INNER);
        map.put("LEFT", Token.LEFT);
        map.put("RIGHT", Token.RIGHT);
        map.put("FULL", Token.FULL);
        map.put("ON", Token.ON);
        map.put("OUTER", Token.OUTER);
        map.put("JOIN", Token.JOIN);
        map.put("NEW", Token.NEW);
        map.put("CASE", Token.CASE);
        map.put("WHEN", Token.WHEN);
        map.put("END", Token.END);
        map.put("WHEN", Token.WHEN);
        map.put("ELSE", Token.ELSE);
        map.put("EXISTS", Token.EXISTS);
        map.put("CAST", Token.CAST);
        map.put("IN", Token.IN);
        map.put("ASC", Token.ASC);
        map.put("DESC", Token.DESC);
        map.put("LIKE", Token.LIKE);
        map.put("ESCAPE", Token.ESCAPE);
        map.put("BETWEEN", Token.BETWEEN);
        map.put("INTERVAL", Token.INTERVAL);
        map.put("LOCK", Token.LOCK);
        map.put("SOME", Token.SOME);
        map.put("ANY", Token.ANY);
        map.put("TRUE", Token.TRUE);
        map.put("FALSE", Token.FALSE);
        map.put("LIMIT", Token.LIMIT);
        DEFAULT_MYSQL_KEYWORDS = new Keywords(map);
    }
}

