/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectGroupBy;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;

public class MySqlSelectParser
extends SQLSelectParser {
    public MySqlSelectParser(Lexer lexer) {
        super(lexer);
    }

    public MySqlSelectParser(String sql) throws ParserException {
        this(new MySqlLexer(sql));
        this.lexer.nextToken();
    }

    @Override
    protected SQLSelectQuery query() throws ParserException {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select);
        }
        this.accept(Token.SELECT);
        MySqlSelectQueryBlock queryBlock = new MySqlSelectQueryBlock();
        if (this.lexer.token() == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.identifierEquals("DISTINCTROW")) {
            queryBlock.setDistionOption(4);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.ALL) {
            queryBlock.setDistionOption(1);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("HIGH_PRIORITY")) {
            queryBlock.setHignPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("STRAIGHT_JOIN")) {
            queryBlock.setStraightJoin(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("SQL_SMALL_RESULT")) {
            queryBlock.setSmallResult(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("SQL_BIG_RESULT")) {
            queryBlock.setBigResult(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("SQL_BUFFER_RESULT")) {
            queryBlock.setBufferResult(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("SQL_CACHE")) {
            queryBlock.setCache(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("SQL_NO_CACHE")) {
            queryBlock.setCache(false);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("SQL_CALC_FOUND_ROWS")) {
            queryBlock.setCalcFoundRows(true);
            this.lexer.nextToken();
        }
        this.parseSelectList(queryBlock);
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            this.acceptIdentifier("OUTFILE");
            SQLExpr outFile = this.expr();
            queryBlock.setOutFile(outFile);
            if (this.identifierEquals("FIELDS") || this.identifierEquals("COLUMNS")) {
                this.lexer.nextToken();
                if (this.identifierEquals("TERMINATED")) {
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                }
                queryBlock.setOutFileColumnsTerminatedBy((SQLLiteralExpr)this.expr());
                if (this.identifierEquals("OPTIONALLY")) {
                    this.lexer.nextToken();
                    queryBlock.setOutFileColumnsEnclosedOptionally(true);
                }
                if (this.identifierEquals("ENCLOSED")) {
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                    queryBlock.setOutFileColumnsEnclosedBy((SQLLiteralExpr)this.expr());
                }
                if (this.identifierEquals("ESCAPED")) {
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                    queryBlock.setOutFileColumnsEscaped((SQLLiteralExpr)this.expr());
                }
            }
            if (this.identifierEquals("LINES")) {
                this.lexer.nextToken();
                if (this.identifierEquals("STARTING")) {
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                    queryBlock.setOutFileLinesStartingBy((SQLLiteralExpr)this.expr());
                } else {
                    this.identifierEquals("TERMINATED");
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                    queryBlock.setOutFileLinesTerminatedBy((SQLLiteralExpr)this.expr());
                }
            }
        }
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        queryBlock.setOrderBy(this.createExprParser().parseOrderBy());
        if (this.lexer.token() == Token.LIMIT) {
            this.lexer.nextToken();
            MySqlSelectQueryBlock.Limit limit = new MySqlSelectQueryBlock.Limit();
            SQLExpr temp = this.createExprParser().expr();
            if (this.lexer.token() == Token.COMMA) {
                limit.setOffset(temp);
                this.lexer.nextToken();
                limit.setRowCount(this.createExprParser().expr());
            } else if (this.identifierEquals("OFFSET")) {
                limit.setRowCount(temp);
                this.lexer.nextToken();
                limit.setOffset(this.createExprParser().expr());
            } else {
                limit.setRowCount(temp);
            }
            queryBlock.setLimit(limit);
        }
        if (this.identifierEquals("PROCEDURE")) {
            this.lexer.nextToken();
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.accept(Token.UPDATE);
            queryBlock.setForUpdate(true);
        }
        if (this.lexer.token() == Token.LOCK) {
            this.lexer.nextToken();
            this.accept(Token.IN);
            this.acceptIdentifier("SHARE");
            this.acceptIdentifier("MODE");
            queryBlock.setLockInShareMode(true);
        }
        return this.queryRest(queryBlock);
    }

    @Override
    protected void parseGroupBy(SQLSelectQueryBlock queryBlock) throws ParserException {
        if (this.lexer.token() == Token.GROUP) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            while (true) {
                groupBy.getItems().add(this.createExprParser().expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.identifierEquals("WITH")) {
                this.lexer.nextToken();
                this.acceptIdentifier("ROLLUP");
                MySqlSelectGroupBy mySqlGroupBy = new MySqlSelectGroupBy();
                mySqlGroupBy.getItems().addAll(groupBy.getItems());
                mySqlGroupBy.setRollUp(true);
                groupBy = mySqlGroupBy;
            }
            if (this.lexer.token() == Token.HAVING) {
                this.lexer.nextToken();
                groupBy.setHaving(this.createExprParser().expr());
            }
            queryBlock.setGroupBy(groupBy);
        }
    }

    @Override
    protected MySqlExprParser createExprParser() {
        return new MySqlExprParser(this.lexer);
    }
}

