/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCommitStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableParser;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExecuteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadDataInFileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadXmlStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPrepareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlReplicateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRollbackStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowColumnsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowDatabasesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowWarningsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlStartTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class MySqlStatementParser
extends SQLStatementParser {
    public MySqlStatementParser(String sql) throws ParserException {
        this(new MySqlLexer(sql));
        this.lexer.nextToken();
    }

    public MySqlStatementParser(Lexer lexer) {
        super(lexer);
    }

    @Override
    protected SQLExprParser createExprParser() {
        return new MySqlExprParser(this.lexer);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() throws ParserException {
        MySqlCreateTableParser parser = new MySqlCreateTableParser(this.lexer);
        return parser.parseCrateTable();
    }

    @Override
    public SQLSelectStatement parseSelect() throws ParserException {
        return new SQLSelectStatement(new MySqlSelectParser(this.lexer).select());
    }

    @Override
    public SQLDeleteStatement parseDeleteStatement() throws ParserException {
        SQLTableSource tableSource;
        this.accept(Token.DELETE);
        MySqlDeleteStatement deleteStatement = new MySqlDeleteStatement();
        if (this.identifierEquals("LOW_PRIORITY")) {
            deleteStatement.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("QUICK")) {
            deleteStatement.setQuick(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("IGNORE")) {
            deleteStatement.setIgnore(true);
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            this.exprParser.names(deleteStatement.getTableNames());
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                tableSource = this.createSQLSelectParser().parseTableSource();
                deleteStatement.setFrom(tableSource);
            }
        } else {
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
            }
            this.exprParser.names(deleteStatement.getTableNames());
        }
        if (this.identifierEquals("USING")) {
            this.lexer.nextToken();
            tableSource = this.createSQLSelectParser().parseTableSource();
            deleteStatement.setUsing(tableSource);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.exprParser.parseOrderBy();
            deleteStatement.setOrderBy(orderBy);
        }
        if (this.lexer.token() == Token.LIMIT) {
            this.lexer.nextToken();
            MySqlSelectQueryBlock.Limit limit = new MySqlSelectQueryBlock.Limit();
            SQLExpr rowCount = this.exprParser.expr();
            limit.setRowCount(rowCount);
            deleteStatement.setLimit(limit);
        }
        return deleteStatement;
    }

    @Override
    public SQLStatement parseCreate() throws ParserException {
        this.accept(Token.CREATE);
        if (this.lexer.token() == Token.TABLE || this.identifierEquals("TEMPORARY")) {
            MySqlCreateTableParser parser = new MySqlCreateTableParser(this.lexer);
            return parser.parseCrateTable(false);
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.identifierEquals("PREPARE")) {
            MySqlPrepareStatement stmt = this.parsePrepare();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("EXECUTE")) {
            MySqlExecuteStatement stmt = this.parseExecute();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("LOAD")) {
            SQLStatement stmt = this.parseLoad();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("REPLACE")) {
            MySqlReplicateStatement stmt = this.parseReplicate();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("START")) {
            MySqlStartTransactionStatement stmt = this.parseStart();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("COMMIT")) {
            MySqlCommitStatement stmt = this.parseCommit();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("ROLLBACK")) {
            MySqlRollbackStatement stmt = this.parseRollback();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("SHOW")) {
            SQLStatement stmt = this.parseShow();
            statementList.add(stmt);
            return true;
        }
        return false;
    }

    public SQLStatement parseShow() throws ParserException {
        this.acceptIdentifier("SHOW");
        if (this.identifierEquals("FULL")) {
            this.lexer.nextToken();
            this.acceptIdentifier("COLUMNS");
            MySqlShowColumnsStatement stmt = this.parseShowColumns();
            stmt.setFull(true);
            return stmt;
        }
        if (this.identifierEquals("COLUMNS")) {
            this.lexer.nextToken();
            MySqlShowColumnsStatement stmt = this.parseShowColumns();
            return stmt;
        }
        if (this.identifierEquals("TABLES")) {
            this.lexer.nextToken();
            MySqlShowTablesStatement stmt = this.parseShowTabless();
            return stmt;
        }
        if (this.identifierEquals("DATABASES")) {
            this.lexer.nextToken();
            MySqlShowDatabasesStatement stmt = this.parseShowDatabases();
            return stmt;
        }
        if (this.identifierEquals("WARNINGS")) {
            this.lexer.nextToken();
            MySqlShowWarningsStatement stmt = this.parseShowWarnings();
            return stmt;
        }
        if (this.identifierEquals("COUNT")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.accept(Token.STAR);
            this.accept(Token.RPAREN);
            this.acceptIdentifier("WARNINGS");
            MySqlShowWarningsStatement stmt = new MySqlShowWarningsStatement();
            stmt.setCount(true);
            return stmt;
        }
        if (this.identifierEquals("STATUS")) {
            this.lexer.nextToken();
            MySqlShowStatusStatement stmt = this.parseShowStatus();
            return stmt;
        }
        if (this.identifierEquals("GLOBAL")) {
            this.lexer.nextToken();
            if (this.identifierEquals("STATUS")) {
                this.lexer.nextToken();
                MySqlShowStatusStatement stmt = this.parseShowStatus();
                stmt.setGlobal(true);
                return stmt;
            }
        }
        if (this.identifierEquals("SESSION")) {
            this.lexer.nextToken();
            if (this.identifierEquals("STATUS")) {
                this.lexer.nextToken();
                MySqlShowStatusStatement stmt = this.parseShowStatus();
                stmt.setSession(true);
                return stmt;
            }
        }
        if (this.identifierEquals("COBAR_STATUS")) {
            this.lexer.nextToken();
            return new CobarShowStatus();
        }
        throw new ParserException("TODO");
    }

    private MySqlShowStatusStatement parseShowStatus() throws ParserException {
        MySqlShowStatusStatement stmt = new MySqlShowStatusStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowWarningsStatement parseShowWarnings() throws ParserException {
        MySqlShowWarningsStatement stmt = new MySqlShowWarningsStatement();
        if (this.lexer.token() == Token.LIMIT) {
            this.lexer.nextToken();
            MySqlSelectQueryBlock.Limit limit = new MySqlSelectQueryBlock.Limit();
            SQLExpr temp = this.createExprParser().expr();
            if (this.lexer.token() == Token.COMMA) {
                limit.setOffset(temp);
                this.lexer.nextToken();
                limit.setRowCount(this.createExprParser().expr());
            } else if (this.identifierEquals("OFFSET")) {
                limit.setRowCount(temp);
                this.lexer.nextToken();
                limit.setOffset(this.createExprParser().expr());
            } else {
                limit.setRowCount(temp);
            }
            stmt.setLimit(limit);
        }
        return stmt;
    }

    private MySqlShowDatabasesStatement parseShowDatabases() throws ParserException {
        MySqlShowDatabasesStatement stmt = new MySqlShowDatabasesStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowTablesStatement parseShowTabless() throws ParserException {
        MySqlShowTablesStatement stmt = new MySqlShowTablesStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLName database = this.exprParser.name();
            stmt.setDatabase(database);
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowColumnsStatement parseShowColumns() throws ParserException {
        MySqlShowColumnsStatement stmt = new MySqlShowColumnsStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLName table = this.exprParser.name();
            stmt.setTable(table);
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                SQLName database = this.exprParser.name();
                stmt.setDatabase(database);
            }
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    public MySqlStartTransactionStatement parseStart() throws ParserException {
        this.acceptIdentifier("START");
        this.acceptIdentifier("TRANSACTION");
        MySqlStartTransactionStatement stmt = new MySqlStartTransactionStatement();
        if (this.identifierEquals("WITH")) {
            this.lexer.nextToken();
            this.acceptIdentifier("CONSISTENT");
            this.acceptIdentifier("SNAPSHOT");
            stmt.setConsistentSnapshot(true);
        }
        if (this.identifierEquals("BEGIN")) {
            this.lexer.nextToken();
            stmt.setBegin(true);
            if (this.identifierEquals("WORK")) {
                this.lexer.nextToken();
                stmt.setWork(true);
            }
        }
        return stmt;
    }

    public MySqlRollbackStatement parseRollback() throws ParserException {
        this.acceptIdentifier("ROLLBACK");
        MySqlRollbackStatement stmt = new MySqlRollbackStatement();
        if (this.identifierEquals("WORK")) {
            this.lexer.nextToken();
            stmt.setWork(true);
        }
        if (this.lexer.token() == Token.AND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.acceptIdentifier("CHAIN");
                stmt.setChain(Boolean.FALSE);
            } else {
                this.acceptIdentifier("CHAIN");
                stmt.setChain(Boolean.TRUE);
            }
        }
        return stmt;
    }

    public MySqlCommitStatement parseCommit() throws ParserException {
        this.acceptIdentifier("COMMIT");
        MySqlCommitStatement stmt = new MySqlCommitStatement();
        if (this.identifierEquals("WORK")) {
            this.lexer.nextToken();
            stmt.setWork(true);
        }
        if (this.lexer.token() == Token.AND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.acceptIdentifier("CHAIN");
                stmt.setChain(Boolean.FALSE);
            } else {
                this.acceptIdentifier("CHAIN");
                stmt.setChain(Boolean.TRUE);
            }
        }
        return stmt;
    }

    public MySqlReplicateStatement parseReplicate() throws ParserException {
        MySqlReplicateStatement stmt = new MySqlReplicateStatement();
        this.acceptIdentifier("REPLACE");
        if (this.identifierEquals("LOW_PRIORITY")) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("DELAYED")) {
            stmt.setDelayed(true);
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
        }
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.lexer.token() == Token.VALUES || this.identifierEquals("VALUE")) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(values.getValues());
                stmt.getValuesList().add(values);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr);
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            while (true) {
                SQLUpdateSetItem item = new SQLUpdateSetItem();
                item.setColumn(this.exprParser.name());
                this.accept(Token.EQ);
                item.setValue(this.exprParser.expr());
                stmt.getSetItems().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        return stmt;
    }

    protected SQLStatement parseLoad() throws ParserException {
        this.acceptIdentifier("LOAD");
        if (this.identifierEquals("DATA")) {
            MySqlLoadDataInFileStatement stmt = this.parseLoadDataInFile();
            return stmt;
        }
        if (this.identifierEquals("XML")) {
            MySqlLoadXmlStatement stmt = this.parseLoadXml();
            return stmt;
        }
        throw new ParserException("TODO");
    }

    protected MySqlLoadXmlStatement parseLoadXml() throws ParserException {
        this.acceptIdentifier("XML");
        MySqlLoadXmlStatement stmt = new MySqlLoadXmlStatement();
        if (this.identifierEquals("LOW_PRIORITY")) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("CONCURRENT")) {
            stmt.setConcurrent(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("LOCAL")) {
            stmt.setLocal(true);
            this.lexer.nextToken();
        }
        this.acceptIdentifier("INFILE");
        SQLLiteralExpr fileName = (SQLLiteralExpr)this.exprParser.expr();
        stmt.setFileName(fileName);
        if (this.identifierEquals("REPLACE")) {
            stmt.setReplicate(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("IGNORE")) {
            stmt.setIgnore(true);
            this.lexer.nextToken();
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.identifierEquals("CHARACTER")) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() != Token.LITERAL_CHARS) {
                throw new ParserException("syntax error, illegal charset");
            }
            String charset = this.lexer.stringVal();
            this.lexer.nextToken();
            stmt.setCharset(charset);
        }
        if (this.identifierEquals("ROWS")) {
            this.lexer.nextToken();
            this.acceptIdentifier("IDENTIFIED");
            this.accept(Token.BY);
            SQLExpr rowsIdentifiedBy = this.exprParser.expr();
            stmt.setRowsIdentifiedBy(rowsIdentifiedBy);
        }
        if (this.identifierEquals("IGNORE")) {
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.SET) {
            throw new ParserException("TODO");
        }
        return stmt;
    }

    protected MySqlLoadDataInFileStatement parseLoadDataInFile() throws ParserException {
        this.acceptIdentifier("DATA");
        MySqlLoadDataInFileStatement stmt = new MySqlLoadDataInFileStatement();
        if (this.identifierEquals("LOW_PRIORITY")) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("CONCURRENT")) {
            stmt.setConcurrent(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("LOCAL")) {
            stmt.setLocal(true);
            this.lexer.nextToken();
        }
        this.acceptIdentifier("INFILE");
        SQLLiteralExpr fileName = (SQLLiteralExpr)this.exprParser.expr();
        stmt.setFileName(fileName);
        if (this.identifierEquals("REPLACE")) {
            stmt.setReplicate(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("IGNORE")) {
            stmt.setIgnore(true);
            this.lexer.nextToken();
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.identifierEquals("CHARACTER")) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() != Token.LITERAL_CHARS) {
                throw new ParserException("syntax error, illegal charset");
            }
            String charset = this.lexer.stringVal();
            this.lexer.nextToken();
            stmt.setCharset(charset);
        }
        if (this.identifierEquals("FIELDS") || this.identifierEquals("COLUMNS")) {
            throw new ParserException("TODO");
        }
        if (this.identifierEquals("LINES")) {
            throw new ParserException("TODO");
        }
        if (this.identifierEquals("IGNORE")) {
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.SET) {
            throw new ParserException("TODO");
        }
        return stmt;
    }

    public MySqlPrepareStatement parsePrepare() throws ParserException {
        this.acceptIdentifier("PREPARE");
        SQLName name = this.exprParser.name();
        this.accept(Token.FROM);
        SQLExpr from = this.exprParser.expr();
        return new MySqlPrepareStatement(name, from);
    }

    public MySqlExecuteStatement parseExecute() throws ParserException {
        this.acceptIdentifier("EXECUTE");
        MySqlExecuteStatement stmt = new MySqlExecuteStatement();
        SQLName statementName = this.exprParser.name();
        stmt.setStatementName(statementName);
        if (this.identifierEquals("USING")) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters());
        }
        return stmt;
    }

    @Override
    public SQLInsertStatement parseInsert() {
        this.accept(Token.INSERT);
        MySqlInsertStatement insertStatement = new MySqlInsertStatement();
        if (this.identifierEquals("LOW_PRIORITY")) {
            insertStatement.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("DELAYED")) {
            insertStatement.setDelayed(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("HIGH_PRIORITY")) {
            insertStatement.setHighPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("IGNORE")) {
            insertStatement.setIgnore(true);
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
        }
        SQLName tableName = this.exprParser.name();
        insertStatement.setTableName(tableName);
        if (this.lexer.token() == Token.IDENTIFIER) {
            insertStatement.setAlias(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(insertStatement.getColumns());
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(values.getValues());
                insertStatement.getValuesList().add(values);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            insertStatement.setQuery(queryExpr.getSubQuery());
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.acceptIdentifier("DUPLICATE");
            this.accept(Token.KEY);
            this.accept(Token.UPDATE);
            this.exprParser.exprList(insertStatement.getDuplicateKeyUpdate());
        }
        return insertStatement;
    }
}

