/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.visitor;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLCharactorDataType;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlBinaryExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlBooleanExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlCharExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlExtractExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlIntervalExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlMatchAgainstExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCommitStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExecuteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadDataInFileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadXmlStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPrepareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlReplicateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRollbackStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSQLColumnDefinition;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectGroupBy;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowColumnsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowDatabasesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowWarningsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlStartTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.Map;

public class MySqlOutputVisitor
extends SQLASTOutputVisitor
implements MySqlASTVisitor {
    public MySqlOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(MySqlBooleanExpr x) {
        this.print(x.getValue() ? "true" : "false");
        return false;
    }

    @Override
    public void endVisit(MySqlBooleanExpr x) {
    }

    @Override
    public boolean visit(SQLSelectQueryBlock select) {
        if (select instanceof MySqlSelectQueryBlock) {
            return this.visit((MySqlSelectQueryBlock)select);
        }
        return false;
    }

    public boolean visit(MySqlSelectQueryBlock select) {
        this.print("SELECT ");
        if (1 == select.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == select.getDistionOption()) {
            this.print("DISTINCT ");
        } else if (4 == select.getDistionOption()) {
            this.print("DISTINCTROW ");
        }
        if (select.isHignPriority()) {
            this.print("HIGH_PRIORITY ");
        }
        if (select.isSmallResult()) {
            this.print("SQL_SMALL_RESULT ");
        }
        if (select.isBigResult()) {
            this.print("SQL_BIG_RESULT ");
        }
        if (select.isBufferResult()) {
            this.print("SQL_BUFFER_RESULT ");
        }
        if (select.getCache() != null) {
            if (select.getCache().booleanValue()) {
                this.print("SQL_CACHE ");
            } else {
                this.print("SQL_NO_CACHE ");
            }
        }
        if (select.isCalcFoundRows()) {
            this.print("SQL_CALC_FOUND_ROWS ");
        }
        this.printSelectList(select.getSelectList());
        if (select.getOutFile() != null) {
            this.println();
            this.print("INTO OUTFILE ");
            select.getOutFile().accept(this);
            if (select.getOutFileCharset() != null) {
                this.print(" CHARACTER SET ");
                this.print(select.getOutFileCharset());
            }
            if (select.getOutFileColumnsTerminatedBy() != null || select.getOutFileColumnsEnclosedBy() != null || select.getOutFileColumnsEscaped() != null) {
                this.print(" COLUMNS");
                if (select.getOutFileColumnsTerminatedBy() != null) {
                    this.print(" TERMINATED BY ");
                    select.getOutFileColumnsTerminatedBy().accept(this);
                }
                if (select.getOutFileColumnsEnclosedBy() != null) {
                    if (select.isOutFileColumnsEnclosedOptionally()) {
                        this.print(" OPTIONALLY");
                    }
                    this.print(" ENCLOSED BY ");
                    select.getOutFileColumnsEnclosedBy().accept(this);
                }
                if (select.getOutFileColumnsEscaped() != null) {
                    this.print(" ESCAPED BY ");
                    select.getOutFileColumnsEscaped().accept(this);
                }
            }
            if (select.getOutFileLinesStartingBy() != null || select.getOutFileLinesTerminatedBy() != null) {
                this.print(" LINES");
                if (select.getOutFileLinesStartingBy() != null) {
                    this.print(" STARTING BY ");
                    select.getOutFileLinesStartingBy().accept(this);
                }
                if (select.getOutFileLinesTerminatedBy() != null) {
                    this.print(" TERMINATED BY ");
                    select.getOutFileLinesTerminatedBy().accept(this);
                }
            }
        }
        if (select.getFrom() != null) {
            this.println();
            this.print("FROM ");
            select.getFrom().accept(this);
        }
        if (select.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            select.getWhere().accept(this);
        }
        if (select.getGroupBy() != null) {
            this.println();
            select.getGroupBy().accept(this);
        }
        if (select.getOrderBy() != null) {
            this.println();
            select.getOrderBy().accept(this);
        }
        if (select.getLimit() != null) {
            this.println();
            select.getLimit().accept(this);
        }
        if (select.getProcedureName() != null) {
            this.print(" PROCEDURE ");
            select.getProcedureName().accept(this);
            if (select.getProcedureArgumentList().size() > 0) {
                this.print("(");
                this.printAndAccept(select.getProcedureArgumentList(), ", ");
                this.print(")");
            }
        }
        if (select.isForUpdate()) {
            this.println();
            this.print("FOR UPDATE");
        }
        if (select.isLockInShareMode()) {
            this.println();
            this.print("LOCK IN SHARE MODE");
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        MySqlSQLColumnDefinition mysqlColumn = null;
        if (x instanceof MySqlSQLColumnDefinition) {
            mysqlColumn = (MySqlSQLColumnDefinition)x;
        }
        x.getName().accept(this);
        this.print(' ');
        x.getDataType().accept(this);
        if (x.getDefaultExpr() != null) {
            this.print(" DEFAULT ");
            x.getDefaultExpr().accept(this);
        }
        if (mysqlColumn != null && mysqlColumn.isAutoIncrement()) {
            this.print(" AUTO_INCREMENT");
        }
        for (SQLColumnConstraint item : x.getConstaints()) {
            this.print(' ');
            item.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock.Limit x) {
        this.print("LIMIT ");
        if (x.getOffset() != null) {
            x.getOffset().accept(this);
            this.print(", ");
        }
        x.getRowCount().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDataType x) {
        SQLCharactorDataType charType;
        this.print(x.getName());
        if (x.getArguments().size() > 0) {
            this.print("(");
            this.printAndAccept(x.getArguments(), ", ");
            this.print(")");
        }
        if (x instanceof SQLCharactorDataType && (charType = (SQLCharactorDataType)x).getCharSetName() != null) {
            this.print(" CHARACTER SET ");
            this.print(charType.getCharSetName());
            if (charType.getCollate() != null) {
                this.print(" COLLATE ");
                this.print(charType.getCollate());
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSelectQueryBlock.Limit x) {
    }

    @Override
    public void endVisit(MySqlTableIndex x) {
    }

    @Override
    public boolean visit(MySqlTableIndex x) {
        this.print("INDEX");
        if (x.getName() != null) {
            this.print(" ");
            x.getName().accept(this);
        }
        if (x.getIndexType() != null) {
            this.print(" USING ");
            this.print(x.getIndexType());
        }
        this.print("(");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        MySqlCreateTableStatement mysqlCreateTableStatement = null;
        if (x instanceof MySqlCreateTableStatement) {
            mysqlCreateTableStatement = (MySqlCreateTableStatement)x;
        }
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)x.getType())) {
            this.print("CREATE TEMPORARY TABLE ");
        } else {
            this.print("CREATE TABLE ");
        }
        if (mysqlCreateTableStatement != null && mysqlCreateTableStatement.isIfNotExiists()) {
            this.print("IF NOT EXISTS ");
        }
        x.getName().accept(this);
        this.print(" (");
        this.incrementIndent();
        this.println();
        int size = x.getTableElementList().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
                this.println();
            }
            x.getTableElementList().get(i).accept(this);
        }
        this.decrementIndent();
        this.println();
        this.print(")");
        if (mysqlCreateTableStatement != null) {
            for (Map.Entry<String, String> option : mysqlCreateTableStatement.getTableOptions().entrySet()) {
                this.print(" ");
                this.print(option.getKey());
                this.print(" = ");
                this.print(option.getValue());
            }
        }
        if (mysqlCreateTableStatement != null && mysqlCreateTableStatement.getQuery() != null) {
            this.print(" ");
            this.incrementIndent();
            this.println();
            mysqlCreateTableStatement.getQuery().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(MySqlKey x) {
    }

    @Override
    public void endVisit(MySqlPrimaryKey x) {
    }

    @Override
    public boolean visit(MySqlKey x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.accept(this);
            this.print(' ');
        }
        this.print("KEY");
        if (x.getIndexType() != null) {
            this.print(" USING ");
            this.print(x.getIndexType());
        }
        this.print(" (");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(MySqlPrimaryKey x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.accept(this);
            this.print(' ');
        }
        this.print("PRIAMRY KEY");
        if (x.getIndexType() != null) {
            this.print(" USING ");
            this.print(x.getIndexType());
        }
        this.print(" (");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        if (x instanceof MySqlCharExpr) {
            this.print(x.toString());
        } else if (x.getText() == null || x.getText().length() == 0) {
            this.print("NULL");
        } else {
            this.print("'");
            this.print(x.getText().replaceAll("'", "''"));
            this.print("'");
        }
        return false;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        this.print(x.getName());
        String collate = (String)x.getAttribute("COLLATE");
        if (collate != null) {
            this.print(" COLLATE ");
            this.print(collate);
        }
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if ("SUBSTRING".equalsIgnoreCase(x.getMethodName())) {
            SQLExpr _for;
            if (x.getOwner() != null) {
                x.getOwner().accept(this);
                this.print(".");
            }
            this.print(x.getMethodName());
            this.print("(");
            this.printAndAccept(x.getParameters(), ", ");
            SQLExpr from = (SQLExpr)x.getAttribute("FROM");
            if (from != null) {
                this.print(" FROM ");
                from.accept(this);
            }
            if ((_for = (SQLExpr)x.getAttribute("FOR")) != null) {
                this.print(" FOR ");
                _for.accept(this);
            }
            this.print(")");
            return false;
        }
        if ("TRIM".equalsIgnoreCase(x.getMethodName())) {
            if (x.getOwner() != null) {
                x.getOwner().accept(this);
                this.print(".");
            }
            this.print(x.getMethodName());
            this.print("(");
            String trimType = (String)x.getAttribute("TRIM_TYPE");
            if (trimType != null) {
                this.print(trimType);
                this.print(' ');
            }
            this.printAndAccept(x.getParameters(), ", ");
            SQLExpr from = (SQLExpr)x.getAttribute("FROM");
            if (from != null) {
                this.print(" FROM ");
                from.accept(this);
            }
            this.print(")");
            return false;
        }
        if ("CONVERT".equalsIgnoreCase(x.getMethodName())) {
            if (x.getOwner() != null) {
                x.getOwner().accept(this);
                this.print(".");
            }
            this.print(x.getMethodName());
            this.print("(");
            this.printAndAccept(x.getParameters(), ", ");
            String charset = (String)x.getAttribute("USING");
            if (charset != null) {
                this.print(" USING ");
                this.print(charset);
            }
            this.print(")");
            return false;
        }
        return super.visit(x);
    }

    @Override
    public void endVisit(MySqlIntervalExpr x) {
    }

    @Override
    public boolean visit(MySqlIntervalExpr x) {
        this.print("INTERVAL ");
        x.getValue().accept(this);
        this.print(' ');
        this.print(x.getUnit().name());
        return false;
    }

    @Override
    public boolean visit(MySqlExtractExpr x) {
        this.print("EXTRACT(");
        this.print(x.getUnit().name());
        this.print(" FROM ");
        x.getValue().accept(this);
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlExtractExpr x) {
    }

    @Override
    public void endVisit(MySqlMatchAgainstExpr x) {
    }

    @Override
    public boolean visit(MySqlMatchAgainstExpr x) {
        this.print("MATCH (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(")");
        this.print(" AGAINST (");
        x.getAgainst().accept(this);
        if (x.getSearchModifier() != null) {
            this.print(' ');
            this.print(x.getSearchModifier().name);
        }
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlBinaryExpr x) {
    }

    @Override
    public boolean visit(MySqlBinaryExpr x) {
        this.print("b'");
        this.print(x.getValue());
        this.print('\'');
        return false;
    }

    @Override
    public void endVisit(MySqlPrepareStatement x) {
    }

    @Override
    public boolean visit(MySqlPrepareStatement x) {
        this.print("PREPARE ");
        x.getName().accept(this);
        this.print(" FROM ");
        x.getFrom().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlExecuteStatement x) {
    }

    @Override
    public boolean visit(MySqlExecuteStatement x) {
        this.print("EXECUTE ");
        x.getStatementName().accept(this);
        if (x.getParameters().size() > 0) {
            this.print(" USING ");
            this.printAndAccept(x.getParameters(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlDeleteStatement x) {
    }

    @Override
    public boolean visit(MySqlDeleteStatement x) {
        this.print("DELETE ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isQuick()) {
            this.print("QUICK ");
        }
        if (x.isIgnore()) {
            this.print("IGNORE ");
        }
        if (x.getFrom() == null) {
            this.print("FROM ");
            this.printAndAccept(x.getTableNames(), ", ");
        } else {
            this.printAndAccept(x.getTableNames(), ", ");
            this.println();
            this.print("FROM ");
            x.getFrom().accept(this);
        }
        if (x.getUsing() != null) {
            this.println();
            this.print("USING ");
            x.getUsing().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlInsertStatement x) {
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        int i;
        int size;
        this.print("INSERT ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isDelayed()) {
            this.print("DELAYED ");
        }
        if (x.isHighPriority()) {
            this.print("HIGH_PRIORITY ");
        }
        if (x.isIgnore()) {
            this.print("IGNORE ");
        }
        this.print("INTO ");
        x.getTableName().accept(this);
        if (x.getColumns().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print("(");
            size = x.getColumns().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
            this.decrementIndent();
        }
        if (x.getValuesList().size() != 0) {
            this.println();
            this.print("VALUES");
            this.println();
            size = x.getValuesList().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(", ");
                }
                x.getValuesList().get(i).accept(this);
            }
        }
        if (x.getQuery() != null) {
            this.print(" ");
            x.getQuery().accept(this);
        }
        if (x.getDuplicateKeyUpdate().size() != 0) {
            this.print(" ON DUPLICATE KEY UPDATE ");
            this.printAndAccept(x.getDuplicateKeyUpdate(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlLoadDataInFileStatement x) {
    }

    @Override
    public boolean visit(MySqlLoadDataInFileStatement x) {
        this.print("LOAD DATA ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isConcurrent()) {
            this.print("CONCURRENT ");
        }
        if (x.isLocal()) {
            this.print("LOCAL ");
        }
        this.print("INFILE ");
        x.getFileName().accept(this);
        if (x.isReplicate()) {
            this.print(" REPLACE ");
        }
        if (x.isIgnore()) {
            this.print(" IGNORE ");
        }
        this.print(" INTO TABLE ");
        x.getTableName().accept(this);
        if (x.getColumnsTerminatedBy() != null || x.getColumnsEnclosedBy() != null || x.getColumnsEscaped() != null) {
            this.print(" COLUMNS");
            if (x.getColumnsTerminatedBy() != null) {
                this.print(" TERMINATED BY ");
                x.getColumnsTerminatedBy().accept(this);
            }
            if (x.getColumnsEnclosedBy() != null) {
                if (x.isColumnsEnclosedOptionally()) {
                    this.print(" OPTIONALLY");
                }
                this.print(" ENCLOSED BY ");
                x.getColumnsEnclosedBy().accept(this);
            }
            if (x.getColumnsEscaped() != null) {
                this.print(" ESCAPED BY ");
                x.getColumnsEscaped().accept(this);
            }
        }
        if (x.getLinesStartingBy() != null || x.getLinesTerminatedBy() != null) {
            this.print(" LINES");
            if (x.getLinesStartingBy() != null) {
                this.print(" STARTING BY ");
                x.getLinesStartingBy().accept(this);
            }
            if (x.getLinesTerminatedBy() != null) {
                this.print(" TERMINATED BY ");
                x.getLinesTerminatedBy().accept(this);
            }
        }
        if (x.getSetList().size() != 0) {
            this.print(" SET ");
            this.printAndAccept(x.getSetList(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlReplicateStatement x) {
    }

    @Override
    public boolean visit(MySqlReplicateStatement x) {
        this.print("REPLACE ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isDelayed()) {
            this.print("DELAYED ");
        }
        this.print("INTO ");
        x.getTableName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print(" (");
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
        }
        if (x.getValuesList().size() != 0) {
            this.println();
            this.print("VALUES ");
            int size = x.getValuesList().size();
            if (size == 0) {
                this.print("()");
            } else {
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        this.print(", ");
                    }
                    x.getValuesList().get(i).accept(this);
                }
            }
        }
        if (x.getQuery() != null) {
            x.getQuery().accept(this);
        }
        if (x.getSetItems().size() != 0) {
            this.println();
            this.print("SET ");
            this.printAndAccept(x.getSetItems(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSelectGroupBy x) {
    }

    @Override
    public boolean visit(MySqlSelectGroupBy x) {
        super.visit(x);
        if (x.isRollUp()) {
            this.print(" WITH ROLLUP");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlStartTransactionStatement x) {
    }

    @Override
    public boolean visit(MySqlStartTransactionStatement x) {
        this.print("START TRANSACTION");
        if (x.isConsistentSnapshot()) {
            this.print(" WITH CONSISTENT SNAPSHOT");
        }
        if (x.isBegin()) {
            this.print(" BEGIN");
        }
        if (x.isWork()) {
            this.print(" WORK");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCommitStatement x) {
    }

    @Override
    public boolean visit(MySqlCommitStatement x) {
        this.print("COMMIT");
        if (x.isWork()) {
            this.print(" WORK");
        }
        if (x.getChain() != null) {
            if (x.getChain().booleanValue()) {
                this.print(" AND CHAIN");
            } else {
                this.print(" AND NO CHAIN");
            }
        }
        if (x.getRelease() != null) {
            if (x.getRelease().booleanValue()) {
                this.print(" AND RELEASE");
            } else {
                this.print(" AND NO RELEASE");
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlRollbackStatement x) {
    }

    @Override
    public boolean visit(MySqlRollbackStatement x) {
        this.print("ROLLBACK");
        if (x.isWork()) {
            this.print(" WORK");
        }
        if (x.getChain() != null) {
            if (x.getChain().booleanValue()) {
                this.print(" AND CHAIN");
            } else {
                this.print(" AND NO CHAIN");
            }
        }
        if (x.getRelease() != null) {
            if (x.getRelease().booleanValue()) {
                this.print(" AND RELEASE");
            } else {
                this.print(" AND NO RELEASE");
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowColumnsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowColumnsStatement x) {
        if (x.isFull()) {
            this.print("SHOW FULL COLUMNS");
        } else {
            this.print("SHOW COLUMNS");
        }
        if (x.getTable() != null) {
            this.print(" FROM ");
            x.getTable().accept(this);
        }
        if (x.getDatabase() != null) {
            this.print(" FROM ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowTablesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowTablesStatement x) {
        if (x.isFull()) {
            this.print("SHOW FULL TABLES");
        } else {
            this.print("SHOW TABLES");
        }
        if (x.getDatabase() != null) {
            this.print(" FROM ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowDatabasesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowDatabasesStatement x) {
        this.print("SHOW DATABASES");
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowWarningsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowWarningsStatement x) {
        if (x.isCount()) {
            this.print("SHOW COUNT(*) WARNINGS");
        } else {
            this.print("SHOW WARNINGS");
            if (x.getLimit() != null) {
                this.print(' ');
                x.getLimit().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowStatusStatement x) {
        this.print("SHOW ");
        if (x.isGlobal()) {
            this.print("GLOBAL ");
        }
        if (x.isSession()) {
            this.print("SESSION ");
        }
        this.print("STATUS");
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlLoadXmlStatement x) {
    }

    @Override
    public boolean visit(MySqlLoadXmlStatement x) {
        this.print("LOAD XML ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isConcurrent()) {
            this.print("CONCURRENT ");
        }
        if (x.isLocal()) {
            this.print("LOCAL ");
        }
        this.print("INFILE ");
        x.getFileName().accept(this);
        if (x.isReplicate()) {
            this.print(" REPLACE ");
        }
        if (x.isIgnore()) {
            this.print(" IGNORE ");
        }
        this.print(" INTO TABLE ");
        x.getTableName().accept(this);
        if (x.getCharset() != null) {
            this.print(" CHARSET ");
            this.print(x.getCharset());
        }
        if (x.getRowsIdentifiedBy() != null) {
            this.print(" ROWS IDENTIFIED BY ");
            x.getRowsIdentifiedBy().accept(this);
        }
        if (x.getSetList().size() != 0) {
            this.print(" SET ");
            this.printAndAccept(x.getSetList(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(CobarShowStatus x) {
    }

    @Override
    public boolean visit(CobarShowStatus x) {
        this.print("SHOW COBAR_STATUS");
        return false;
    }
}

