/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;

public class MySqlParameterizedOutputVisitor
extends MySqlOutputVisitor {
    private static final String ATTR_PARAMS_SKIP = "_params.skip_";

    public MySqlParameterizedOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public void println() {
        this.print(' ');
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        x.getExpr().accept(this);
        if (x.isNot()) {
            this.print(" NOT IN (?)");
        } else {
            this.print(" IN (?)");
        }
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        x = this.merge(x);
        return super.visit(x);
    }

    @Override
    public boolean visit(SQLNullExpr x) {
        this.print('?');
        return false;
    }

    public SQLBinaryOpExpr merge(SQLBinaryOpExpr x) {
        if (x.getLeft() instanceof SQLLiteralExpr && x.getRight() instanceof SQLLiteralExpr) {
            if (x.getOperator() == SQLBinaryOperator.Equality || x.getOperator() == SQLBinaryOperator.NotEqual) {
                x.getLeft().getAttributes().put(ATTR_PARAMS_SKIP, true);
                x.getRight().getAttributes().put(ATTR_PARAMS_SKIP, true);
            }
            return x;
        }
        if (x.getRight() instanceof SQLLiteralExpr) {
            x = new SQLBinaryOpExpr(x.getLeft(), x.getOperator(), new SQLVariantRefExpr("?"));
        }
        if (x.getLeft() instanceof SQLLiteralExpr) {
            x = new SQLBinaryOpExpr((SQLExpr)new SQLVariantRefExpr("?"), x.getOperator(), x.getRight());
        }
        while (x.getRight() instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr leftBinaryExpr;
            if (x.getLeft() instanceof SQLBinaryOpExpr && (leftBinaryExpr = (SQLBinaryOpExpr)x.getLeft()).getRight().equals(x.getRight())) {
                x = leftBinaryExpr;
                continue;
            }
            x = new SQLBinaryOpExpr(x.getLeft(), x.getOperator(), this.merge((SQLBinaryOpExpr)x.getRight()));
            break;
        }
        if (x.getLeft() instanceof SQLBinaryOpExpr) {
            x = new SQLBinaryOpExpr((SQLExpr)this.merge((SQLBinaryOpExpr)x.getLeft()), x.getOperator(), x.getRight());
        }
        if (x.getOperator() == SQLBinaryOperator.BooleanOr && x.getLeft() instanceof SQLBinaryOpExpr && x.getRight() instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr right;
            SQLBinaryOpExpr left = (SQLBinaryOpExpr)x.getLeft();
            if (this.mergeEqual(left, right = (SQLBinaryOpExpr)x.getRight())) {
                return left;
            }
            if (this.isLiteralExpr(left.getLeft()) && left.getOperator() == SQLBinaryOperator.BooleanOr && this.mergeEqual(left.getRight(), right)) {
                return left;
            }
        }
        return x;
    }

    private boolean mergeEqual(SQLExpr a, SQLExpr b) {
        if (!(a instanceof SQLBinaryOpExpr)) {
            return false;
        }
        if (!(b instanceof SQLBinaryOpExpr)) {
            return false;
        }
        SQLBinaryOpExpr binaryA = (SQLBinaryOpExpr)a;
        SQLBinaryOpExpr binaryB = (SQLBinaryOpExpr)b;
        if (binaryA.getOperator() != SQLBinaryOperator.Equality) {
            return false;
        }
        if (binaryB.getOperator() != SQLBinaryOperator.Equality) {
            return false;
        }
        if (!(binaryA.getRight() instanceof SQLLiteralExpr) && !(binaryA.getRight() instanceof SQLVariantRefExpr)) {
            return false;
        }
        if (!(binaryB.getRight() instanceof SQLLiteralExpr) && !(binaryB.getRight() instanceof SQLVariantRefExpr)) {
            return false;
        }
        return binaryA.getLeft().toString().equals(binaryB.getLeft().toString());
    }

    private boolean isLiteralExpr(SQLExpr expr) {
        if (expr instanceof SQLLiteralExpr) {
            return true;
        }
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binary = (SQLBinaryOpExpr)expr;
            return this.isLiteralExpr(binary.getLeft()) && this.isLiteralExpr(binary.getRight());
        }
        return false;
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        if (Boolean.TRUE.equals(x.getAttribute(ATTR_PARAMS_SKIP))) {
            return super.visit(x);
        }
        this.print('?');
        return false;
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        if (Boolean.TRUE.equals(x.getAttribute(ATTR_PARAMS_SKIP))) {
            return super.visit(x);
        }
        this.print('?');
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        if (Boolean.TRUE.equals(x.getAttribute(ATTR_PARAMS_SKIP))) {
            return super.visit(x);
        }
        this.print('?');
        return false;
    }

    @Override
    public boolean visit(SQLNCharExpr x) {
        if (Boolean.TRUE.equals(x.getAttribute(ATTR_PARAMS_SKIP))) {
            return super.visit(x);
        }
        this.print('?');
        return false;
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        this.print("INSERT ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isDelayed()) {
            this.print("DELAYED ");
        }
        if (x.isHighPriority()) {
            this.print("HIGH_PRIORITY ");
        }
        if (x.isIgnore()) {
            this.print("IGNORE ");
        }
        this.print("INTO ");
        x.getTableName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print(" (");
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
        }
        if (x.getValuesList().size() != 0) {
            this.print(" VALUES ");
            int size = x.getValuesList().size();
            if (size == 0) {
                this.print("()");
            } else {
                for (int i = 0; i < 1; ++i) {
                    if (i != 0) {
                        this.print(", ");
                    }
                    x.getValuesList().get(i).accept(this);
                }
            }
        }
        if (x.getQuery() != null) {
            this.print(" ");
            x.getQuery().accept(this);
        }
        if (x.getDuplicateKeyUpdate().size() != 0) {
            this.print(" ON DUPLICATE KEY UPDATE ");
            this.printAndAccept(x.getDuplicateKeyUpdate(), ", ");
        }
        return false;
    }
}

