/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.visitor;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.stat.TableStat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MySqlSchemaStatVisitor
extends MySqlASTVisitorAdapter {
    private HashMap<TableStat.Name, TableStat> tableStats = new HashMap();
    private Set<TableStat.Column> fields = new HashSet<TableStat.Column>();
    private static final ThreadLocal<Map<String, String>> aliasLocal = new ThreadLocal();
    private static final ThreadLocal<String> currentTableLocal = new ThreadLocal();
    private static final ThreadLocal<TableStat.Mode> modeLocal = new ThreadLocal();

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        Map<String, String> aliasMap = aliasLocal.get();
        if (aliasMap != null && x.getAlias() != null) {
            aliasMap.put(x.getAlias(), null);
        }
        return true;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        if (x.getExpr() instanceof SQLIdentifierExpr) {
            String ident = ((SQLIdentifierExpr)x.getExpr()).getName();
            TableStat stat = this.tableStats.get(ident);
            if (stat == null) {
                stat = new TableStat();
                this.tableStats.put(new TableStat.Name(ident), stat);
            }
            TableStat.Mode mode = modeLocal.get();
            switch (mode) {
                case Delete: {
                    stat.incrementDeleteCount();
                    break;
                }
                case Insert: {
                    stat.incrementInsertCount();
                    break;
                }
                case Update: {
                    stat.incrementUpdateCount();
                    break;
                }
                case Select: {
                    stat.incrementSelectCount();
                    break;
                }
            }
            Map<String, String> aliasMap = aliasLocal.get();
            if (aliasMap != null) {
                if (x.getAlias() != null) {
                    aliasMap.put(x.getAlias(), ident);
                }
                aliasMap.put(ident, ident);
            }
        } else {
            this.accept(x.getExpr());
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        this.accept(x.getQuery());
        String originalTable = currentTableLocal.get();
        currentTableLocal.set((String)x.getQuery().getAttribute("table"));
        x.putAttribute("_old_local_", originalTable);
        this.accept(x.getOrderBy());
        currentTableLocal.set(originalTable);
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        this.accept(x.getArguments());
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        this.accept(x.getParameters());
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        aliasLocal.set(new HashMap());
        String ident = x.getTableName().toString();
        currentTableLocal.set(ident);
        TableStat stat = this.tableStats.get(ident);
        if (stat == null) {
            stat = new TableStat();
            this.tableStats.put(new TableStat.Name(ident), stat);
        }
        stat.incrementUpdateCount();
        Map<String, String> aliasMap = aliasLocal.get();
        aliasMap.put(ident, ident);
        this.accept(x.getItems());
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public void endVisit(SQLUpdateStatement x) {
        aliasLocal.set(null);
    }

    @Override
    public boolean visit(MySqlDeleteStatement x) {
        aliasLocal.set(new HashMap());
        x.putAttribute("_original_use_mode", (Object)modeLocal.get());
        modeLocal.set(TableStat.Mode.Delete);
        aliasLocal.set(new HashMap());
        if (x.getTableNames().size() == 1) {
            String ident = ((SQLIdentifierExpr)x.getTableNames().get(0)).getName();
            currentTableLocal.set(ident);
        }
        for (SQLName tableName : x.getTableNames()) {
            String ident = tableName.toString();
            TableStat stat = this.tableStats.get(ident);
            if (stat == null) {
                stat = new TableStat();
                this.tableStats.put(new TableStat.Name(ident), stat);
            }
            stat.incrementDeleteCount();
        }
        this.accept(x.getWhere());
        this.accept(x.getFrom());
        this.accept(x.getUsing());
        this.accept(x.getOrderBy());
        this.accept(x.getLimit());
        return false;
    }

    @Override
    public void endVisit(MySqlDeleteStatement x) {
        aliasLocal.set(null);
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        aliasLocal.set(new HashMap());
        return true;
    }

    @Override
    public void endVisit(SQLSelectStatement x) {
        aliasLocal.set(null);
    }

    @Override
    public void endVisit(MySqlInsertStatement x) {
        TableStat.Mode originalMode = (TableStat.Mode)((Object)x.getAttribute("_original_use_mode"));
        modeLocal.set(originalMode);
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        x.putAttribute("_original_use_mode", (Object)modeLocal.get());
        modeLocal.set(TableStat.Mode.Insert);
        aliasLocal.set(new HashMap());
        String originalTable = currentTableLocal.get();
        if (x.getTableName() instanceof SQLIdentifierExpr) {
            String ident = ((SQLIdentifierExpr)x.getTableName()).getName();
            currentTableLocal.set(ident);
            x.putAttribute("_old_local_", originalTable);
            TableStat stat = this.tableStats.get(ident);
            if (stat == null) {
                stat = new TableStat();
                this.tableStats.put(new TableStat.Name(ident), stat);
            }
            stat.incrementInsertCount();
            Map<String, String> aliasMap = aliasLocal.get();
            if (aliasMap != null) {
                if (x.getAlias() != null) {
                    aliasMap.put(x.getAlias(), ident);
                }
                aliasMap.put(ident, ident);
            }
        }
        this.accept(x.getColumns());
        this.accept(x.getValuesList());
        this.accept(x.getQuery());
        this.accept(x.getDuplicateKeyUpdate());
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        x.putAttribute("_original_use_mode", (Object)modeLocal.get());
        modeLocal.set(TableStat.Mode.Insert);
        aliasLocal.set(new HashMap());
        String originalTable = currentTableLocal.get();
        if (x.getTableName() instanceof SQLIdentifierExpr) {
            String ident = ((SQLIdentifierExpr)x.getTableName()).getName();
            currentTableLocal.set(ident);
            x.putAttribute("_old_local_", originalTable);
            TableStat stat = this.tableStats.get(ident);
            if (stat == null) {
                stat = new TableStat();
                this.tableStats.put(new TableStat.Name(ident), stat);
            }
            stat.incrementInsertCount();
            Map<String, String> aliasMap = aliasLocal.get();
            if (aliasMap != null) {
                if (x.getAlias() != null) {
                    aliasMap.put(x.getAlias(), ident);
                }
                aliasMap.put(ident, ident);
            }
        }
        this.accept(x.getColumns());
        this.accept(x.getQuery());
        return false;
    }

    protected void accept(SQLObject x) {
        if (x != null) {
            x.accept(this);
        }
    }

    protected void accept(List<? extends SQLObject> nodes) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            this.accept(nodes.get(i));
        }
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        SQLExprTableSource tableSource;
        if (x.getFrom() instanceof SQLSubqueryTableSource) {
            x.getFrom().accept(this);
            return false;
        }
        x.putAttribute("_original_use_mode", (Object)modeLocal.get());
        modeLocal.set(TableStat.Mode.Select);
        String originalTable = currentTableLocal.get();
        if (x.getFrom() instanceof SQLExprTableSource && (tableSource = (SQLExprTableSource)x.getFrom()).getExpr() instanceof SQLIdentifierExpr) {
            String ident = ((SQLIdentifierExpr)tableSource.getExpr()).getName();
            currentTableLocal.set(ident);
            x.putAttribute("_old_local_", originalTable);
        }
        x.getFrom().accept(this);
        return true;
    }

    @Override
    public void endVisit(SQLSelectQueryBlock x) {
        String originalTable = (String)x.getAttribute("_old_local_");
        x.putAttribute("table", currentTableLocal.get());
        currentTableLocal.set(originalTable);
        TableStat.Mode originalMode = (TableStat.Mode)((Object)x.getAttribute("_original_use_mode"));
        modeLocal.set(originalMode);
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        return true;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        String table;
        Map<String, String> aliasMap;
        String owner;
        if (x.getOwner() instanceof SQLIdentifierExpr && (owner = ((SQLIdentifierExpr)x.getOwner()).getName()) != null && (aliasMap = aliasLocal.get()) != null && (table = aliasMap.get(owner)) != null) {
            this.fields.add(new TableStat.Column(table, x.getName()));
        }
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String currentTable = currentTableLocal.get();
        if (currentTable != null) {
            this.fields.add(new TableStat.Column(currentTable, x.getName()));
        }
        return false;
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        String currentTable = currentTableLocal.get();
        if (currentTable != null) {
            this.fields.add(new TableStat.Column(currentTable, "*"));
        }
        return false;
    }

    public Map<TableStat.Name, TableStat> getTables() {
        return this.tableStats;
    }

    public boolean containsTable(String tableName) {
        return this.tableStats.containsKey(new TableStat.Name(tableName));
    }

    public Set<TableStat.Column> getFields() {
        return this.fields;
    }
}

