/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLParseException;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class OracleLexer
extends Lexer {
    public static final Keywords DEFAULT_ORACLE_KEYWORDS;

    public OracleLexer(char[] input, int inputLength, boolean skipComment) {
        super(input, inputLength, skipComment);
        this.keywods = DEFAULT_ORACLE_KEYWORDS;
    }

    public OracleLexer(String input) {
        super(input);
        this.keywods = DEFAULT_ORACLE_KEYWORDS;
    }

    @Override
    public void scanVariable() {
        char ch;
        if (this.ch == '@') {
            this.scanChar();
            this.token = Token.MONKEYS_AT;
            return;
        }
        if (this.ch != ':') {
            throw new SQLParseException("illegal variable");
        }
        int hash = this.ch;
        this.np = this.bp;
        this.sp = 1;
        while (CharTypes.isIdentifierChar(ch = this.buf[++this.bp])) {
            hash = 31 * hash + ch;
            ++this.sp;
        }
        this.ch = this.buf[this.bp];
        this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
        Token tok = this.keywods.getKeyword(this.stringVal);
        this.token = tok != null ? tok : Token.IDENTIFIER;
    }

    @Override
    public void scanComment() {
        if (this.ch != '/') {
            throw new IllegalStateException();
        }
        this.np = this.bp;
        this.sp = 0;
        this.scanChar();
        ++this.sp;
        if (this.ch == '*') {
            this.scanChar();
            ++this.sp;
            while (this.ch == ' ') {
                this.scanChar();
                ++this.sp;
            }
            boolean isHint = false;
            int startHintSp = this.sp + 1;
            if (this.ch == '+') {
                isHint = true;
                this.scanChar();
                ++this.sp;
            }
            while (true) {
                if (this.ch == '*' && this.buf[this.bp + 1] == '/') {
                    this.sp += 2;
                    break;
                }
                this.scanChar();
                ++this.sp;
            }
            this.scanChar();
            this.scanChar();
            if (isHint) {
                this.stringVal = new String(this.buf, this.np + startHintSp, this.sp - startHintSp - 2).trim();
                this.token = Token.HINT;
            } else {
                this.stringVal = new String(this.buf, this.np, this.sp);
                this.token = Token.MULTI_LINE_COMMENT;
            }
            return;
        }
        if (this.ch == '/') {
            this.scanChar();
            ++this.sp;
            while (true) {
                if (this.ch == '\r') {
                    if (this.buf[this.bp + 1] == '\n') {
                        this.sp += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.sp;
                    break;
                }
                if (this.ch == '\r') {
                    this.scanChar();
                    ++this.sp;
                    break;
                }
                this.scanChar();
                ++this.sp;
            }
            this.stringVal = new String(this.buf, this.np + 1, this.sp);
            this.token = Token.LINE_COMMENT;
            return;
        }
    }

    @Override
    public void scanNumber() {
        this.np = this.bp++;
        if (this.ch == '-') {
            ++this.sp;
            this.ch = this.buf[this.bp];
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            isDouble = true;
        }
        if (this.ch == 'f' || this.ch == 'F') {
            this.token = Token.BINARY_FLOAT;
            this.scanChar();
            return;
        }
        if (this.ch == 'd' || this.ch == 'D') {
            this.token = Token.BINARY_DOUBLE;
            this.scanChar();
            return;
        }
        this.token = isDouble ? Token.LITERAL_FLOAT : Token.LITERAL_INT;
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.put("EXISTS", Token.EXISTS);
        map.put("THEN", Token.THEN);
        map.put("AS", Token.AS);
        map.put("GROUP", Token.GROUP);
        map.put("BY", Token.BY);
        map.put("HAVING", Token.HAVING);
        map.put("DELETE", Token.DELETE);
        map.put("ORDER", Token.ORDER);
        map.put("INDEX", Token.INDEX);
        map.put("FOR", Token.FOR);
        map.put("SCHEMA", Token.SCHEMA);
        map.put("FOREIGN", Token.FOREIGN);
        map.put("REFERENCE", Token.REFERENCE);
        map.put("REFERENCES", Token.REFERENCES);
        map.put("CHECK", Token.CHECK);
        map.put("PRIMARY", Token.PRIMARY);
        map.put("KEY", Token.KEY);
        map.put("CONSTRAINT", Token.CONSTRAINT);
        map.put("DEFAULT", Token.DEFAULT);
        map.put("VIEW", Token.VIEW);
        map.put("CREATE", Token.CREATE);
        map.put("VALUES", Token.VALUES);
        map.put("ALTER", Token.ALTER);
        map.put("TABLE", Token.TABLE);
        map.put("DROP", Token.DROP);
        map.put("SET", Token.SET);
        map.put("INTO", Token.INTO);
        map.put("UPDATE", Token.UPDATE);
        map.put("NULL", Token.NULL);
        map.put("IS", Token.IS);
        map.put("NOT", Token.NOT);
        map.put("SELECT", Token.SELECT);
        map.put("INSERT", Token.INSERT);
        map.put("FROM", Token.FROM);
        map.put("WHERE", Token.WHERE);
        map.put("AND", Token.AND);
        map.put("OR", Token.OR);
        map.put("XOR", Token.XOR);
        map.put("DISTINCT", Token.DISTINCT);
        map.put("UNIQUE", Token.UNIQUE);
        map.put("ALL", Token.ALL);
        map.put("UNION", Token.UNION);
        map.put("INTERSECT", Token.INTERSECT);
        map.put("MINUS", Token.MINUS);
        map.put("INNER", Token.INNER);
        map.put("LEFT", Token.LEFT);
        map.put("RIGHT", Token.RIGHT);
        map.put("FULL", Token.FULL);
        map.put("ON", Token.ON);
        map.put("OUTER", Token.OUTER);
        map.put("JOIN", Token.JOIN);
        map.put("NEW", Token.NEW);
        map.put("CASE", Token.CASE);
        map.put("WHEN", Token.WHEN);
        map.put("END", Token.END);
        map.put("WHEN", Token.WHEN);
        map.put("ELSE", Token.ELSE);
        map.put("EXISTS", Token.EXISTS);
        map.put("CAST", Token.CAST);
        map.put("IN", Token.IN);
        map.put("ASC", Token.ASC);
        map.put("DESC", Token.DESC);
        map.put("LIKE", Token.LIKE);
        map.put("ESCAPE", Token.ESCAPE);
        map.put("BETWEEN", Token.BETWEEN);
        map.put("INTERVAL", Token.INTERVAL);
        map.put("LOCK", Token.LOCK);
        map.put("SOME", Token.SOME);
        map.put("ANY", Token.ANY);
        map.put("START", Token.START);
        map.put("CONNECT", Token.CONNECT);
        map.put("PRIOR", Token.PRIOR);
        map.put("WITH", Token.WITH);
        map.put("EXTRACT", Token.EXTRACT);
        map.put("DATE", Token.DATE);
        map.put("TIMESTAMP", Token.TIMESTAMP);
        map.put("CURSOR", Token.CURSOR);
        map.put("DAY", Token.DAY);
        map.put("YEAR", Token.YEAR);
        map.put("MONTH", Token.MONTH);
        map.put("MINUTE", Token.MINUTE);
        map.put("SECOND", Token.SECOND);
        map.put("TO", Token.TO);
        map.put("MODEL", Token.MODEL);
        DEFAULT_ORACLE_KEYWORDS = new Keywords(map);
    }
}

