/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateSetListClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateSetListSingleColumnItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;

public class OracleUpdateParser
extends SQLStatementParser {
    public OracleUpdateParser(String sql) throws ParserException {
        super(sql);
    }

    public OracleUpdateParser(Lexer lexer) {
        super(lexer);
    }

    public OracleUpdateStatement parseUpdate() throws ParserException {
        this.accept(Token.UPDATE);
        OracleUpdateStatement update = new OracleUpdateStatement();
        this.parseHints(update);
        if (this.identifierEquals("ONLY")) {
            update.setOnly(true);
        }
        update.setTable(this.exprParser.expr());
        if (update.getAlias() == null || update.getAlias().length() == 0) {
            update.setAlias(this.as());
        }
        this.parseSet(update);
        this.parseWhere(update);
        this.parseReturn(update);
        this.parseErrorLoging(update);
        return update;
    }

    private void parseErrorLoging(OracleUpdateStatement update) throws ParserException {
        if (this.identifierEquals("LOG")) {
            throw new ParserException("TODO");
        }
    }

    private void parseReturn(OracleUpdateStatement update) throws ParserException {
        if (this.identifierEquals("RETURN") || this.identifierEquals("RETURNING")) {
            throw new ParserException("TODO");
        }
    }

    private void parseHints(OracleUpdateStatement update) throws ParserException {
        if (this.lexer.token() == Token.HINT) {
            throw new ParserException("TODO");
        }
    }

    private void parseWhere(OracleUpdateStatement update) throws ParserException {
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            update.setWhere(this.exprParser.expr());
        }
    }

    private void parseSet(OracleUpdateStatement update) throws ParserException {
        this.accept(Token.SET);
        if (this.identifierEquals("VALUE")) {
            throw new ParserException("TODO");
        }
        OracleUpdateSetListClause setListClause = new OracleUpdateSetListClause();
        while (true) {
            if (this.lexer.token() == Token.LPAREN) {
                throw new ParserException("TODO");
            }
            OracleUpdateSetListSingleColumnItem item = new OracleUpdateSetListSingleColumnItem();
            item.setColumn(this.exprParser.primary());
            this.accept(Token.EQ);
            item.setValue(this.exprParser.expr());
            setListClause.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        update.setSetClause(setListClause);
    }

    @Override
    protected SQLExprParser createExprParser() {
        return new OracleExprParser(this.lexer);
    }
}

