/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.visitor;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLObjectCreateExpr;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleHint;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleOrderBy;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.CycleClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.FlashbackQueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.GroupingSetExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.ModelClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.PartitionExtensionClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SampleClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SearchClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SubqueryFactoringClause;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAggregateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalytic;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalyticWindowing;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryDoubleExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryFloatExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleCursorExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDbLinkExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleExtractExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIntervalExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIsSetExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleOuterExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleTimestampExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleConstraintState;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleOrderByItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePLSQLCommitStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelect;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectForUpdate;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectHierachicalQueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectRestriction;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectUnPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleTableExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateSetListClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateSetListMultiColumnItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateSetListSingleColumnItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateSetValueClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class OracleOutputVisitor
extends SQLASTOutputVisitor
implements OracleASTVisitor {
    public OracleOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public void postVisit(SQLObject astNode) {
        if (astNode instanceof SQLStatement) {
            if (astNode instanceof OraclePLSQLCommitStatement) {
                return;
            }
            this.println(";");
        }
    }

    private void printHints(List<OracleHint> hints) {
        if (hints.size() > 0) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean visit(OracleAggregateExpr expr) {
        expr.getMethodName().accept(this);
        this.print("(");
        this.printAndAccept(expr.getArguments(), ", ");
        this.print(")");
        if (expr.getOver() != null) {
            this.print(" OVER (");
            expr.getOver().accept(this);
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        this.print("*");
        return false;
    }

    @Override
    public boolean visit(OracleAnalytic x) {
        boolean space = false;
        if (x.getPartitionBy().size() > 0) {
            this.print("PARTITION BY ");
            this.printAndAccept(x.getPartitionBy(), ", ");
            space = true;
        }
        if (x.getOrderBy() != null) {
            if (space) {
                this.print(" ");
            }
            x.getOrderBy().accept(this);
            space = true;
        }
        if (x.getWindowing() != null) {
            if (space) {
                this.print(" ");
            }
            x.getWindowing().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleAnalyticWindowing x) {
        this.print(x.getType().name().toUpperCase());
        this.print(" ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(OracleDateExpr x) {
        this.print("DATE '");
        this.print(x.getLiteral());
        this.print('\'');
        return false;
    }

    @Override
    public boolean visit(OracleDbLinkExpr x) {
        x.getExpr().accept(this);
        this.print("@");
        this.print(x.getDbLink());
        return false;
    }

    @Override
    public boolean visit(OracleDeleteStatement x) {
        this.print("DELETE ");
        this.printHints(x.getHints());
        this.print("FROM ");
        if (x.isOnly()) {
            this.print("ONLY (");
            x.getTableName().accept(this);
            this.print(")");
        } else {
            x.getTableName().accept(this);
        }
        this.printAlias(x.getAlias());
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleExtractExpr x) {
        this.print("EXTRACT(");
        this.print(x.getUnit().name());
        this.print(" FROM ");
        x.getFrom().accept(this);
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(OracleHint x) {
        this.print(x.getName());
        return false;
    }

    @Override
    public boolean visit(OracleIntervalExpr x) {
        if (x.getValue() instanceof SQLLiteralExpr) {
            this.print("INTERVAL ");
            x.getValue().accept(this);
            this.print(" ");
        } else {
            this.print('(');
            x.getValue().accept(this);
            this.print(") ");
        }
        this.print(x.getType().name());
        if (x.getPrecision() != null) {
            this.print("(");
            this.print(x.getPrecision());
            if (x.getFactionalSecondsPrecision() != null) {
                this.print(", ");
                this.print(x.getFactionalSecondsPrecision());
            }
            this.print(")");
        }
        if (x.getToType() != null) {
            this.print(" TO ");
            this.print(x.getToType().name());
            if (x.getToFactionalSecondsPrecision() != null) {
                this.print("(");
                this.print(x.getToFactionalSecondsPrecision());
                this.print(")");
            }
        }
        return false;
    }

    @Override
    public boolean visit(OracleOrderBy x) {
        if (x.getItems().size() > 0) {
            this.print("ORDER ");
            if (x.isSibings()) {
                this.print("SIBLINGS ");
            }
            this.print("BY ");
            this.printAndAccept(x.getItems(), ", ");
        }
        return false;
    }

    @Override
    public boolean visit(OracleOuterExpr x) {
        x.getExpr().accept(this);
        this.print("(+)");
        return false;
    }

    @Override
    public boolean visit(OraclePLSQLCommitStatement astNode) {
        this.print("/");
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        if (x instanceof OracleSelect) {
            return this.visit((OracleSelect)x);
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(OracleSelect x) {
        if (x.getFactoring() != null) {
            x.getFactoring().accept(this);
            this.println();
        }
        x.getQuery().accept(this);
        if (x.getRestriction() != null) {
            this.print(" ");
            x.getRestriction().accept(this);
        }
        if (x.getForUpdate() != null) {
            this.println();
            x.getForUpdate().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectForUpdate x) {
        this.print("FOR UPDATE");
        if (x.getOf().size() > 0) {
            this.print("(");
            this.printAndAccept(x.getOf(), ", ");
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectHierachicalQueryClause x) {
        if (x.getStartWith() != null) {
            this.print("START WITH ");
            x.getStartWith().accept(this);
            this.println();
        }
        this.print("CONNECT BY ");
        if (x.isPrior()) {
            this.print("PRIOR ");
        }
        if (x.isNoCycle()) {
            this.print("NOCYCLE ");
        }
        x.getConnectBy().accept(this);
        return false;
    }

    @Override
    public boolean visit(OracleSelectJoin x) {
        x.getLeft().accept(this);
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print(",");
        } else {
            this.print(" ");
            this.print(SQLJoinTableSource.JoinType.toString(x.getJoinType()));
        }
        this.print(" ");
        x.getRight().accept(this);
        if (x.getCondition() != null) {
            this.print(" ON ");
            x.getCondition().accept(this);
            this.print(" ");
        }
        if (x.getUsing().size() > 0) {
            this.print(" USING (");
            this.printAndAccept(x.getUsing(), ", ");
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(OracleOrderByItem x) {
        x.getExpr().accept(this);
        if (x.getType() != null) {
            this.print(" ");
            this.print(x.getType().name().toUpperCase());
        }
        if (x.getNullsOrderType() != null) {
            this.print(" ");
            this.print(x.getNullsOrderType().toFormalString());
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectPivot x) {
        this.print("PIVOT");
        if (x.isXml()) {
            this.print(" XML");
        }
        this.print(" (");
        this.printAndAccept(x.getItems(), ", ");
        if (x.getPivotFor().size() > 0) {
            this.print(" FOR ");
            if (x.getPivotFor().size() == 1) {
                x.getPivotFor().get(0).accept(this);
            } else {
                this.print("(");
                this.printAndAccept(x.getPivotFor(), ", ");
                this.print(")");
            }
        }
        if (x.getPivotIn().size() > 0) {
            this.print(" IN (");
            this.printAndAccept(x.getPivotIn(), ", ");
            this.print(")");
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(OracleSelectPivot.Item x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null && x.getAlias().length() > 0) {
            this.print(" AS ");
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock select) {
        if (select instanceof OracleSelectQueryBlock) {
            return this.visit((OracleSelectQueryBlock)select);
        }
        return super.visit(select);
    }

    public boolean visit(OracleSelectQueryBlock select) {
        this.print("SELECT ");
        if (1 == select.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == select.getDistionOption()) {
            this.print("DISTINCT ");
        } else if (3 == select.getDistionOption()) {
            this.print("UNIQUE ");
        }
        if (select.getHints().size() > 0) {
            this.print("/*+");
            this.printAndAccept(select.getHints(), ", ");
            this.print("*/ ");
        }
        this.printSelectList(select.getSelectList());
        this.println();
        this.print("FROM ");
        if (select.getFrom() == null) {
            this.print("DUAL");
        } else {
            select.getFrom().accept(this);
        }
        if (select.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            select.getWhere().accept(this);
        }
        if (select.getHierachicalQueryClause() != null) {
            this.println();
            select.getHierachicalQueryClause().accept(this);
        }
        if (select.getGroupBy() != null) {
            this.println();
            select.getGroupBy().accept(this);
        }
        if (select.getModelClause() != null) {
            this.println();
            select.getModelClause().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectRestriction.CheckOption x) {
        this.print("CHECK OPTION");
        if (x.getConstraint() != null) {
            this.print(" ");
            x.getConstraint().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectRestriction.ReadOnly x) {
        this.print("READ ONLY");
        return false;
    }

    @Override
    public boolean visit(OracleSelectSubqueryTableSource x) {
        this.print("(");
        this.incrementIndent();
        x.getSelect().accept(this);
        this.println();
        this.decrementIndent();
        this.print(")");
        if (x.getPivot() != null) {
            this.incrementIndent();
            this.println();
            x.getPivot().accept(this);
            this.decrementIndent();
        }
        if (x.getAlias() != null && x.getAlias().length() != 0) {
            this.print(" ");
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectTableReference x) {
        if (x.isOnly()) {
            this.print("ONLY (");
            x.getExpr().accept(this);
            if (x.getPartition() != null) {
                this.print(" ");
                x.getPartition().accept(this);
            }
            this.print(")");
        } else {
            x.getExpr().accept(this);
            if (x.getPartition() != null) {
                this.print(" ");
                x.getPartition().accept(this);
            }
        }
        if (x.getSampleClause() != null) {
            this.println();
            x.getSampleClause().accept(this);
        }
        if (x.getPivot() != null) {
            this.incrementIndent();
            this.println();
            x.getPivot().accept(this);
            this.decrementIndent();
        }
        if (x.getFlashback() != null) {
            this.println();
            x.getFlashback().accept(this);
        }
        this.printAlias(x.getAlias());
        return false;
    }

    @Override
    public boolean visit(OracleSelectUnPivot x) {
        this.print("UNPIVOT");
        if (x.getNullsIncludeType() != null) {
            this.print(" ");
            this.print(OracleSelectUnPivot.NullsIncludeType.toString(x.getNullsIncludeType()));
        }
        this.print(" (");
        if (x.getItems().size() == 1) {
            x.getItems().get(0).accept(this);
        } else {
            this.print(" (");
            this.printAndAccept(x.getItems(), ", ");
            this.print(")");
        }
        if (x.getPivotFor().size() > 0) {
            this.print(" FOR ");
            if (x.getPivotFor().size() == 1) {
                x.getPivotFor().get(0).accept(this);
            } else {
                this.print("(");
                this.printAndAccept(x.getPivotFor(), ", ");
                this.print(")");
            }
        }
        if (x.getPivotIn().size() > 0) {
            this.print(" IN (");
            this.printAndAccept(x.getPivotIn(), ", ");
            this.print(")");
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(OracleTableExpr x) {
        x.getTable().accept(this);
        if (x.getPartition() != null) {
            this.print(" PARTITION (");
            x.getPartition().accept(this);
            this.print(")");
        } else if (x.getPartitionFor().size() > 0) {
            this.print(" PARTITION FOR (");
            int size = x.getPartitionFor().size();
            for (int i = 0; i < size; ++i) {
                x.getPartitionFor().get(i).accept(this);
            }
            this.print(")");
        } else if (x.getSubPartition() != null) {
            this.print(" SUBPARTITION (");
            x.getSubPartition().accept(this);
            this.print(")");
        } else if (x.getSubPartitionFor().size() > 0) {
            this.print(" SUBPARTITION FOR (");
            int size = x.getSubPartitionFor().size();
            for (int i = 0; i < size; ++i) {
                x.getSubPartitionFor().get(i).accept(this);
            }
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(OracleTimestampExpr x) {
        this.print("TIMESTAMP '");
        this.print(x.getLiteral());
        this.print('\'');
        if (x.getTimeZone() != null) {
            this.print(" AT TIME ZONE '");
            this.print(x.getTimeZone());
            this.print('\'');
        }
        return false;
    }

    @Override
    public boolean visit(OracleUpdateSetListClause x) {
        this.print("SET ");
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    @Override
    public boolean visit(OracleUpdateSetListMultiColumnItem x) {
        this.print("(");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(") = (");
        x.getSubQuery().accept(this);
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(OracleUpdateSetListSingleColumnItem x) {
        x.getColumn().accept(this);
        this.print(" = ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(OracleUpdateSetValueClause x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean visit(OracleUpdateStatement x) {
        this.print("UPDATE ");
        this.printHints(x.getHints());
        if (x.isOnly()) {
            this.print("ONLY (");
            x.getTable().accept(this);
            this.print(")");
        } else {
            x.getTable().accept(this);
        }
        this.printAlias(x.getAlias());
        this.println();
        x.getSetClause().accept(this);
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleAggregateExpr astNode) {
    }

    @Override
    public void endVisit(OracleConstraintState astNode) {
    }

    @Override
    public void endVisit(OraclePLSQLCommitStatement astNode) {
    }

    @Override
    public void endVisit(OracleAnalytic x) {
    }

    @Override
    public void endVisit(OracleAnalyticWindowing x) {
    }

    @Override
    public void endVisit(SQLDataType x) {
    }

    @Override
    public void endVisit(OracleDateExpr x) {
    }

    @Override
    public void endVisit(OracleDbLinkExpr x) {
    }

    @Override
    public void endVisit(OracleDeleteStatement x) {
    }

    @Override
    public void endVisit(OracleExtractExpr x) {
    }

    @Override
    public void endVisit(OracleHint x) {
    }

    @Override
    public void endVisit(OracleIntervalExpr x) {
    }

    @Override
    public void endVisit(SQLMethodInvokeExpr x) {
    }

    @Override
    public void endVisit(SQLObjectCreateExpr x) {
    }

    @Override
    public void endVisit(OracleOrderBy x) {
    }

    @Override
    public void endVisit(OracleOuterExpr x) {
    }

    @Override
    public void endVisit(OracleSelectForUpdate x) {
    }

    @Override
    public void endVisit(OracleSelectHierachicalQueryClause x) {
    }

    @Override
    public void endVisit(OracleSelectJoin x) {
    }

    @Override
    public void endVisit(OracleOrderByItem x) {
    }

    @Override
    public void endVisit(OracleSelectPivot x) {
    }

    @Override
    public void endVisit(OracleSelectPivot.Item x) {
    }

    @Override
    public void endVisit(OracleSelectRestriction.CheckOption x) {
    }

    @Override
    public void endVisit(OracleSelectRestriction.ReadOnly x) {
    }

    @Override
    public void endVisit(OracleSelectSubqueryTableSource x) {
    }

    @Override
    public void endVisit(OracleSelectUnPivot x) {
    }

    @Override
    public void endVisit(OracleTableExpr x) {
    }

    @Override
    public void endVisit(OracleTimestampExpr x) {
    }

    @Override
    public void endVisit(OracleUpdateSetListClause x) {
    }

    @Override
    public void endVisit(OracleUpdateSetListMultiColumnItem x) {
    }

    @Override
    public void endVisit(OracleUpdateSetListSingleColumnItem x) {
    }

    @Override
    public void endVisit(OracleUpdateSetValueClause x) {
    }

    @Override
    public void endVisit(OracleUpdateStatement x) {
    }

    @Override
    public boolean visit(SampleClause x) {
        this.print("SAMPLE ");
        if (x.isBlock()) {
            this.print("BLOCK ");
        }
        this.print("(");
        this.print(x.getPercent());
        this.print(")");
        if (x.getSeedValue() != null) {
            this.print(" SEED (");
            x.getSeedValue().accept(this);
            this.print(")");
        }
        return false;
    }

    @Override
    public void endVisit(SampleClause x) {
    }

    @Override
    public void endVisit(OracleSelectTableReference x) {
    }

    @Override
    public boolean visit(PartitionExtensionClause x) {
        if (x.isSubPartition()) {
            this.print("SUBPARTITION ");
        } else {
            this.print("PARTITION ");
        }
        if (x.getPartition() != null) {
            this.print("(");
            x.getPartition().accept(this);
            this.print(")");
        } else {
            this.print("FOR (");
            this.printAndAccept(x.getFor(), ",");
            this.print(")");
        }
        return false;
    }

    @Override
    public void endVisit(PartitionExtensionClause x) {
    }

    @Override
    public boolean visit(FlashbackQueryClause.VersionsFlashbackQueryClause x) {
        this.print("VERSIONS BETWEEN ");
        this.print(x.getType().name());
        this.print(" ");
        x.getBegin().accept(this);
        this.print(" AND ");
        x.getEnd().accept(this);
        return false;
    }

    @Override
    public void endVisit(FlashbackQueryClause.VersionsFlashbackQueryClause x) {
    }

    @Override
    public boolean visit(FlashbackQueryClause.AsOfFlashbackQueryClause x) {
        this.print("AS OF ");
        this.print(x.getType().name());
        this.print(" (");
        x.getExpr().accept(this);
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(FlashbackQueryClause.AsOfFlashbackQueryClause x) {
    }

    @Override
    public boolean visit(GroupingSetExpr x) {
        this.print("GROUPING SETS");
        this.print(" (");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(GroupingSetExpr x) {
    }

    @Override
    public boolean visit(SubqueryFactoringClause.Entry x) {
        x.getName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(")");
        }
        this.println();
        this.print("AS");
        this.println();
        this.print("(");
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(")");
        if (x.getSearchClause() != null) {
            this.println();
            x.getSearchClause().accept(this);
        }
        if (x.getCycleClause() != null) {
            this.println();
            x.getCycleClause().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SubqueryFactoringClause.Entry x) {
    }

    @Override
    public boolean visit(SubqueryFactoringClause x) {
        this.print("WITH");
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getEntries(), ", ");
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(SubqueryFactoringClause x) {
    }

    @Override
    public boolean visit(SearchClause x) {
        this.print("SEARCH ");
        this.print(x.getType().name());
        this.print(" FIRST BY ");
        this.printAndAccept(x.getItems(), ", ");
        this.print(" SET ");
        x.getOrderingColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(SearchClause x) {
    }

    @Override
    public boolean visit(CycleClause x) {
        this.print("CYCLE ");
        this.printAndAccept(x.getAliases(), ", ");
        this.print(" SET ");
        x.getMark().accept(this);
        this.print(" TO ");
        x.getValue().accept(this);
        this.print(" DEFAULT ");
        x.getDefaultValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(CycleClause x) {
    }

    @Override
    public boolean visit(OracleBinaryFloatExpr x) {
        this.print(x.getValue().toString());
        this.print('F');
        return false;
    }

    @Override
    public void endVisit(OracleBinaryFloatExpr x) {
    }

    @Override
    public boolean visit(OracleBinaryDoubleExpr x) {
        this.print(x.getValue().toString());
        this.print('D');
        return false;
    }

    @Override
    public void endVisit(OracleBinaryDoubleExpr x) {
    }

    @Override
    public void endVisit(OracleSelect x) {
    }

    @Override
    public boolean visit(OracleConstraintState x) {
        this.printlnAndAccept(x.getStates(), " ");
        return false;
    }

    @Override
    public boolean visit(OracleCursorExpr x) {
        this.print("CURSOR(");
        x.getQuery().accept(this);
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(OracleCursorExpr x) {
    }

    @Override
    public boolean visit(OracleIsSetExpr x) {
        x.getNestedTable().accept(this);
        this.print(" IS A SET");
        return false;
    }

    @Override
    public void endVisit(OracleIsSetExpr x) {
    }

    @Override
    public boolean visit(ModelClause.ReturnRowsClause x) {
        if (x.isAll()) {
            this.print("RETURN ALL ROWS");
        } else {
            this.print("RETURN UPDATED ROWS");
        }
        return false;
    }

    @Override
    public void endVisit(ModelClause.ReturnRowsClause x) {
    }

    @Override
    public boolean visit(ModelClause x) {
        this.print("MODEL");
        this.incrementIndent();
        for (ModelClause.CellReferenceOption opt : x.getCellReferenceOptions()) {
            this.print(' ');
            this.print(opt.name);
        }
        if (x.getReturnRowsClause() != null) {
            this.print(' ');
            x.getReturnRowsClause().accept(this);
        }
        for (ModelClause.ReferenceModelClause item : x.getReferenceModelClauses()) {
            this.print(' ');
            item.accept(this);
        }
        x.getMainModel().accept(this);
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(ModelClause x) {
    }

    @Override
    public boolean visit(ModelClause.MainModelClause x) {
        if (x.getMainModelName() != null) {
            this.print(" MAIN ");
            x.getMainModelName().accept(this);
        }
        this.println();
        x.getModelColumnClause().accept(this);
        for (ModelClause.CellReferenceOption opt : x.getCellReferenceOptions()) {
            this.println();
            this.print(opt.name);
        }
        this.println();
        x.getModelRulesClause().accept(this);
        return false;
    }

    @Override
    public void endVisit(ModelClause.MainModelClause x) {
    }

    @Override
    public boolean visit(ModelClause.ModelColumnClause x) {
        if (x.getQueryPartitionClause() != null) {
            x.getQueryPartitionClause().accept(this);
            this.println();
        }
        this.print("DIMENSION BY (");
        this.printAndAccept(x.getDimensionByColumns(), ", ");
        this.print(")");
        this.println();
        this.print("MEASURES (");
        this.printAndAccept(x.getMeasuresColumns(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(ModelClause.ModelColumnClause x) {
    }

    @Override
    public boolean visit(ModelClause.QueryPartitionClause x) {
        this.print("PARTITION BY (");
        this.printAndAccept(x.getExprList(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(ModelClause.QueryPartitionClause x) {
    }

    @Override
    public boolean visit(ModelClause.ModelColumn x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null) {
            this.print(" ");
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public void endVisit(ModelClause.ModelColumn x) {
    }

    @Override
    public boolean visit(ModelClause.ModelRulesClause x) {
        if (x.getOptions().size() > 0) {
            this.print("RULES");
            for (ModelClause.ModelRuleOption opt : x.getOptions()) {
                this.print(" ");
                this.print(opt.name);
            }
        }
        if (x.getIterate() != null) {
            this.print(" ITERATE (");
            x.getIterate().accept(this);
            this.print(")");
            if (x.getUntil() != null) {
                this.print(" UNTIL (");
                x.getUntil().accept(this);
                this.print(")");
            }
        }
        this.print(" (");
        this.printAndAccept(x.getCellAssignmentItems(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(ModelClause.ModelRulesClause x) {
    }

    @Override
    public boolean visit(ModelClause.CellAssignmentItem x) {
        if (x.getOption() != null) {
            this.print(x.getOption().name);
            this.print(" ");
        }
        x.getCellAssignment().accept(this);
        if (x.getOrderBy() != null) {
            this.print(" ");
            x.getOrderBy().accept(this);
        }
        this.print(" = ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(ModelClause.CellAssignmentItem x) {
    }

    @Override
    public boolean visit(ModelClause.CellAssignment x) {
        x.getMeasureColumn().accept(this);
        this.print("[");
        this.printAndAccept(x.getConditions(), ", ");
        this.print("]");
        return false;
    }

    @Override
    public void endVisit(ModelClause.CellAssignment x) {
    }
}

