/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAggregateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelect;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVIsitorAdapter;
import com.alibaba.druid.stat.TableStat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OracleSchemaStatVisitor
extends OracleASTVIsitorAdapter {
    private HashMap<TableStat.Name, TableStat> tableStats = new HashMap();
    private Set<TableStat.Column> fields = new HashSet<TableStat.Column>();
    private static final ThreadLocal<Map<String, String>> aliasLocal = new ThreadLocal();
    private static final ThreadLocal<String> currentTableLocal = new ThreadLocal();
    private static final ThreadLocal<TableStat.Mode> modeLocal = new ThreadLocal();

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        Map<String, String> aliasMap = aliasLocal.get();
        if (aliasMap != null && x.getAlias() != null) {
            aliasMap.put(x.getAlias(), null);
        }
        return true;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        if (x.getExpr() instanceof SQLName) {
            String ident = ((SQLName)x.getExpr()).toString();
            TableStat stat = this.tableStats.get(ident);
            if (stat == null) {
                stat = new TableStat();
                this.tableStats.put(new TableStat.Name(ident), stat);
            }
            TableStat.Mode mode = modeLocal.get();
            switch (mode) {
                case Delete: {
                    stat.incrementDeleteCount();
                    break;
                }
                case Insert: {
                    stat.incrementInsertCount();
                    break;
                }
                case Update: {
                    stat.incrementUpdateCount();
                    break;
                }
                case Select: {
                    stat.incrementSelectCount();
                    break;
                }
            }
            Map<String, String> aliasMap = aliasLocal.get();
            if (aliasMap != null) {
                if (x.getAlias() != null) {
                    aliasMap.put(x.getAlias(), ident);
                }
                aliasMap.put(ident, ident);
            }
        } else {
            this.accept(x.getExpr());
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectTableReference x) {
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLName) {
            String ident = ((SQLName)expr).toString();
            TableStat stat = this.tableStats.get(ident);
            if (stat == null) {
                stat = new TableStat();
                this.tableStats.put(new TableStat.Name(ident), stat);
            }
            TableStat.Mode mode = modeLocal.get();
            switch (mode) {
                case Delete: {
                    stat.incrementDeleteCount();
                    break;
                }
                case Insert: {
                    stat.incrementInsertCount();
                    break;
                }
                case Update: {
                    stat.incrementUpdateCount();
                    break;
                }
                case Select: {
                    stat.incrementSelectCount();
                    break;
                }
            }
            Map<String, String> aliasMap = aliasLocal.get();
            if (aliasMap != null) {
                if (x.getAlias() != null) {
                    aliasMap.put(x.getAlias(), ident);
                }
                aliasMap.put(ident, ident);
            }
            return false;
        }
        this.accept(x.getExpr());
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        this.accept(x.getArguments());
        return false;
    }

    @Override
    public boolean visit(OracleAggregateExpr x) {
        this.accept(x.getArguments());
        this.accept(x.getOver());
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        this.accept(x.getParameters());
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        this.accept(x.getQuery());
        String originalTable = currentTableLocal.get();
        currentTableLocal.set((String)x.getQuery().getAttribute("table"));
        x.putAttribute("_old_local_", originalTable);
        this.accept(x.getOrderBy());
        currentTableLocal.set(originalTable);
        return false;
    }

    @Override
    public void endVisit(OracleSelect x) {
    }

    @Override
    public boolean visit(OracleSelect x) {
        this.accept(x.getFactoring());
        this.accept(x.getQuery());
        String originalTable = currentTableLocal.get();
        currentTableLocal.set((String)x.getQuery().getAttribute("table"));
        x.putAttribute("_old_local_", originalTable);
        this.accept(x.getOrderBy());
        currentTableLocal.set(originalTable);
        return false;
    }

    @Override
    public void endVisit(SQLSelect x) {
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        aliasLocal.set(new HashMap());
        String ident = x.getTableName().toString();
        currentTableLocal.set(ident);
        TableStat stat = this.tableStats.get(ident);
        if (stat == null) {
            stat = new TableStat();
            this.tableStats.put(new TableStat.Name(ident), stat);
        }
        stat.incrementUpdateCount();
        Map<String, String> aliasMap = aliasLocal.get();
        aliasMap.put(ident, ident);
        this.accept(x.getItems());
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public void endVisit(SQLUpdateStatement x) {
        aliasLocal.set(null);
    }

    @Override
    public boolean visit(OracleUpdateStatement x) {
        aliasLocal.set(new HashMap());
        if (x.getTable() instanceof SQLIdentifierExpr) {
            String ident = x.getTable().toString();
            currentTableLocal.set(ident);
            TableStat stat = this.tableStats.get(ident);
            if (stat == null) {
                stat = new TableStat();
                this.tableStats.put(new TableStat.Name(ident), stat);
            }
            stat.incrementUpdateCount();
            Map<String, String> aliasMap = aliasLocal.get();
            aliasMap.put(ident, ident);
        } else {
            this.accept(x.getTable());
        }
        this.accept(x.getSetClause());
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public void endVisit(OracleUpdateStatement x) {
        aliasLocal.set(null);
    }

    @Override
    public boolean visit(OracleDeleteStatement x) {
        return this.visit((SQLDeleteStatement)x);
    }

    @Override
    public void endVisit(OracleDeleteStatement x) {
        aliasLocal.set(null);
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        aliasLocal.set(new HashMap());
        x.putAttribute("_original_use_mode", (Object)modeLocal.get());
        modeLocal.set(TableStat.Mode.Delete);
        aliasLocal.set(new HashMap());
        String ident = ((SQLIdentifierExpr)x.getTableName()).getName();
        currentTableLocal.set(ident);
        TableStat stat = this.tableStats.get(ident);
        if (stat == null) {
            stat = new TableStat();
            this.tableStats.put(new TableStat.Name(ident), stat);
        }
        stat.incrementDeleteCount();
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public void endVisit(SQLDeleteStatement x) {
        aliasLocal.set(null);
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        aliasLocal.set(new HashMap());
        return true;
    }

    @Override
    public void endVisit(SQLSelectStatement x) {
        aliasLocal.set(null);
    }

    @Override
    public void endVisit(SQLInsertStatement x) {
        TableStat.Mode originalMode = (TableStat.Mode)((Object)x.getAttribute("_original_use_mode"));
        modeLocal.set(originalMode);
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        x.putAttribute("_original_use_mode", (Object)modeLocal.get());
        modeLocal.set(TableStat.Mode.Insert);
        aliasLocal.set(new HashMap());
        String originalTable = currentTableLocal.get();
        if (x.getTableName() instanceof SQLIdentifierExpr) {
            String ident = ((SQLIdentifierExpr)x.getTableName()).getName();
            currentTableLocal.set(ident);
            x.putAttribute("_old_local_", originalTable);
            TableStat stat = this.tableStats.get(ident);
            if (stat == null) {
                stat = new TableStat();
                this.tableStats.put(new TableStat.Name(ident), stat);
            }
            stat.incrementInsertCount();
            Map<String, String> aliasMap = aliasLocal.get();
            if (aliasMap != null) {
                if (x.getAlias() != null) {
                    aliasMap.put(x.getAlias(), ident);
                }
                aliasMap.put(ident, ident);
            }
        }
        this.accept(x.getColumns());
        this.accept(x.getValues());
        this.accept(x.getQuery());
        return false;
    }

    protected void accept(SQLObject x) {
        if (x != null) {
            x.accept(this);
        }
    }

    protected void accept(List<? extends SQLObject> nodes) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            this.accept(nodes.get(i));
        }
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        SQLExprTableSource tableSource;
        if (x.getFrom() instanceof SQLSubqueryTableSource) {
            x.getFrom().accept(this);
            return false;
        }
        x.putAttribute("_original_use_mode", (Object)modeLocal.get());
        modeLocal.set(TableStat.Mode.Select);
        String originalTable = currentTableLocal.get();
        if (x.getFrom() instanceof SQLExprTableSource && (tableSource = (SQLExprTableSource)x.getFrom()).getExpr() instanceof SQLName) {
            String ident = ((SQLName)tableSource.getExpr()).toString();
            currentTableLocal.set(ident);
            x.putAttribute("_old_local_", originalTable);
        }
        x.getFrom().accept(this);
        return true;
    }

    @Override
    public void endVisit(SQLSelectQueryBlock x) {
        String originalTable = (String)x.getAttribute("_old_local_");
        x.putAttribute("table", currentTableLocal.get());
        currentTableLocal.set(originalTable);
        TableStat.Mode originalMode = (TableStat.Mode)((Object)x.getAttribute("_original_use_mode"));
        modeLocal.set(originalMode);
    }

    public boolean visit(OracleSelectQueryBlock x) {
        return this.visit((SQLSelectQueryBlock)x);
    }

    public void endVisit(OracleSelectQueryBlock x) {
        this.endVisit((SQLSelectQueryBlock)x);
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        return true;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        String table;
        Map<String, String> aliasMap;
        String owner;
        if ("ROWNUM".equalsIgnoreCase(x.getName())) {
            return false;
        }
        if (x.getOwner() instanceof SQLIdentifierExpr && (owner = ((SQLIdentifierExpr)x.getOwner()).getName()) != null && (aliasMap = aliasLocal.get()) != null && (table = aliasMap.get(owner)) != null) {
            this.fields.add(new TableStat.Column(table, x.getName()));
        }
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        if ("ROWNUM".equalsIgnoreCase(x.getName())) {
            return false;
        }
        if ("SYSDATE".equalsIgnoreCase(x.getName())) {
            return false;
        }
        if ("+".equalsIgnoreCase(x.getName())) {
            return false;
        }
        String currentTable = currentTableLocal.get();
        if (currentTable != null) {
            this.fields.add(new TableStat.Column(currentTable, x.getName()));
        }
        return false;
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        String currentTable = currentTableLocal.get();
        if (currentTable != null) {
            this.fields.add(new TableStat.Column(currentTable, "*"));
        }
        return false;
    }

    public Map<TableStat.Name, TableStat> getTables() {
        return this.tableStats;
    }

    public boolean containsTable(String tableName) {
        return this.tableStats.containsKey(new TableStat.Name(tableName));
    }

    public Set<TableStat.Column> getFields() {
        return this.fields;
    }
}

