/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.parser;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePLSQLCommitStatement;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleDeleteParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleInsertParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerLexer;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class SQLServerStatementParser
extends SQLStatementParser {
    public SQLServerStatementParser(String sql) {
        super(new SQLServerLexer(sql));
        this.lexer.nextToken();
    }

    public SQLServerStatementParser(Lexer lexer) {
        super(lexer);
    }

    @Override
    public void parseStatementList(List<SQLStatement> statementList) throws ParserException {
        while (true) {
            if (this.lexer.token() == Token.EOF) {
                return;
            }
            if (this.lexer.token() == Token.SEMI) {
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token() == Token.SELECT) {
                statementList.add(new SQLSelectStatement(new SQLServerSelectParser(this.lexer).select()));
                continue;
            }
            if (this.lexer.token() == Token.UPDATE) {
                statementList.add(this.parseUpdateStatement());
                continue;
            }
            if (this.lexer.token() == Token.CREATE) {
                this.lexer.nextToken();
                throw new ParserException("TODO");
            }
            if (this.lexer.token() == Token.INSERT) {
                statementList.add(new OracleInsertParser(this.lexer).parseInsert());
                continue;
            }
            if (this.lexer.token() == Token.DELETE) {
                statementList.add(new OracleDeleteParser(this.lexer).parseDelete());
                continue;
            }
            if (this.lexer.token() == Token.SLASH) {
                this.lexer.nextToken();
                statementList.add(new OraclePLSQLCommitStatement());
                continue;
            }
            if (this.lexer.token() == Token.ALTER) {
                throw new ParserException("TODO");
            }
            if (this.lexer.token() == Token.WITH) {
                statementList.add(new SQLSelectStatement(new OracleSelectParser(this.lexer).select()));
                continue;
            }
            if (!this.identifierEquals("CALL")) break;
            statementList.add(this.parseCall());
        }
        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }
}

