/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.SQLParseException;
import com.alibaba.druid.sql.parser.SymbolTable;
import com.alibaba.druid.sql.parser.Token;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Lexer {
    protected final char[] buf;
    protected int bp;
    protected int buflen;
    protected int eofPos;
    protected char ch;
    protected int tokenPos;
    protected static final ThreadLocal<char[]> sbufRef = new ThreadLocal();
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected SymbolTable symbolTable = new SymbolTable();
    protected Token token;
    protected Keywords keywods = Keywords.DEFAULT_KEYWORDS;
    protected String stringVal;
    protected boolean skipComment = true;
    private SavePoint savePoint = null;
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    private static final int[] digits = new int[58];

    public Lexer(String input) {
        this(input, true);
    }

    public void mark() {
        SavePoint savePoint = new SavePoint();
        savePoint.bp = this.bp;
        savePoint.sp = this.sp;
        savePoint.np = this.np;
        savePoint.ch = this.ch;
        savePoint.token = this.token;
        this.savePoint = savePoint;
    }

    public void reset() {
        this.bp = this.savePoint.bp;
        this.sp = this.savePoint.sp;
        this.np = this.savePoint.np;
        this.ch = this.savePoint.ch;
        this.token = this.savePoint.token;
    }

    public Lexer(String input, boolean skipComment) {
        this(input.toCharArray(), input.length(), skipComment);
    }

    public Lexer(char[] input, int inputLength, boolean skipComment) {
        this.skipComment = skipComment;
        this.sbuf = sbufRef.get();
        if (this.sbuf == null) {
            this.sbuf = new char[1024];
            sbufRef.set(this.sbuf);
        }
        this.eofPos = inputLength;
        if (inputLength == input.length) {
            if (input.length > 0 && CharTypes.isWhitespace(input[input.length - 1])) {
                --inputLength;
            } else {
                char[] newInput = new char[inputLength + 1];
                System.arraycopy(input, 0, newInput, 0, input.length);
                input = newInput;
            }
        }
        this.buf = input;
        this.buflen = inputLength;
        this.buf[this.buflen] = 26;
        this.bp = -1;
        this.scanChar();
    }

    protected final void scanChar() {
        this.ch = this.buf[++this.bp];
    }

    protected void lexError(int pos, String key, Object ... args) {
        this.token = Token.ERROR;
    }

    private void lexError(String key, Object ... args) {
        this.lexError(this.tokenPos, key, args);
    }

    public final Token token() {
        return this.token;
    }

    public final void nextToken() {
        this.sp = 0;
        block21: while (true) {
            this.tokenPos = this.bp;
            if (CharTypes.isWhitespace(this.ch)) {
                this.scanChar();
                continue;
            }
            if (CharTypes.isFirstIdentifierChar(this.ch)) {
                if (this.ch == 'N' && this.buf[this.bp + 1] == '\'') {
                    ++this.bp;
                    this.ch = (char)39;
                    this.scanString();
                    this.token = Token.LITERAL_NCHARS;
                    return;
                }
                this.scanIdentifier();
                return;
            }
            switch (this.ch) {
                case '0': {
                    if (this.buf[this.bp + 1] == 'x') {
                        this.scanChar();
                        this.scanChar();
                        this.scanHexaDecimal();
                    } else {
                        this.scanNumber();
                    }
                    return;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.scanNumber();
                    return;
                }
                case ',': {
                    this.scanChar();
                    this.token = Token.COMMA;
                    return;
                }
                case '(': {
                    this.scanChar();
                    this.token = Token.LPAREN;
                    return;
                }
                case ')': {
                    this.scanChar();
                    this.token = Token.RPAREN;
                    return;
                }
                case '[': {
                    this.scanChar();
                    this.token = Token.LBRACKET;
                    return;
                }
                case ']': {
                    this.scanChar();
                    this.token = Token.RBRACKET;
                    return;
                }
                case '{': {
                    this.scanChar();
                    this.token = Token.LBRACE;
                    return;
                }
                case '}': {
                    this.scanChar();
                    this.token = Token.RBRACE;
                    return;
                }
                case ':': {
                    this.scanChar();
                    if (this.ch == '=') {
                        this.scanChar();
                        this.token = Token.COLONEQ;
                    } else {
                        this.token = Token.COLON;
                    }
                    return;
                }
                case '.': {
                    this.scanChar();
                    this.token = Token.DOT;
                    return;
                }
                case '\'': {
                    this.scanString();
                    return;
                }
                case '\"': {
                    this.scanAlias();
                    return;
                }
                case '*': {
                    this.scanChar();
                    this.token = Token.STAR;
                    return;
                }
                case '?': {
                    this.scanChar();
                    this.token = Token.QUES;
                    return;
                }
                case ';': {
                    this.scanChar();
                    this.token = Token.SEMI;
                    return;
                }
                case '`': {
                    throw new SQLParseException("TODO");
                }
                case '@': {
                    this.scanVariable();
                    return;
                }
                case '/': {
                    char nextChar = this.buf[this.bp + 1];
                    if (nextChar == '/' || nextChar == '*') {
                        this.scanComment();
                        if ((this.token() == Token.LINE_COMMENT || this.token() == Token.MULTI_LINE_COMMENT) && this.skipComment) {
                            continue block21;
                        }
                    } else {
                        this.token = Token.SLASH;
                        this.scanChar();
                    }
                    return;
                }
            }
            break;
        }
        if (Character.isLetter(this.ch)) {
            this.scanIdentifier();
            return;
        }
        if (this.isOperator(this.ch)) {
            this.scanOperator();
            return;
        }
        if (this.bp == this.buflen || this.ch == '\u001a' && this.bp + 1 == this.buflen) {
            this.token = Token.EOF;
            this.tokenPos = this.bp = this.eofPos;
        } else {
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.scanChar();
        }
    }

    private final void scanOperator() {
        switch (this.ch) {
            case '+': {
                this.scanChar();
                this.token = Token.PLUS;
                break;
            }
            case '-': {
                this.scanChar();
                this.token = Token.SUB;
                break;
            }
            case '*': {
                this.scanChar();
                this.token = Token.STAR;
                break;
            }
            case '/': {
                this.scanChar();
                this.token = Token.SLASH;
                break;
            }
            case '&': {
                this.scanChar();
                if (this.ch == '&') {
                    this.scanChar();
                    this.token = Token.AMPAMP;
                    break;
                }
                this.token = Token.AMP;
                break;
            }
            case '|': {
                this.scanChar();
                if (this.ch == '|') {
                    this.scanChar();
                    this.token = Token.BARBAR;
                    break;
                }
                this.token = Token.BAR;
                break;
            }
            case '^': {
                this.scanChar();
                this.token = Token.CARET;
                break;
            }
            case '%': {
                this.scanChar();
                this.token = Token.PERCENT;
                break;
            }
            case '=': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.EQEQ;
                    break;
                }
                this.token = Token.EQ;
                break;
            }
            case '>': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.GTEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.GTGT;
                    break;
                }
                this.token = Token.GT;
                break;
            }
            case '<': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    if (this.ch == '>') {
                        this.token = Token.LTEQGT;
                        this.scanChar();
                        break;
                    }
                    this.token = Token.LTEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.LTGT;
                    break;
                }
                if (this.ch == '<') {
                    this.scanChar();
                    this.token = Token.LTLT;
                    break;
                }
                this.token = Token.LT;
                break;
            }
            case '!': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.BANGEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.BANGGT;
                    break;
                }
                if (this.ch == '<') {
                    this.scanChar();
                    this.token = Token.BANGLT;
                    break;
                }
                this.token = Token.BANG;
                break;
            }
            case '?': {
                this.scanChar();
                this.token = Token.QUES;
                break;
            }
            case '~': {
                this.scanChar();
                this.token = Token.TILDE;
                break;
            }
            default: {
                throw new SQLParseException("TODO");
            }
        }
    }

    protected void scanString() {
        this.np = this.bp;
        boolean hasSpecial = false;
        while (true) {
            if (this.bp >= this.buflen) {
                this.lexError(this.tokenPos, "unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.buf[++this.bp];
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                hasSpecial = true;
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.sbuf[this.sp++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? new String(this.buf, this.np + 1, this.sp) : new String(this.sbuf, 0, this.sp);
    }

    private final void scanAlias() {
        this.np = this.bp;
        while (true) {
            if (this.bp >= this.buflen) {
                this.lexError(this.tokenPos, "unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.buf[++this.bp];
            if (this.ch == '\"') break;
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.sbuf[this.sp++] = this.ch;
        }
        this.scanChar();
        this.token = Token.LITERAL_ALIAS;
        this.stringVal = new String(this.buf, this.np + 1, this.sp);
    }

    public void scanVariable() {
        char ch;
        int first = this.ch;
        if (this.ch != '@' && this.ch != ':') {
            throw new SQLParseException("illegal variable");
        }
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        if (this.buf[this.bp + 1] == '@') {
            ch = this.buf[++this.bp];
            hash = 31 * hash + ch;
            ++this.sp;
        }
        while (CharTypes.isIdentifierChar(ch = this.buf[++this.bp])) {
            hash = 31 * hash + ch;
            ++this.sp;
        }
        this.ch = this.buf[this.bp];
        this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
        this.token = Token.VARIANT;
    }

    public void scanComment() {
        if (this.ch != '/') {
            throw new IllegalStateException();
        }
        this.np = this.bp;
        this.sp = 0;
        this.scanChar();
        ++this.sp;
        if (this.ch == '*') {
            this.scanChar();
            ++this.sp;
            while (true) {
                if (this.ch == '*' && this.buf[this.bp + 1] == '/') {
                    this.sp += 2;
                    break;
                }
                this.scanChar();
                ++this.sp;
            }
            this.scanChar();
            this.scanChar();
            this.stringVal = new String(this.buf, this.np, this.sp);
            this.token = Token.MULTI_LINE_COMMENT;
            return;
        }
        if (this.ch == '/') {
            this.scanChar();
            ++this.sp;
            while (true) {
                if (this.ch == '\r') {
                    if (this.buf[this.bp + 1] == '\n') {
                        this.sp += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.sp;
                    break;
                }
                if (this.ch == '\r') {
                    this.scanChar();
                    ++this.sp;
                    break;
                }
                this.scanChar();
                ++this.sp;
            }
            this.stringVal = new String(this.buf, this.np + 1, this.sp);
            this.token = Token.LINE_COMMENT;
            return;
        }
    }

    public void scanIdentifier() {
        char ch;
        int first = this.ch;
        boolean firstFlag = CharTypes.isFirstIdentifierChar((char)first);
        if (!firstFlag) {
            throw new SQLParseException("illegal identifier");
        }
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        while (CharTypes.isIdentifierChar(ch = this.buf[++this.bp])) {
            hash = 31 * hash + ch;
            ++this.sp;
        }
        this.ch = this.buf[this.bp];
        this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
        Token tok = this.keywods.getKeyword(this.stringVal);
        this.token = tok != null ? tok : Token.IDENTIFIER;
    }

    public void scanNumber() {
        this.np = this.bp++;
        if (this.ch == '-') {
            ++this.sp;
            this.ch = this.buf[this.bp];
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            isDouble = true;
        }
        this.token = isDouble ? Token.LITERAL_FLOAT : Token.LITERAL_INT;
    }

    public void scanHexaDecimal() {
        this.np = this.bp++;
        if (this.ch == '-') {
            ++this.sp;
            this.ch = this.buf[this.bp];
        }
        while (CharTypes.isHex(this.ch)) {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        }
        this.token = Token.LITERAL_HEX;
    }

    public String hexString() throws NumberFormatException {
        return new String(this.buf, this.np, this.sp);
    }

    public final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    protected final void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[this.sp++] = ch;
    }

    public final int pos() {
        return this.tokenPos;
    }

    public final String stringVal() {
        return this.stringVal;
    }

    private boolean isOperator(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public Number integerValue() throws NumberFormatException {
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.buf[this.np] == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.buf[i++]];
            result = -digit;
        }
        while (i < max) {
            digit = digits[this.buf[i++]];
            if (result < multmin) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                if (result >= Integer.MIN_VALUE) {
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE) {
            return (int)result;
        }
        return result;
    }

    public final String numberString() {
        return new String(this.buf, this.np, this.sp);
    }

    public BigDecimal decimalValue() {
        return new BigDecimal(this.buf, this.np, this.sp);
    }

    static {
        for (int i = 48; i <= 57; ++i) {
            Lexer.digits[i] = i - 48;
        }
    }

    private static class SavePoint {
        int bp;
        int sp;
        int np;
        char ch;
        Token token;

        private SavePoint() {
        }
    }
}

