/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParseException;
import com.alibaba.druid.sql.parser.Token;

public class SQLParser {
    protected final Lexer lexer;
    private int errorEndPos = -1;

    public SQLParser(String sql) {
        this(new Lexer(sql));
        this.lexer.nextToken();
    }

    public SQLParser(Lexer lexer) {
        this.lexer = lexer;
    }

    protected boolean identifierEquals(String text) {
        return this.lexer.token() == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase(text);
    }

    protected void acceptIdentifier(String text) {
        if (!this.identifierEquals(text)) {
            this.setErrorEndPos(this.lexer.pos());
            throw new SQLParseException("syntax error, expect " + text + ", actual " + (Object)((Object)this.lexer.token()));
        }
        this.lexer.nextToken();
    }

    protected String as() throws ParserException {
        String alias = null;
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LITERAL_ALIAS) {
                alias = '\"' + this.lexer.stringVal() + '\"';
                this.lexer.nextToken();
                return alias;
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                alias = this.lexer.stringVal();
                this.lexer.nextToken();
                return alias;
            }
            if (this.lexer.token() == Token.LITERAL_CHARS) {
                alias = "'" + this.lexer.stringVal() + "'";
                this.lexer.nextToken();
                return alias;
            }
            if (this.lexer.token() == Token.YEAR || this.lexer.token() == Token.DAY) {
                alias = this.lexer.token.name();
                this.lexer.nextToken();
                return alias;
            }
            switch (this.lexer.token()) {
                case KEY: {
                    alias = this.lexer.token().name();
                    this.lexer.nextToken();
                    return alias;
                }
            }
            throw new ParserException("Error : " + (Object)((Object)this.lexer.token()));
        }
        if (this.lexer.token() == Token.LITERAL_ALIAS) {
            alias = '\"' + this.lexer.stringVal() + '\"';
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            alias = this.lexer.stringVal();
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.LITERAL_CHARS) {
            alias = "'" + this.lexer.stringVal() + "'";
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.YEAR || this.lexer.token() == Token.DAY) {
            alias = this.lexer.token.name();
            this.lexer.nextToken();
        }
        switch (this.lexer.token()) {
            case KEY: {
                alias = this.lexer.token().name();
                this.lexer.nextToken();
                return alias;
            }
        }
        return alias;
    }

    public void accept(Token token) {
        if (this.lexer.token() != token) {
            this.setErrorEndPos(this.lexer.pos());
            throw new SQLParseException("syntax error, expect " + (Object)((Object)token) + ", actual " + (Object)((Object)this.lexer.token()));
        }
        this.lexer.nextToken();
    }

    protected void setErrorEndPos(int errPos) {
        if (errPos > this.errorEndPos) {
            this.errorEndPos = errPos;
        }
    }
}

