/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParseException;
import com.alibaba.druid.sql.parser.SQLParser;
import com.alibaba.druid.sql.parser.Token;

public class SQLSelectParser
extends SQLParser {
    public SQLSelectParser(String sql) {
        super(sql);
    }

    public SQLSelectParser(Lexer lexer) {
        super(lexer);
    }

    public SQLSelect select() throws ParserException {
        SQLSelect select = new SQLSelect();
        select.setQuery(this.query());
        select.setOrderBy(this.parseOrderBy());
        if (select.getOrderBy() == null) {
            select.setOrderBy(this.parseOrderBy());
        }
        return select;
    }

    public SQLSelectQuery queryRest(SQLSelectQuery selectQuery) throws ParserException {
        if (this.lexer.token() == Token.UNION) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            if (this.lexer.token() == Token.ALL) {
                union.setOperator(SQLUnionOperator.UNION_ALL);
                this.lexer.nextToken();
            }
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return union;
        }
        if (this.lexer.token() == Token.INTERSECT) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.INTERSECT);
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return union;
        }
        if (this.lexer.token() == Token.MINUS) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.MINUS);
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return union;
        }
        return selectQuery;
    }

    protected SQLSelectQuery query() throws ParserException {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select);
        }
        this.accept(Token.SELECT);
        SQLSelectQueryBlock queryBlock = new SQLSelectQueryBlock();
        if (this.lexer.token() == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.UNIQUE) {
            queryBlock.setDistionOption(3);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.ALL) {
            queryBlock.setDistionOption(1);
            this.lexer.nextToken();
        }
        this.parseSelectList(queryBlock);
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        return this.queryRest(queryBlock);
    }

    protected void parseWhere(SQLSelectQueryBlock queryBlock) throws ParserException {
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            queryBlock.setWhere(this.expr());
        }
    }

    protected void parseGroupBy(SQLSelectQueryBlock queryBlock) throws ParserException {
        if (this.lexer.token() == Token.GROUP) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            while (true) {
                groupBy.getItems().add(this.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.HAVING) {
                this.lexer.nextToken();
                groupBy.setHaving(this.expr());
            }
            queryBlock.setGroupBy(groupBy);
        }
    }

    protected void parseSelectList(SQLSelectQueryBlock queryBlock) throws ParserException {
        queryBlock.getSelectList().add(new SQLSelectItem(this.expr(), this.as()));
        while (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            queryBlock.getSelectList().add(new SQLSelectItem(this.expr(), this.as()));
        }
    }

    public void parseFrom(SQLSelectQueryBlock queryBlock) throws ParserException {
        if (this.lexer.token() != Token.FROM) {
            return;
        }
        this.lexer.nextToken();
        queryBlock.setFrom(this.parseTableSource());
    }

    public SQLTableSource parseTableSource() throws ParserException {
        if (this.lexer.token() == Token.LPAREN) {
            SQLTableSource tableSource;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                SQLSelect select = this.select();
                this.accept(Token.RPAREN);
                this.queryRest(select.getQuery());
                tableSource = new SQLSubqueryTableSource(select);
            } else if (this.lexer.token() == Token.LPAREN) {
                tableSource = this.parseTableSource();
                this.accept(Token.RPAREN);
            } else {
                throw new ParserException("TODO");
            }
            return this.parseTableSourceRest(tableSource);
        }
        if (this.lexer.token() == Token.SELECT) {
            throw new ParserException("TODO");
        }
        SQLExprTableSource tableReference = new SQLExprTableSource();
        this.parseTableSourceQueryTableExpr(tableReference);
        return this.parseTableSourceRest(tableReference);
    }

    private void parseTableSourceQueryTableExpr(SQLExprTableSource tableReference) throws ParserException {
        tableReference.setExpr(this.expr());
    }

    private SQLTableSource parseTableSourceRest(SQLTableSource tableSource) throws ParserException {
        if ((tableSource.getAlias() == null || tableSource.getAlias().length() == 0) && this.lexer.token() != Token.LEFT && this.lexer.token() != Token.RIGHT && this.lexer.token() != Token.FULL) {
            tableSource.setAlias(this.as());
        }
        SQLJoinTableSource.JoinType joinType = null;
        if (this.lexer.token() == Token.LEFT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN;
        } else if (this.lexer.token() == Token.RIGHT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN;
        } else if (this.lexer.token() == Token.FULL) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.FULL_OUTER_JOIN;
        } else if (this.lexer.token() == Token.INNER) {
            this.lexer.nextToken();
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.INNER_JOIN;
        } else if (this.lexer.token() == Token.JOIN) {
            this.lexer.nextToken();
            joinType = SQLJoinTableSource.JoinType.JOIN;
        } else if (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            joinType = SQLJoinTableSource.JoinType.COMMA;
        }
        if (joinType != null) {
            SQLJoinTableSource join = new SQLJoinTableSource();
            join.setLeft(tableSource);
            join.setJoinType(joinType);
            join.setRight(this.parseTableSource());
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                join.setCondition(this.expr());
            }
            return this.parseTableSourceRest(join);
        }
        if (this.lexer.token() == Token.UNION) {
            throw new SQLParseException("TODO");
        }
        return tableSource;
    }

    public SQLExpr expr() {
        return this.createExprParser().expr();
    }

    protected SQLExprParser createExprParser() {
        return new SQLExprParser(this.lexer);
    }

    public SQLOrderBy parseOrderBy() throws ParserException {
        return this.createExprParser().parseOrderBy();
    }

    public void acceptKeyword(String ident) {
        if (this.lexer.token() != Token.IDENTIFIER || !ident.equalsIgnoreCase(this.lexer.stringVal())) {
            this.setErrorEndPos(this.lexer.pos());
            throw new SQLParseException("syntax error, expect " + ident + ", actual " + (Object)((Object)this.lexer.token()));
        }
        this.lexer.nextToken();
    }
}

