/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.ArrayList;
import java.util.List;

public class SQLStatementParser
extends SQLParser {
    protected final SQLExprParser exprParser = this.createExprParser();

    public SQLStatementParser(String sql) {
        super(sql);
    }

    public SQLStatementParser(Lexer lexer) {
        super(lexer);
    }

    protected SQLExprParser createExprParser() {
        return new SQLExprParser(this.lexer);
    }

    public List<SQLStatement> parseStatementList() throws ParserException {
        ArrayList<SQLStatement> statementList = new ArrayList<SQLStatement>();
        this.parseStatementList(statementList);
        return statementList;
    }

    public void parseStatementList(List<SQLStatement> statementList) throws ParserException {
        while (true) {
            if (this.lexer.token() == Token.EOF) {
                return;
            }
            if (this.lexer.token() == Token.SEMI) {
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token() == Token.SELECT) {
                statementList.add(this.parseSelect());
                continue;
            }
            if (this.lexer.token() == Token.UPDATE) {
                statementList.add(this.parseUpdateStatement());
                continue;
            }
            if (this.lexer.token() == Token.CREATE) {
                statementList.add(this.parseCreate());
                continue;
            }
            if (this.lexer.token() == Token.INSERT) {
                SQLStatement insertStatement = this.parseInsert();
                statementList.add(insertStatement);
                continue;
            }
            if (this.lexer.token() == Token.DELETE) {
                statementList.add(this.parseDeleteStatement());
                continue;
            }
            if (this.lexer.token() == Token.SET) {
                statementList.add(this.parseSet());
                continue;
            }
            if (this.lexer.token() == Token.ALTER) {
                throw new ParserException("TODO");
            }
            if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TABLE) {
                    this.lexer.nextToken();
                    SQLName name = this.exprParser.name();
                    statementList.add(new SQLDropTableStatement(name));
                    continue;
                }
            }
            if (this.identifierEquals("CALL")) {
                SQLCallStatement stmt = this.parseCall();
                statementList.add(stmt);
                continue;
            }
            if (!this.parseStatementListDialect(statementList)) break;
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseInsert() {
        this.accept(Token.INSERT);
        this.accept(Token.INTO);
        SQLInsertStatement insertStatement = new SQLInsertStatement();
        SQLName tableName = this.exprParser.name();
        insertStatement.setTableName(tableName);
        if (this.lexer.token() == Token.IDENTIFIER) {
            insertStatement.setAlias(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(insertStatement.getColumns());
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
            this.exprParser.exprList(values.getValues());
            insertStatement.setValues(values);
            this.accept(Token.RPAREN);
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.createExprParser().expr();
            insertStatement.setQuery(queryExpr.getSubQuery());
        }
        return insertStatement;
    }

    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        return false;
    }

    public SQLCallStatement parseCall() throws ParserException {
        this.acceptIdentifier("CALL");
        SQLCallStatement stmt = new SQLCallStatement();
        stmt.setProcedureName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters());
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    public SQLSetStatement parseSet() throws ParserException {
        this.accept(Token.SET);
        SQLSetStatement stmt = new SQLSetStatement();
        while (true) {
            SQLSetStatement.Item item = new SQLSetStatement.Item();
            item.setTarget(this.exprParser.primary());
            this.accept(Token.EQ);
            item.setValue(this.exprParser.expr());
            stmt.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    public SQLStatement parseCreate() throws ParserException {
        this.accept(Token.CREATE);
        Token token = this.lexer.token();
        if (token == Token.TABLE) {
            SQLCreateTableParser createTableParser = this.getSQLCreateTableParser();
            return createTableParser.parseCrateTable(false);
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLCreateTableParser getSQLCreateTableParser() {
        return new SQLCreateTableParser(this.lexer);
    }

    public SQLSelectStatement parseSelect() throws ParserException {
        return new SQLSelectStatement(this.createSQLSelectParser().select());
    }

    public SQLSelectParser createSQLSelectParser() {
        return new SQLSelectParser(this.lexer);
    }

    public SQLUpdateStatement parseUpdateStatement() throws ParserException {
        this.accept(Token.UPDATE);
        SQLUpdateStatement udpateStatement = new SQLUpdateStatement();
        SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
        udpateStatement.setTableSource(tableSource);
        this.accept(Token.SET);
        while (true) {
            SQLUpdateSetItem item = new SQLUpdateSetItem();
            item.setColumn(this.exprParser.name());
            this.accept(Token.EQ);
            item.setValue(this.exprParser.expr());
            udpateStatement.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            udpateStatement.setWhere(this.exprParser.expr());
        }
        return udpateStatement;
    }

    public SQLDeleteStatement parseDeleteStatement() throws ParserException {
        this.lexer.nextToken();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
        }
        SQLName tableName = this.exprParser.name();
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement();
        deleteStatement.setTableName(tableName);
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        return deleteStatement;
    }

    public SQLCreateTableStatement parseCreateTable() throws ParserException {
        throw new ParserException("TODO");
    }

    public SQLCreateViewStatement parseCreateView() throws ParserException {
        SQLCreateViewStatement createView = new SQLCreateViewStatement();
        this.accept(Token.CREATE);
        this.accept(Token.VIEW);
        createView.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(createView.getColumns());
            this.accept(Token.RPAREN);
        }
        this.accept(Token.AS);
        createView.setSubQuery(new SQLSelectParser(this.lexer).select());
        return createView;
    }
}

