/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllExpr;
import com.alibaba.druid.sql.ast.expr.SQLAnyExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLObjectCreateExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLSomeExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.NotNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import java.io.IOException;
import java.util.List;

public class SQLASTOutputVisitor
extends SQLASTVisitorAdapter {
    protected Appendable appender;
    private String indent = "\t";
    private int indentCount = 0;

    public SQLASTOutputVisitor(Appendable appender) {
        this.appender = appender;
    }

    public void decrementIndent() {
        --this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void print(char value) {
        try {
            this.appender.append(value);
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    public void print(int value) {
        this.print(Integer.toString(value));
    }

    public void print(long value) {
        this.print(Long.toString(value));
    }

    public void print(String text) {
        try {
            this.appender.append(text);
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    protected void printAlias(String alias) {
        if (alias != null && alias.length() > 0) {
            this.print(" ");
            this.print(alias);
        }
    }

    protected void printAndAccept(List<? extends SQLObject> nodes, String seperator) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(seperator);
            }
            nodes.get(i).accept(this);
        }
    }

    protected void printSelectList(List<SQLSelectItem> selectList) {
        this.incrementIndent();
        int size = selectList.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                if (i % 5 == 0) {
                    this.println();
                }
                this.print(", ");
            }
            selectList.get(i).accept(this);
        }
        this.decrementIndent();
    }

    protected void printlnAndAccept(List<? extends SQLObject> nodes, String seperator) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println(seperator);
            }
            nodes.get(i).accept(this);
        }
    }

    public void printIndent() {
        for (int i = 0; i < this.indentCount; ++i) {
            this.print(this.indent);
        }
    }

    public void println() {
        this.print("\n");
        this.printIndent();
    }

    public void println(String text) {
        this.print(text);
        this.println();
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        x.getTestExpr().accept(this);
        if (x.isNot()) {
            this.print(" NOT BETWEEN ");
        } else {
            this.print(" BETWEEN ");
        }
        x.getBeginExpr().accept(this);
        this.print(" AND ");
        x.getEndExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        if (x.getLeft() instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr left = (SQLBinaryOpExpr)x.getLeft();
            if (left.getOperator().priority > x.getOperator().priority) {
                this.print('(');
                left.accept(this);
                this.print(')');
            } else {
                left.accept(this);
            }
        } else {
            x.getLeft().accept(this);
        }
        this.print(" ");
        this.print(x.getOperator().name);
        this.print(" ");
        if (x.getRight() instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr right = (SQLBinaryOpExpr)x.getRight();
            if (right.getOperator().priority >= x.getOperator().priority) {
                this.print('(');
                right.accept(this);
                this.print(')');
            } else {
                right.accept(this);
            }
        } else {
            x.getRight().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCaseExpr x) {
        this.print("CASE ");
        if (x.getValueExpr() != null) {
            x.getValueExpr().accept(this);
            this.print(" ");
        }
        this.printAndAccept(x.getItems(), " ");
        if (x.getElseExpr() != null) {
            this.print(" ELSE ");
            x.getElseExpr().accept(this);
        }
        this.print(" END");
        return false;
    }

    @Override
    public boolean visit(SQLCaseExpr.Item x) {
        this.print("WHEN ");
        x.getConditionExpr().accept(this);
        this.print(" THEN ");
        x.getValueExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCastExpr x) {
        this.print("CAST(");
        x.getExpr().accept(this);
        this.print(" AS ");
        x.getDataType().accept(this);
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        if (x.getText() == null || x.getText().length() == 0) {
            this.print("NULL");
        } else {
            this.print("'");
            this.print(x.getText().replaceAll("'", "''"));
            this.print("'");
        }
        return false;
    }

    @Override
    public boolean visit(SQLDataType x) {
        this.print(x.getName());
        if (x.getArguments().size() > 0) {
            this.print("(");
            this.printAndAccept(x.getArguments(), ", ");
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(SQLExistsExpr x) {
        if (x.isNot()) {
            this.print("NOT EXISTS (");
        } else {
            this.print("EXISTS (");
        }
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr astNode) {
        this.print(astNode.getName());
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        x.getExpr().accept(this);
        if (x.isNot()) {
            this.print(" NOT IN (");
        } else {
            this.print(" IN (");
        }
        this.printAndAccept(x.getTargetList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        this.print(x.getNumber().toString());
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if (x.getOwner() != null) {
            x.getOwner().accept(this);
            this.print(".");
        }
        this.print(x.getMethodName());
        this.print("(");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        x.getMethodName().accept(this);
        this.print("(");
        this.printAndAccept(x.getArguments(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        this.print("*");
        return true;
    }

    @Override
    public boolean visit(SQLNCharExpr x) {
        if (x.getText() == null || x.getText().length() == 0) {
            this.print("NULL");
        } else {
            this.print("N'");
            this.print(x.getText().replace("'", "''"));
            this.print("'");
        }
        return false;
    }

    @Override
    public boolean visit(SQLNotExpr x) {
        this.print("NOT ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLNullExpr x) {
        this.print("NULL");
        return false;
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        this.print(x.getNumber().toString());
        return false;
    }

    public boolean visit(SQLObjectCreateExpr x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        x.getOwner().accept(this);
        this.print(".");
        this.print(x.getName());
        return false;
    }

    @Override
    public boolean visit(SQLQueryExpr x) {
        if (x.getParent() instanceof SQLStatement) {
            this.incrementIndent();
            this.println();
            x.getSubQuery().accept(this);
            this.decrementIndent();
        } else {
            this.print("(");
            this.incrementIndent();
            this.println();
            x.getSubQuery().accept(this);
            this.println();
            this.decrementIndent();
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        if (x.getItems().size() > 0) {
            this.print("GROUP BY ");
            this.printAndAccept(x.getItems(), ", ");
        }
        if (x.getHaving() != null) {
            this.println();
            this.print("HAVING ");
            x.getHaving().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        x.getQuery().accept(this);
        if (x.getOrderBy() != null) {
            this.print(" ");
            x.getOrderBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock select) {
        this.print("SELECT ");
        if (1 == select.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == select.getDistionOption()) {
            this.print("DISTINCT ");
        } else if (3 == select.getDistionOption()) {
            this.print("UNIQUE ");
        }
        this.printSelectList(select.getSelectList());
        if (select.getFrom() != null) {
            this.println();
            this.print("FROM ");
            select.getFrom().accept(this);
        }
        if (select.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            select.getWhere().accept(this);
        }
        if (select.getGroupBy() != null) {
            this.print(" ");
            select.getGroupBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null && x.getAlias().length() > 0) {
            this.print(" AS ");
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        if (x.getItems().size() > 0) {
            this.print("ORDER BY ");
            this.printAndAccept(x.getItems(), ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectOrderByItem x) {
        x.getExpr().accept(this);
        if (x.getType() != null) {
            this.print(" ");
            this.print(x.getType().name().toUpperCase());
        }
        if (x.getCollate() != null) {
            this.print(" COLLATE ");
            this.print(x.getCollate());
        }
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null) {
            this.print(' ');
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectStatement stmt) {
        SQLSelect select = stmt.getSelect();
        select.accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        this.print(x.getName());
        return false;
    }

    @Override
    public boolean visit(SQLDropTableStatement x) {
        this.print("DROP TABLE ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLTableElement x) {
        if (x instanceof SQLColumnDefinition) {
            return this.visit((SQLColumnDefinition)x);
        }
        throw new RuntimeException("TODO");
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        x.getName().accept(this);
        this.print(' ');
        x.getDataType().accept(this);
        if (x.getDefaultExpr() != null) {
            this.print(" DEFAULT ");
            x.getDefaultExpr().accept(this);
        }
        for (SQLColumnConstraint item : x.getConstaints()) {
            this.print(' ');
            item.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        this.print("DELETE FROM ");
        x.getTableName().accept(this);
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCurrentOfCursorExpr x) {
        this.print("CURRENT OF ");
        x.getCursorName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        this.print("INSERT INTO ");
        x.getTableName().accept(this);
        if (x.getColumns().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print("(");
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
            this.decrementIndent();
        }
        if (x.getValues() != null) {
            this.println();
            this.print("VALUES ");
            x.getValues().accept(this);
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLUpdateSetItem x) {
        x.getColumn().accept(this);
        this.print(" = ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        this.print("UPDATE ");
        x.getTableSource().accept(this);
        this.print(" SET ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        this.print("CREATE TABLE ");
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)x.getType())) {
            this.print("GLOBAL TEMPORARY ");
        } else if (SQLCreateTableStatement.Type.LOCAL_TEMPORARY.equals((Object)x.getType())) {
            this.print("LOCAL TEMPORARY ");
        }
        x.getName().accept(this);
        this.print(" (");
        int size = x.getTableElementList().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getTableElementList().get(i).accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLUniqueConstraint x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print("UNIQUE (");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(NotNullConstraint x) {
        this.print("NOT NULL");
        return false;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        x.getLeft().accept(this);
        this.println();
        this.print(x.getOperator().name);
        this.println();
        x.getRight().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLUnaryExpr x) {
        this.print(x.getOperator().name);
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLBinaryOpExpr) {
            this.print('(');
            expr.accept(this);
            this.print(')');
        } else if (expr instanceof SQLUnaryExpr) {
            this.print('(');
            expr.accept(this);
            this.print(')');
        } else {
            expr.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLHexExpr x) {
        this.print("0x");
        this.print(x.getHex());
        String charset = (String)x.getAttribute("USING");
        if (charset != null) {
            this.print(" USING ");
            this.print(charset);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSetStatement x) {
        this.print("SET ");
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLSetStatement.Item x) {
        x.getTarget().accept(this);
        this.print(" = ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCallStatement x) {
        this.print("CALL ");
        x.getProcedureName().accept(this);
        this.print('(');
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        x.getLeft().accept(this);
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print(",");
        } else {
            this.print(" ");
            this.print(SQLJoinTableSource.JoinType.toString(x.getJoinType()));
        }
        this.print(" ");
        x.getRight().accept(this);
        if (x.getCondition() != null) {
            this.print(" ON ");
            x.getCondition().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement.ValuesClause x) {
        this.print("(");
        this.incrementIndent();
        int size = x.getValues().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                if (i % 5 == 0) {
                    this.println();
                }
                this.print(", ");
            }
            x.getValues().get(i).accept(this);
        }
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLSomeExpr x) {
        this.print("SOME (");
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAnyExpr x) {
        this.print("ANY (");
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLAllExpr x) {
        this.print("ALL (");
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLInSubQueryExpr x) {
        x.getExpr().accept(this);
        if (x.isNot()) {
            this.print(" NOT IN (");
        } else {
            this.print(" IN (");
        }
        this.incrementIndent();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLListExpr x) {
        this.print("(");
        this.printAndAccept(x.getItems(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.print("(");
        this.incrementIndent();
        x.getSelect().accept(this);
        this.println();
        this.decrementIndent();
        this.print(")");
        if (x.getAlias() != null) {
            this.print(' ');
            this.print(x.getAlias());
        }
        return false;
    }
}

