/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.stat.DruidDataSourceStatManagerMBean;
import com.alibaba.druid.util.ConcurrentIdentityHashMap;
import com.alibaba.druid.util.JMXUtils;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DruidDataSourceStatManager
implements DruidDataSourceStatManagerMBean {
    private static final Log LOG = LogFactory.getLog(DruidDataSourceStatManager.class);
    private static final DruidDataSourceStatManager instance = new DruidDataSourceStatManager();
    private final AtomicLong resetCount = new AtomicLong();
    private static final ConcurrentIdentityHashMap<DruidDataSource, ObjectName> dataSources = new ConcurrentIdentityHashMap();
    private static final String MBEAN_NAME = "com.alibaba.druid:type=DruidDataSourceStat";
    private static CompositeType COMPOSITE_TYPE = null;

    public static DruidDataSourceStatManager getInstance() {
        return instance;
    }

    public static synchronized void add(DruidDataSource dataSource) {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        if (dataSources.size() == 0) {
            try {
                mbeanServer.registerMBean(instance, new ObjectName(MBEAN_NAME));
            }
            catch (JMException ex) {
                LOG.error((Object)"register mbean error", (Throwable)ex);
            }
        }
        ObjectName objectName = null;
        if (dataSource.getNameInternal() != null) {
            try {
                objectName = new ObjectName("com.alibaba.druid:type=DruidDataSource,id=" + dataSource.getNameInternal());
                mbeanServer.registerMBean(dataSource, objectName);
            }
            catch (JMException ex) {
                LOG.error((Object)"register mbean error", (Throwable)ex);
                objectName = null;
            }
        }
        if (objectName == null) {
            try {
                int id = System.identityHashCode(dataSource);
                objectName = new ObjectName("com.alibaba.druid:type=DruidDataSource,id=" + id);
                mbeanServer.registerMBean(dataSource, objectName);
            }
            catch (JMException ex) {
                LOG.error((Object)"register mbean error", (Throwable)ex);
                objectName = null;
            }
        }
        dataSources.put(dataSource, objectName);
        dataSource.setObjectName(objectName);
    }

    public static synchronized void remove(DruidDataSource dataSource) {
        ObjectName objectName = dataSources.remove(dataSource);
        if (objectName == null) {
            objectName = dataSource.getObjectName();
        }
        if (objectName == null) {
            LOG.error((Object)("unregister mbean failed. url " + dataSource.getUrl()));
            return;
        }
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        if (objectName != null) {
            try {
                mbeanServer.unregisterMBean(objectName);
            }
            catch (JMException ex) {
                LOG.error((Object)"unregister mbean error", (Throwable)ex);
            }
        }
        if (dataSources.size() == 0) {
            try {
                mbeanServer.unregisterMBean(new ObjectName(MBEAN_NAME));
            }
            catch (JMException ex) {
                LOG.error((Object)"unregister mbean error", (Throwable)ex);
            }
        }
    }

    public static Set<DruidDataSource> getDruidDataSourceInstances() {
        return dataSources.keySet();
    }

    @Override
    public void reset() {
        Set<DruidDataSource> dataSources = DruidDataSourceStatManager.getDruidDataSourceInstances();
        for (DruidDataSource dataSource : dataSources) {
            dataSource.resetStat();
        }
        this.resetCount.incrementAndGet();
    }

    @Override
    public long getResetCount() {
        return this.resetCount.get();
    }

    @Override
    public TabularData getDataSourceList() throws JMException {
        CompositeType rowType = DruidDataSourceStatManager.getDruidDataSourceCompositeType();
        String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
        TabularType tabularType = new TabularType("DruidDataSourceStat", "DruidDataSourceStat", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        Set<DruidDataSource> dataSources = DruidDataSourceStatManager.getDruidDataSourceInstances();
        for (DruidDataSource dataSource : dataSources) {
            data.put(this.getCompositeData(dataSource));
        }
        return data;
    }

    public CompositeDataSupport getCompositeData(DruidDataSource dataSource) throws JMException {
        CompositeType rowType = DruidDataSourceStatManager.getDruidDataSourceCompositeType();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", dataSource.getName());
        map.put("URL", dataSource.getUrl());
        map.put("CreateCount", dataSource.getCreateCount());
        map.put("DestroyCount", dataSource.getDestroyCount());
        map.put("ConnectCount", dataSource.getConnectCount());
        map.put("CloseCount", dataSource.getCloseCount());
        map.put("ActiveCount", dataSource.getActivePeak());
        map.put("PoolingCount", dataSource.getPoolingCount());
        map.put("LockQueueLength", dataSource.getLockQueueLength());
        map.put("WaitThreadCount", dataSource.getNotEmptyWaitThreadPeak());
        map.put("InitialSize", dataSource.getInitialSize());
        map.put("MaxActive", dataSource.getMaxActive());
        map.put("MinIdle", dataSource.getMinIdle());
        map.put("PoolPreparedStatements", dataSource.isPoolPreparedStatements());
        map.put("TestOnBorrow", dataSource.isTestOnBorrow());
        map.put("TestOnReturn", dataSource.isTestOnReturn());
        map.put("MinEvictableIdleTimeMillis", dataSource.getMinEvictableIdleTimeMillis());
        map.put("ConnectErrorCount", dataSource.getConnectErrorCount());
        map.put("CreateTimespanMillis", dataSource.getCreateTimespanMillis());
        map.put("DbType", dataSource.getDbType());
        map.put("ValidationQuery", dataSource.getValidationQuery());
        map.put("ValidationQueryTimeout", dataSource.getValidationQueryTimeout());
        map.put("DriverClassName", dataSource.getDriverClassName());
        map.put("Username", dataSource.getUsername());
        map.put("RemoveAbandonedCount", dataSource.getRemoveAbandonedCount());
        map.put("NotEmptyWaitCount", dataSource.getNotEmptyWaitCount());
        map.put("NotEmptyWaitNanos", dataSource.getNotEmptyWaitNanos());
        map.put("ErrorCount", dataSource.getErrorCount());
        map.put("ReusePreparedStatementCount", dataSource.getCachedPreparedStatementHitCount());
        map.put("StartTransactionCount", dataSource.getStartTransactionCount());
        map.put("CommitCount", dataSource.getCommitCount());
        map.put("RollbackCount", dataSource.getRollbackCount());
        map.put("LastError", JMXUtils.getErrorCompositeData(dataSource.getLastError()));
        map.put("LastCreateError", JMXUtils.getErrorCompositeData(dataSource.getLastCreateError()));
        map.put("PreparedStatementCacheDeleteCount", dataSource.getCachedPreparedStatementDeleteCount());
        map.put("PreparedStatementCacheAccessCount", dataSource.getCachedPreparedStatementAccessCount());
        map.put("PreparedStatementCacheMissCount", dataSource.getCachedPreparedStatementMissCount());
        map.put("PreparedStatementCacheHitCount", dataSource.getCachedPreparedStatementHitCount());
        map.put("PreparedStatementCacheCurrentCount", dataSource.getCachedPreparedStatementCount());
        map.put("Version", dataSource.getVersion());
        map.put("LastErrorTime", dataSource.getLastErrorTime());
        map.put("LastCreateErrorTime", dataSource.getLastCreateErrorTime());
        return new CompositeDataSupport(rowType, map);
    }

    public static CompositeType getDruidDataSourceCompositeType() throws JMException {
        String[] indexNames;
        if (COMPOSITE_TYPE != null) {
            return COMPOSITE_TYPE;
        }
        OpenType[] indexTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, JMXUtils.getThrowableCompositeType(), JMXUtils.getThrowableCompositeType(), SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.DATE, SimpleType.DATE};
        String[] indexDescriptions = indexNames = new String[]{"Name", "URL", "CreateCount", "DestroyCount", "ConnectCount", "CloseCount", "ActiveCount", "PoolingCount", "LockQueueLength", "WaitThreadCount", "InitialSize", "MaxActive", "MinIdle", "PoolPreparedStatements", "TestOnBorrow", "TestOnReturn", "MinEvictableIdleTimeMillis", "ConnectErrorCount", "CreateTimespanMillis", "DbType", "ValidationQuery", "ValidationQueryTimeout", "DriverClassName", "Username", "RemoveAbandonedCount", "NotEmptyWaitCount", "NotEmptyWaitNanos", "ErrorCount", "ReusePreparedStatementCount", "StartTransactionCount", "CommitCount", "RollbackCount", "LastError", "LastCreateError", "PreparedStatementCacheDeleteCount", "PreparedStatementCacheAccessCount", "PreparedStatementCacheMissCount", "PreparedStatementCacheHitCount", "PreparedStatementCacheCurrentCount", "Version", "LastErrorTime", "LastCreateErrorTime"};
        COMPOSITE_TYPE = new CompositeType("DataSourceStatistic", "DataSource Statistic", indexNames, indexDescriptions, indexTypes);
        return COMPOSITE_TYPE;
    }
}

