/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.stat.JdbcSqlStatMBean;
import com.alibaba.druid.stat.JdbcStatContext;
import com.alibaba.druid.stat.JdbcStatManager;
import com.alibaba.druid.util.Histogram;
import com.alibaba.druid.util.JMXUtils;
import com.alibaba.druid.util.JdbcUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class JdbcSqlStat
implements JdbcSqlStatMBean {
    private final String sql;
    private long id;
    private String dataSource;
    private long executeLastStartTime;
    private final AtomicLong executeBatchSizeTotal = new AtomicLong();
    private final AtomicLong executeBatchSizeMax = new AtomicLong();
    private final AtomicLong executeSuccessCount = new AtomicLong();
    private final AtomicLong executeSpanNanoTotal = new AtomicLong();
    private final AtomicLong executeSpanNanoMax = new AtomicLong();
    private final AtomicLong runningCount = new AtomicLong(0L);
    private final AtomicLong concurrentMax = new AtomicLong();
    private String name;
    private String file;
    private String dbType;
    private long executeNanoSpanMaxOccurTime;
    private final AtomicLong executeErrorCount = new AtomicLong();
    private Throwable executeErrorLast;
    private long executeErrorLastTime;
    private final AtomicLong updateCount = new AtomicLong();
    private final AtomicLong fetchRowCount = new AtomicLong();
    private final Histogram histogram = new Histogram(4L, 15L, 60L, 250L, 1000L, 4000L, 15000L, 60000L, 250000L);
    private static CompositeType COMPOSITE_TYPE = null;

    public JdbcSqlStat(String sql) {
        this.sql = sql;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    @Deprecated
    public static final String getContextSqlName() {
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        if (context == null) {
            return null;
        }
        return context.getName();
    }

    @Deprecated
    public static final void setContextSqlName(String val) {
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        if (context == null) {
            context = JdbcStatManager.getInstance().createStatContext();
            JdbcStatManager.getInstance().setStatContext(context);
        }
        context.setName(val);
    }

    @Deprecated
    public static final String getContextSqlFile() {
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        if (context == null) {
            return null;
        }
        return context.getFile();
    }

    @Deprecated
    public static final void setContextSqlFile(String val) {
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        if (context == null) {
            context = JdbcStatManager.getInstance().createStatContext();
            JdbcStatManager.getInstance().setStatContext(context);
        }
        context.setFile(val);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public void reset() {
        this.executeLastStartTime = 0L;
        this.executeBatchSizeTotal.set(0L);
        this.executeBatchSizeMax.set(0L);
        this.executeSuccessCount.set(0L);
        this.executeSpanNanoTotal.set(0L);
        this.executeSpanNanoMax.set(0L);
        this.executeNanoSpanMaxOccurTime = 0L;
        this.runningCount.set(0L);
        this.concurrentMax.set(0L);
        this.executeErrorCount.set(0L);
        this.executeErrorLast = null;
        this.executeErrorLastTime = 0L;
        this.updateCount.set(0L);
        this.fetchRowCount.set(0L);
        this.histogram.reset();
    }

    @Override
    public long getConcurrentMax() {
        return this.concurrentMax.get();
    }

    @Override
    public long getRunningCount() {
        return this.runningCount.get();
    }

    public void addUpdateCount(int delta) {
        this.updateCount.addAndGet(delta);
    }

    @Override
    public long getUpdateCount() {
        return this.updateCount.get();
    }

    @Override
    public long getFetchRowCount() {
        return this.fetchRowCount.get();
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public Date getExecuteLastStartTime() {
        if (this.executeLastStartTime <= 0L) {
            return null;
        }
        return new Date(this.executeLastStartTime);
    }

    public void setExecuteLastStartTime(long executeLastStartTime) {
        this.executeLastStartTime = executeLastStartTime;
    }

    @Override
    public Date getExecuteNanoSpanMaxOccurTime() {
        if (this.executeNanoSpanMaxOccurTime <= 0L) {
            return null;
        }
        return new Date(this.executeNanoSpanMaxOccurTime);
    }

    @Override
    public Date getExecuteErrorLastTime() {
        if (this.executeErrorLastTime <= 0L) {
            return null;
        }
        return new Date(this.executeErrorLastTime);
    }

    public void addFetchRowCount(long delta) {
        this.fetchRowCount.addAndGet(delta);
    }

    public void addExecuteBatchCount(long batchSize) {
        long current;
        this.executeBatchSizeTotal.addAndGet(batchSize);
        while ((current = this.executeBatchSizeMax.get()) < batchSize && !this.executeBatchSizeMax.compareAndSet(current, batchSize)) {
        }
    }

    @Override
    public long getExecuteBatchSizeTotal() {
        return this.executeBatchSizeTotal.get();
    }

    public void incrementExecuteSuccessCount() {
        this.executeSuccessCount.incrementAndGet();
    }

    public void incrementRunningCount() {
        long max;
        long val = this.runningCount.incrementAndGet();
        while (val > (max = this.concurrentMax.get()) && !this.concurrentMax.compareAndSet(max, val)) {
        }
    }

    public void decrementExecutingCount() {
        this.runningCount.decrementAndGet();
    }

    @Override
    public long getExecuteSuccessCount() {
        return this.executeSuccessCount.get();
    }

    public void addExecuteTime(long nanoSpan) {
        long current;
        this.executeSpanNanoTotal.addAndGet(nanoSpan);
        while ((current = this.executeSpanNanoMax.get()) < nanoSpan) {
            if (!this.executeSpanNanoMax.compareAndSet(current, nanoSpan)) continue;
            this.executeNanoSpanMaxOccurTime = System.currentTimeMillis();
            break;
        }
        long millis = nanoSpan / 1000000L;
        this.histogram.recode(millis);
    }

    @Override
    public long getExecuteMillisTotal() {
        return this.executeSpanNanoTotal.get() / 1000000L;
    }

    @Override
    public long getExecuteMillisMax() {
        return this.executeSpanNanoMax.get() / 1000000L;
    }

    @Override
    public long getErrorCount() {
        return this.executeErrorCount.get();
    }

    @Override
    public long getExecuteBatchSizeMax() {
        return this.executeBatchSizeMax.get();
    }

    public static CompositeType getCompositeType() throws JMException {
        String[] indexNames;
        if (COMPOSITE_TYPE != null) {
            return COMPOSITE_TYPE;
        }
        OpenType[] indexTypes = new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.LONG, JMXUtils.getThrowableCompositeType(), SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.DATE, SimpleType.STRING, SimpleType.STRING, new ArrayType(SimpleType.LONG, true)};
        String[] indexDescriptions = indexNames = new String[]{"ID", "DataSource", "SQL", "ExecuteCount", "ErrorCount", "TotalTime", "LastTime", "MaxTimespan", "LastError", "EffectedRowCount", "FetchRowCount", "MaxTimespanOccurTime", "BatchSizeMax", "BatchSizeTotal", "ConcurrentMax", "RunningCount", "Name", "File", "LastErrorMessage", "LastErrorClass", "LastErrorStackTrace", "LastErrorTime", "DbType", "URL", "Histogram"};
        COMPOSITE_TYPE = new CompositeType("SqlStatistic", "Sql Statistic", indexNames, indexDescriptions, indexTypes);
        return COMPOSITE_TYPE;
    }

    @Override
    public long getExecuteCount() {
        return this.getErrorCount() + this.getExecuteSuccessCount();
    }

    public Map<String, Object> getData() throws JMException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ID", this.id);
        map.put("DataSource", this.dataSource);
        map.put("SQL", this.sql);
        map.put("ExecuteCount", this.getExecuteCount());
        map.put("ErrorCount", this.getErrorCount());
        map.put("TotalTime", this.getExecuteMillisTotal());
        map.put("LastTime", this.getExecuteLastStartTime());
        map.put("MaxTimespan", this.getExecuteMillisMax());
        map.put("LastError", JMXUtils.getErrorCompositeData(this.getExecuteErrorLast()));
        map.put("EffectedRowCount", this.getUpdateCount());
        map.put("FetchRowCount", this.getFetchRowCount());
        map.put("MaxTimespanOccurTime", this.getExecuteNanoSpanMaxOccurTime());
        map.put("BatchSizeMax", this.getExecuteBatchSizeMax());
        map.put("BatchSizeTotal", this.getExecuteBatchSizeTotal());
        map.put("ConcurrentMax", this.getConcurrentMax());
        map.put("RunningCount", this.getRunningCount());
        map.put("Name", this.getName());
        map.put("File", this.getFile());
        Throwable lastError = this.executeErrorLast;
        if (lastError != null) {
            map.put("LastErrorMessage", lastError.getMessage());
            map.put("LastErrorClass", lastError.getClass().getName());
            map.put("LastErrorStackTrace", JdbcUtils.getStackTrace(lastError));
            map.put("LastErrorTime", new Date(this.executeErrorLastTime));
        } else {
            map.put("LastErrorMessage", null);
            map.put("LastErrorClass", null);
            map.put("LastErrorStackTrace", null);
            map.put("LastErrorTime", null);
        }
        map.put("DbType", this.dbType);
        map.put("URL", null);
        map.put("Histogram", this.histogram.toArray());
        return map;
    }

    public CompositeDataSupport getCompositeData() throws JMException {
        return new CompositeDataSupport(JdbcSqlStat.getCompositeType(), this.getData());
    }

    public Throwable getExecuteErrorLast() {
        return this.executeErrorLast;
    }

    public void error(Throwable error) {
        this.executeErrorCount.incrementAndGet();
        this.executeErrorLastTime = System.currentTimeMillis();
        this.executeErrorLast = error;
    }
}

