/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.filter.trace.TraceEvent;
import com.alibaba.druid.filter.trace.TraceEventListener;
import com.alibaba.druid.stat.JdbcTraceManagerMBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcTraceManager
extends NotificationBroadcasterSupport
implements JdbcTraceManagerMBean {
    public static final Log LOG = LogFactory.getLog(JdbcTraceManager.class);
    private boolean traceEnable = false;
    private static final JdbcTraceManager instance = new JdbcTraceManager();
    private final List<TraceEventListener> eventListeners = new ArrayList<TraceEventListener>();
    private final AtomicLong fireEventCount = new AtomicLong();
    private final AtomicLong skipEventCount = new AtomicLong();
    private boolean notificationEnable = false;
    private final NotificationTraceEventListener notificationListener = new NotificationTraceEventListener();

    @Override
    public boolean isNotificationEnable() {
        return this.notificationEnable;
    }

    @Override
    public void setNotificationEnable(boolean notificationEnable) {
        this.notificationEnable = notificationEnable;
    }

    public NotificationTraceEventListener getNotificationListener() {
        return this.notificationListener;
    }

    public static JdbcTraceManager getInstance() {
        return instance;
    }

    @Override
    public boolean isTraceEnable() {
        return this.traceEnable;
    }

    @Override
    public void setTraceEnable(boolean traceEnable) {
        this.traceEnable = traceEnable;
    }

    @Override
    public long getEventFiredCount() {
        return this.fireEventCount.get();
    }

    @Override
    public int getEventListenerSize() {
        return this.eventListeners.size();
    }

    @Override
    public long getEventSkipCount() {
        return this.skipEventCount.get();
    }

    public void fireTraceEvent(TraceEvent event) {
        this.fireEventCount.incrementAndGet();
        if (!this.traceEnable) {
            this.skipEventCount.incrementAndGet();
            return;
        }
        if (this.isNotificationEnable()) {
            this.notificationListener.fireEvent(event);
        }
        for (TraceEventListener listener : this.eventListeners) {
            try {
                listener.fireEvent(event);
            }
            catch (Exception e) {
                LOG.error((Object)"fireTraceEventError", (Throwable)e);
            }
        }
    }

    public List<TraceEventListener> getEventListeners() {
        return this.eventListeners;
    }

    public class NotificationTraceEventListener
    implements TraceEventListener {
        private long sequenceNumber = 0L;

        @Override
        public void fireEvent(TraceEvent event) {
            Notification notification = new Notification(event.getEventType(), JdbcTraceManager.class.getName(), this.sequenceNumber++);
            notification.setTimeStamp(event.getEventTime().getTime());
            notification.setUserData(event.getContext());
            JdbcTraceManager.this.sendNotification(notification);
        }
    }
}

