/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.logging.Log;
import com.alibaba.druid.logging.LogFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public final class JdbcUtils {
    private static final Log LOG = LogFactory.getLog(JdbcUtils.class);
    private static final Properties driverUrlMapping = new Properties();

    public static final void close(Connection x) {
        if (x != null) {
            try {
                x.close();
            }
            catch (Exception e) {
                LOG.error("close connection error", e);
            }
        }
    }

    public static final void close(Statement x) {
        if (x != null) {
            try {
                x.close();
            }
            catch (Exception e) {
                LOG.error("close statement error", e);
            }
        }
    }

    public static final void close(ResultSet x) {
        if (x != null) {
            try {
                x.close();
            }
            catch (Exception e) {
                LOG.error("close resultset error", e);
            }
        }
    }

    public static final void close(Closeable x) {
        if (x != null) {
            try {
                x.close();
            }
            catch (Exception e) {
                LOG.error("close error", e);
            }
        }
    }

    public static final void printResultSet(ResultSet rs) throws SQLException {
        JdbcUtils.printResultSet(rs, System.out);
    }

    public static final void printResultSet(ResultSet rs, PrintStream out) throws SQLException {
        int columnIndex;
        ResultSetMetaData metadata = rs.getMetaData();
        int columnCount = metadata.getColumnCount();
        for (columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            if (columnIndex != 1) {
                out.print('\t');
            }
            out.print(metadata.getColumnName(columnIndex));
        }
        out.println();
        while (rs.next()) {
            for (columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                Object objec;
                int type;
                if (columnIndex != 1) {
                    out.print('\t');
                }
                if ((type = metadata.getColumnType(columnIndex)) == 12 || type == 1 || type == -9 || type == -15) {
                    out.print(rs.getString(columnIndex));
                    continue;
                }
                if (type == 91) {
                    Date date = rs.getDate(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(date.toString());
                    continue;
                }
                if (type == -7) {
                    boolean value = rs.getBoolean(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Boolean.toString(value));
                    continue;
                }
                if (type == 16) {
                    boolean value = rs.getBoolean(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Boolean.toString(value));
                    continue;
                }
                if (type == -6) {
                    byte value = rs.getByte(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Byte.toString(value));
                    continue;
                }
                if (type == 5) {
                    short value = rs.getShort(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Short.toString(value));
                    continue;
                }
                if (type == 4) {
                    int value = rs.getInt(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Integer.toString(value));
                    continue;
                }
                if (type == -5) {
                    long value = rs.getLong(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Long.toString(value));
                    continue;
                }
                if (type == 93) {
                    out.print(String.valueOf(rs.getTimestamp(columnIndex)));
                    continue;
                }
                if (type == 3) {
                    out.print(String.valueOf(rs.getBigDecimal(columnIndex)));
                    continue;
                }
                if (type == 2005) {
                    out.print(String.valueOf(rs.getString(columnIndex)));
                    continue;
                }
                if (type == 2000) {
                    objec = rs.getObject(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(String.valueOf(objec));
                    continue;
                }
                if (type == -1) {
                    objec = rs.getString(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(String.valueOf(objec));
                    continue;
                }
                objec = rs.getObject(columnIndex);
                if (rs.wasNull()) {
                    out.print("null");
                    continue;
                }
                out.print(String.valueOf(objec));
            }
            out.println();
        }
    }

    public static String getTypeName(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -15: {
                return "NCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case -8: {
                return "ROWID";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2009: {
                return "SQLXML";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "OTHER";
    }

    public static String read(Reader reader) {
        try {
            int DEFAULT_BUFFER_SIZE = 4096;
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String read(Reader reader, int length) {
        try {
            int len;
            char[] buffer = new char[length];
            int offset = 0;
            int rest = length;
            while ((len = reader.read(buffer, offset, rest)) != -1) {
                offset += len;
                if ((rest -= len) != 0) continue;
            }
            return new String(buffer, 0, length - rest);
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String getDriverClassName(String rawUrl) throws SQLException {
        if (rawUrl.startsWith("jdbc:derby:")) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        if (rawUrl.startsWith("jdbc:mysql:")) {
            return "com.mysql.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:oracle:")) {
            return "oracle.jdbc.driver.OracleDriver";
        }
        if (rawUrl.startsWith("jdbc:microsoft:")) {
            return "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        }
        if (rawUrl.startsWith("jdbc:sqlserver:")) {
            return "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        }
        if (rawUrl.startsWith("jdbc:sybase:Tds:")) {
            return "com.sybase.jdbc2.jdbc.SybDriver";
        }
        if (rawUrl.startsWith("jdbc:jtds:")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:fake:") || rawUrl.startsWith("jdbc:mock:")) {
            return "com.alibaba.druid.mock.MockDriver";
        }
        if (rawUrl.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        if (rawUrl.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbcDriver";
        }
        if (rawUrl.startsWith("jdbc:db2:")) {
            return "COM.ibm.db2.jdbc.app.DB2Driver";
        }
        if (rawUrl.startsWith("jdbc:sqlite:")) {
            return "org.sqlite.JDBC";
        }
        if (rawUrl.startsWith("jdbc:ingres:")) {
            return "com.ingres.jdbc.IngresDriver";
        }
        if (rawUrl.startsWith("jdbc:h2:")) {
            return "org.h2.Driver";
        }
        if (rawUrl.startsWith("jdbc:mckoi:")) {
            return "com.mckoi.JDBCDriver";
        }
        if (rawUrl.startsWith("jdbc:cloudscape:")) {
            return "COM.cloudscape.core.JDBCDriver";
        }
        if (rawUrl.startsWith("jdbc:informix-sqli:")) {
            return "com.informix.jdbc.IfxDriver";
        }
        if (rawUrl.startsWith("jdbc:timesten:")) {
            return "com.timesten.jdbc.TimesTenDriver";
        }
        if (rawUrl.startsWith("jdbc:as400:")) {
            return "com.ibm.as400.access.AS400JDBCDriver";
        }
        if (rawUrl.startsWith("jdbc:sapdb:")) {
            return "com.sap.dbtech.jdbc.DriverSapDB";
        }
        if (rawUrl.startsWith("jdbc:JSQLConnect:")) {
            return "com.jnetdirect.jsql.JSQLDriver";
        }
        if (rawUrl.startsWith("jdbc:JTurbo:")) {
            return "com.newatlanta.jturbo.driver.Driver";
        }
        if (rawUrl.startsWith("jdbc:firebirdsql:")) {
            return "org.firebirdsql.jdbc.FBDriver";
        }
        if (rawUrl.startsWith("jdbc:interbase:")) {
            return "interbase.interclient.Driver";
        }
        if (rawUrl.startsWith("jdbc:pointbase:")) {
            return "com.pointbase.jdbc.jdbcUniversalDriver";
        }
        if (rawUrl.startsWith("jdbc:edbc:")) {
            return "ca.edbc.jdbc.EdbcDriver";
        }
        if (rawUrl.startsWith("jdbc:mimer:multi1:")) {
            return "com.mimer.jdbc.Driver";
        }
        throw new SQLException("unkow jdbc driver : " + rawUrl);
    }

    public static String getDbType(String rawUrl, String driverClassName) {
        if (rawUrl == null) {
            return null;
        }
        if (rawUrl.startsWith("jdbc:derby:")) {
            return "derby";
        }
        if (rawUrl.startsWith("jdbc:mysql:")) {
            return "mysql";
        }
        if (rawUrl.startsWith("jdbc:oracle:")) {
            return "oracle";
        }
        if (rawUrl.startsWith("jdbc:microsoft:")) {
            return "sqlserver";
        }
        if (rawUrl.startsWith("jdbc:sybase:Tds:")) {
            return "sybase";
        }
        if (rawUrl.startsWith("jdbc:jtds:")) {
            return "jtds";
        }
        if (rawUrl.startsWith("jdbc:fake:") || rawUrl.startsWith("jdbc:mock:")) {
            return "mock";
        }
        if (rawUrl.startsWith("jdbc:postgresql:")) {
            return "postgresql";
        }
        if (rawUrl.startsWith("jdbc:hsqldb:")) {
            return "hsql";
        }
        if (rawUrl.startsWith("jdbc:db2:")) {
            return "db2";
        }
        if (rawUrl.startsWith("jdbc:sqlite:")) {
            return "sqlite";
        }
        if (rawUrl.startsWith("jdbc:ingres:")) {
            return "ingres";
        }
        if (rawUrl.startsWith("jdbc:h2:")) {
            return "h2";
        }
        if (rawUrl.startsWith("jdbc:mckoi:")) {
            return "mckoi";
        }
        if (rawUrl.startsWith("jdbc:cloudscape:")) {
            return "cloudscape";
        }
        if (rawUrl.startsWith("jdbc:informix-sqli:")) {
            return "informix";
        }
        if (rawUrl.startsWith("jdbc:timesten:")) {
            return "timesten";
        }
        if (rawUrl.startsWith("jdbc:as400:")) {
            return "as400";
        }
        if (rawUrl.startsWith("jdbc:sapdb:")) {
            return "sapdb";
        }
        if (rawUrl.startsWith("jdbc:JSQLConnect:")) {
            return "JSQLConnect";
        }
        if (rawUrl.startsWith("jdbc:JTurbo:")) {
            return "JTurbo";
        }
        if (rawUrl.startsWith("jdbc:firebirdsql:")) {
            return "firebirdsql";
        }
        if (rawUrl.startsWith("jdbc:interbase:")) {
            return "interbase";
        }
        if (rawUrl.startsWith("jdbc:pointbase:")) {
            return "pointbase";
        }
        if (rawUrl.startsWith("jdbc:edbc:")) {
            return "edbc";
        }
        if (rawUrl.startsWith("jdbc:mimer:multi1:")) {
            return "mimer";
        }
        return null;
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter buf = new StringWriter();
        ex.printStackTrace(new PrintWriter(buf));
        return buf.toString();
    }

    public static String toString(java.util.Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static Driver createDriver(String driverClassName) throws SQLException {
        try {
            return (Driver)Class.forName(driverClassName).newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    public static String toString(StackTraceElement[] stackTrace) {
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement item : stackTrace) {
            buf.append(item.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources("META-INF/druid-driver.properties");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                Properties property = new Properties();
                InputStream is = null;
                try {
                    is = url.openStream();
                    property.load(is);
                }
                finally {
                    JdbcUtils.close(is);
                }
                driverUrlMapping.putAll((Map<?, ?>)property);
            }
        }
        catch (Exception e) {
            LOG.error("load druid-driver.properties error", e);
        }
    }
}

