/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.visitor;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.ParameterizedOutputVisitorUtils;
import com.alibaba.druid.sql.visitor.ParameterizedVisitor;
import java.util.List;
import java.util.Properties;

public class MySqlParameterizedOutputVisitor
extends MySqlOutputVisitor
implements ParameterizedVisitor {
    private boolean shardingSupport = true;
    private int replaceCount;

    public MySqlParameterizedOutputVisitor() {
        this(new StringBuilder());
    }

    public MySqlParameterizedOutputVisitor(Appendable appender) {
        super(appender);
        this.configFromPropety(System.getProperties());
    }

    public void configFromPropety(Properties properties) {
        String property = properties.getProperty("druid.parameterized.shardingSupport");
        if ("true".equals(property)) {
            this.setShardingSupport(true);
        } else if ("false".equals(property)) {
            this.setShardingSupport(false);
        }
    }

    public boolean isShardingSupport() {
        return this.shardingSupport;
    }

    public void setShardingSupport(boolean shardingSupport) {
        this.shardingSupport = shardingSupport;
    }

    @Override
    public int getReplaceCount() {
        return this.replaceCount;
    }

    @Override
    public void incrementReplaceCunt() {
        ++this.replaceCount;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        return ParameterizedOutputVisitorUtils.visit((ParameterizedVisitor)this, x);
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String name = x.getName();
        boolean computeSharding = this.isShardingSupport();
        if (computeSharding) {
            SQLObject parent = x.getParent();
            boolean bl = computeSharding = parent instanceof SQLExprTableSource || parent instanceof SQLPropertyExpr;
        }
        if (computeSharding) {
            char ch;
            int i;
            int pos = name.lastIndexOf(95);
            if (pos != -1 && pos != name.length() - 1) {
                boolean isNumber = true;
                for (i = pos + 1; i < name.length(); ++i) {
                    ch = name.charAt(i);
                    if (ch >= '0' && ch <= '9') continue;
                    isNumber = false;
                    break;
                }
                if (isNumber) {
                    String realName = name.substring(0, pos);
                    this.print(realName);
                    this.incrementReplaceCunt();
                    return false;
                }
            }
            int numberCount = 0;
            for (i = name.length() - 1; i >= 0 && (ch = name.charAt(i)) >= '0' && ch <= '9'; --i) {
                ++numberCount;
            }
            if (numberCount > 1) {
                int numPos = name.length() - numberCount;
                String realName = name.substring(0, numPos);
                this.print(realName);
                this.incrementReplaceCunt();
                return false;
            }
        }
        this.print(name);
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        x = ParameterizedOutputVisitorUtils.merge(this, x);
        return super.visit(x);
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            return super.visit(x);
        }
        return ParameterizedOutputVisitorUtils.visit((ParameterizedVisitor)this, x);
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            return super.visit(x);
        }
        return ParameterizedOutputVisitorUtils.visit((ParameterizedVisitor)this, x);
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            return super.visit(x);
        }
        return ParameterizedOutputVisitorUtils.visit((ParameterizedVisitor)this, x);
    }

    @Override
    public boolean visit(SQLNCharExpr x) {
        if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            return super.visit(x);
        }
        return ParameterizedOutputVisitorUtils.visit((ParameterizedVisitor)this, x);
    }

    @Override
    protected void printValuesList(MySqlInsertStatement x) {
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        this.print("VALUES ");
        this.incrementIndent();
        valuesList.get(0).accept(this);
        this.decrementIndent();
        if (valuesList.size() > 1) {
            this.incrementReplaceCunt();
        }
    }
}

