/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.CycleClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.FlashbackQueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.GroupingSetExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.ModelClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleWithSubqueryEntry;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.PartitionExtensionClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SampleClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SearchClause;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAggregateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleOrderByItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelect;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectForUpdate;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectHierachicalQueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectRestriction;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectUnPivot;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class OracleSelectParser
extends SQLSelectParser {
    public OracleSelectParser(String sql) {
        super(new OracleExprParser(sql));
    }

    public OracleSelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public OracleSelect select() {
        OracleSelect select = new OracleSelect();
        this.withSubquery(select);
        select.setQuery(this.query());
        select.setOrderBy(this.parseOrderBy());
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.accept(Token.UPDATE);
            OracleSelectForUpdate forUpdate = new OracleSelectForUpdate();
            if (this.lexer.token() == Token.OF) {
                this.lexer.nextToken();
                this.exprParser.exprList(forUpdate.getOf());
            }
            if (this.lexer.token() == Token.NOWAIT) {
                this.lexer.nextToken();
                forUpdate.setNotWait(true);
            } else if (this.lexer.token() == Token.WAIT) {
                this.lexer.nextToken();
                forUpdate.setWait(this.exprParser.primary());
            } else if (this.identifierEquals("SKIP")) {
                this.lexer.nextToken();
                this.acceptIdentifier("LOCKED");
                forUpdate.setSkipLocked(true);
            }
            select.setForUpdate(forUpdate);
        }
        if (select.getOrderBy() == null) {
            select.setOrderBy(this.exprParser.parseOrderBy());
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            if (this.identifierEquals("READ")) {
                this.lexer.nextToken();
                if (!this.identifierEquals("ONLY")) {
                    throw new ParserException("syntax error");
                }
                this.lexer.nextToken();
                select.setRestriction(new OracleSelectRestriction.ReadOnly());
            } else if (this.lexer.token() == Token.CHECK) {
                this.lexer.nextToken();
                if (!this.identifierEquals("OPTION")) {
                    throw new ParserException("syntax error");
                }
                this.lexer.nextToken();
                OracleSelectRestriction.CheckOption checkOption = new OracleSelectRestriction.CheckOption();
                if (this.lexer.token() == Token.CONSTRAINT) {
                    this.lexer.nextToken();
                    throw new ParserException("TODO");
                }
                select.setRestriction(checkOption);
            } else {
                throw new ParserException("syntax error");
            }
        }
        return select;
    }

    @Override
    protected void withSubquery(SQLSelect select) {
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            SQLWithSubqueryClause subqueryFactoringClause = new SQLWithSubqueryClause();
            while (true) {
                OracleWithSubqueryEntry entry = new OracleWithSubqueryEntry();
                entry.setName((SQLIdentifierExpr)this.exprParser.name());
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.names(entry.getColumns());
                    this.accept(Token.RPAREN);
                }
                this.accept(Token.AS);
                this.accept(Token.LPAREN);
                entry.setSubQuery(this.select());
                this.accept(Token.RPAREN);
                if (this.identifierEquals("SEARCH")) {
                    this.lexer.nextToken();
                    SearchClause searchClause = new SearchClause();
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("syntax erorr : " + (Object)((Object)this.lexer.token()));
                    }
                    searchClause.setType(SearchClause.Type.valueOf(this.lexer.stringVal()));
                    this.lexer.nextToken();
                    this.acceptIdentifier("FIRST");
                    this.accept(Token.BY);
                    searchClause.getItems().add((OracleOrderByItem)this.exprParser.parseSelectOrderByItem());
                    while (this.lexer.token() == Token.COMMA) {
                        this.lexer.nextToken();
                        searchClause.getItems().add((OracleOrderByItem)this.exprParser.parseSelectOrderByItem());
                    }
                    this.accept(Token.SET);
                    searchClause.setOrderingColumn((SQLIdentifierExpr)this.exprParser.name());
                    entry.setSearchClause(searchClause);
                }
                if (this.identifierEquals("CYCLE")) {
                    this.lexer.nextToken();
                    CycleClause cycleClause = new CycleClause();
                    this.exprParser.exprList(cycleClause.getAliases());
                    this.accept(Token.SET);
                    cycleClause.setMark(this.exprParser.expr());
                    this.accept(Token.TO);
                    cycleClause.setValue(this.exprParser.expr());
                    this.accept(Token.DEFAULT);
                    cycleClause.setDefaultValue(this.exprParser.expr());
                    entry.setCycleClause(cycleClause);
                }
                subqueryFactoringClause.getEntries().add(entry);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            select.setWithSubQuery(subqueryFactoringClause);
        }
    }

    @Override
    public SQLSelectQuery query() {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select);
        }
        OracleSelectQueryBlock queryBlock = new OracleSelectQueryBlock();
        if (this.lexer.token() == Token.SELECT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            this.parseHints(queryBlock);
            if (this.lexer.token() == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.UNIQUE) {
                queryBlock.setDistionOption(3);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            this.exprParser.parseHints(queryBlock.getHints());
            this.parseSelectList(queryBlock);
        }
        this.parseInto(queryBlock);
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseHierachical(queryBlock);
        this.parseGroupBy(queryBlock);
        this.parseModelClause(queryBlock);
        return this.queryRest(queryBlock);
    }

    @Override
    public SQLSelectQuery queryRest(SQLSelectQuery selectQuery) {
        if (this.lexer.token() == Token.UNION) {
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            this.lexer.nextToken();
            if (this.lexer.token() == Token.ALL) {
                union.setOperator(SQLUnionOperator.UNION_ALL);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DISTINCT) {
                union.setOperator(SQLUnionOperator.DISTINCT);
                this.lexer.nextToken();
            }
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return this.queryRest(union);
        }
        if (this.lexer.token() == Token.INTERSECT) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.INTERSECT);
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return union;
        }
        if (this.lexer.token() == Token.MINUS) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            union.setOperator(SQLUnionOperator.MINUS);
            SQLSelectQuery right = this.query();
            union.setRight(right);
            return union;
        }
        return selectQuery;
    }

    private void parseModelClause(OracleSelectQueryBlock queryBlock) {
        if (this.lexer.token() != Token.MODEL) {
            return;
        }
        this.lexer.nextToken();
        ModelClause model = new ModelClause();
        this.parseCellReferenceOptions(model.getCellReferenceOptions());
        if (this.identifierEquals("RETURN")) {
            this.lexer.nextToken();
            ModelClause.ReturnRowsClause returnRowsClause = new ModelClause.ReturnRowsClause();
            if (this.lexer.token() == Token.ALL) {
                this.lexer.nextToken();
                returnRowsClause.setAll(true);
            } else {
                this.acceptIdentifier("UPDATED");
            }
            this.acceptIdentifier("ROWS");
            model.setReturnRowsClause(returnRowsClause);
        }
        while (this.identifierEquals("REFERENCE")) {
            ModelClause.ReferenceModelClause referenceModelClause = new ModelClause.ReferenceModelClause();
            this.lexer.nextToken();
            SQLExpr name = this.expr();
            referenceModelClause.setName(name);
            this.accept(Token.ON);
            this.accept(Token.LPAREN);
            OracleSelect subQuery = this.select();
            this.accept(Token.RPAREN);
            referenceModelClause.setSubQuery(subQuery);
            this.parseModelColumnClause(referenceModelClause);
            this.parseCellReferenceOptions(referenceModelClause.getCellReferenceOptions());
            model.getReferenceModelClauses().add(referenceModelClause);
        }
        this.parseMainModelClause(model);
        queryBlock.setModelClause(model);
    }

    private void parseMainModelClause(ModelClause modelClause) {
        ModelClause.ModelColumn column;
        ModelClause.MainModelClause mainModel = new ModelClause.MainModelClause();
        if (this.identifierEquals("MAIN")) {
            this.lexer.nextToken();
            mainModel.setMainModelName(this.expr());
        }
        ModelClause.ModelColumnClause modelColumnClause = new ModelClause.ModelColumnClause();
        this.parseQueryPartitionClause(modelColumnClause);
        mainModel.setModelColumnClause(modelColumnClause);
        this.acceptIdentifier("DIMENSION");
        this.accept(Token.BY);
        this.accept(Token.LPAREN);
        while (true) {
            if (this.lexer.token() == Token.RPAREN) break;
            column = new ModelClause.ModelColumn();
            column.setExpr(this.expr());
            column.setAlias(this.as());
            modelColumnClause.getDimensionByColumns().add(column);
            if (this.lexer.token() != Token.COMMA) continue;
            this.lexer.nextToken();
        }
        this.lexer.nextToken();
        this.acceptIdentifier("MEASURES");
        this.accept(Token.LPAREN);
        while (true) {
            if (this.lexer.token() == Token.RPAREN) break;
            column = new ModelClause.ModelColumn();
            column.setExpr(this.expr());
            column.setAlias(this.as());
            modelColumnClause.getMeasuresColumns().add(column);
            if (this.lexer.token() != Token.COMMA) continue;
            this.lexer.nextToken();
        }
        this.lexer.nextToken();
        mainModel.setModelColumnClause(modelColumnClause);
        this.parseCellReferenceOptions(mainModel.getCellReferenceOptions());
        this.parseModelRulesClause(mainModel);
        modelClause.setMainModel(mainModel);
    }

    private void parseModelRulesClause(ModelClause.MainModelClause mainModel) {
        ModelClause.ModelRulesClause modelRulesClause = new ModelClause.ModelRulesClause();
        if (this.identifierEquals("RULES")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.UPDATE) {
                modelRulesClause.getOptions().add(ModelClause.ModelRuleOption.UPDATE);
                this.lexer.nextToken();
            } else if (this.identifierEquals("UPSERT")) {
                modelRulesClause.getOptions().add(ModelClause.ModelRuleOption.UPSERT);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("AUTOMATIC")) {
                this.lexer.nextToken();
                this.accept(Token.ORDER);
                modelRulesClause.getOptions().add(ModelClause.ModelRuleOption.AUTOMATIC_ORDER);
            } else if (this.identifierEquals("SEQUENTIAL")) {
                this.lexer.nextToken();
                this.accept(Token.ORDER);
                modelRulesClause.getOptions().add(ModelClause.ModelRuleOption.SEQUENTIAL_ORDER);
            }
        }
        if (this.identifierEquals("ITERATE")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            modelRulesClause.setIterate(this.expr());
            this.accept(Token.RPAREN);
            if (this.identifierEquals("UNTIL")) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                modelRulesClause.setUntil(this.expr());
                this.accept(Token.RPAREN);
            }
        }
        this.accept(Token.LPAREN);
        while (true) {
            if (this.lexer.token() == Token.RPAREN) break;
            ModelClause.CellAssignmentItem item = new ModelClause.CellAssignmentItem();
            if (this.lexer.token() == Token.UPDATE) {
                item.setOption(ModelClause.ModelRuleOption.UPDATE);
            } else if (this.identifierEquals("UPSERT")) {
                item.setOption(ModelClause.ModelRuleOption.UPSERT);
            }
            item.setCellAssignment(this.parseCellAssignment());
            item.setOrderBy(this.parseOrderBy());
            this.accept(Token.EQ);
            item.setExpr(this.expr());
            modelRulesClause.getCellAssignmentItems().add(item);
        }
        this.lexer.nextToken();
        mainModel.setModelRulesClause(modelRulesClause);
    }

    private ModelClause.CellAssignment parseCellAssignment() {
        ModelClause.CellAssignment cellAssignment = new ModelClause.CellAssignment();
        cellAssignment.setMeasureColumn(this.expr());
        this.accept(Token.LBRACKET);
        this.exprParser.exprList(cellAssignment.getConditions());
        this.accept(Token.RBRACKET);
        return cellAssignment;
    }

    private void parseQueryPartitionClause(ModelClause.ModelColumnClause modelColumnClause) {
        if (this.identifierEquals("PARTITION")) {
            ModelClause.QueryPartitionClause queryPartitionClause = new ModelClause.QueryPartitionClause();
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.exprList(queryPartitionClause.getExprList());
                this.accept(Token.RPAREN);
            } else {
                this.exprParser.exprList(queryPartitionClause.getExprList());
            }
            modelColumnClause.setQueryPartitionClause(queryPartitionClause);
        }
    }

    private void parseModelColumnClause(ModelClause.ReferenceModelClause referenceModelClause) {
        throw new ParserException();
    }

    private void parseCellReferenceOptions(List<ModelClause.CellReferenceOption> options) {
        if (this.identifierEquals("IGNORE")) {
            this.lexer.nextToken();
            this.acceptIdentifier("NAV");
            options.add(ModelClause.CellReferenceOption.IgnoreNav);
        } else if (this.identifierEquals("KEEP")) {
            this.lexer.nextToken();
            this.acceptIdentifier("NAV");
            options.add(ModelClause.CellReferenceOption.KeepNav);
        }
        if (this.lexer.token() == Token.UNIQUE) {
            this.lexer.nextToken();
            if (this.identifierEquals("DIMENSION")) {
                this.lexer.nextToken();
                options.add(ModelClause.CellReferenceOption.UniqueDimension);
            } else {
                this.acceptIdentifier("SINGLE");
                this.acceptIdentifier("REFERENCE");
                options.add(ModelClause.CellReferenceOption.UniqueDimension);
            }
        }
    }

    private void parseGroupBy(OracleSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.GROUP) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            while (true) {
                if (this.identifierEquals("GROUPING")) {
                    GroupingSetExpr groupingSet = new GroupingSetExpr();
                    this.lexer.nextToken();
                    this.acceptIdentifier("SETS");
                    this.accept(Token.LPAREN);
                    this.exprParser.exprList(groupingSet.getParameters());
                    this.accept(Token.RPAREN);
                    groupBy.getItems().add(groupingSet);
                } else {
                    groupBy.getItems().add(this.exprParser.expr());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.HAVING) {
                this.lexer.nextToken();
                groupBy.setHaving(this.exprParser.expr());
            }
            queryBlock.setGroupBy(groupBy);
        } else if (this.lexer.token() == Token.HAVING) {
            this.lexer.nextToken();
            SQLSelectGroupByClause groupBy = new SQLSelectGroupByClause();
            groupBy.setHaving(this.exprParser.expr());
            if (this.lexer.token() == Token.GROUP) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                while (true) {
                    if (this.identifierEquals("GROUPING")) {
                        GroupingSetExpr groupingSet = new GroupingSetExpr();
                        this.lexer.nextToken();
                        this.acceptIdentifier("SETS");
                        this.accept(Token.LPAREN);
                        this.exprParser.exprList(groupingSet.getParameters());
                        this.accept(Token.RPAREN);
                        groupBy.getItems().add(groupingSet);
                    } else {
                        groupBy.getItems().add(this.exprParser.expr());
                    }
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            queryBlock.setGroupBy(groupBy);
        }
    }

    @Override
    protected String as() {
        if (this.lexer.token() == Token.CONNECT) {
            return null;
        }
        return super.as();
    }

    private void parseHierachical(OracleSelectQueryBlock queryBlock) {
        OracleSelectHierachicalQueryClause hierachical = null;
        if (this.lexer.token() == Token.CONNECT) {
            hierachical = new OracleSelectHierachicalQueryClause();
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token() == Token.PRIOR) {
                this.lexer.nextToken();
                hierachical.setPrior(true);
            }
            if (this.identifierEquals("NOCYCLE")) {
                hierachical.setNoCycle(true);
                this.lexer.nextToken();
                if (this.lexer.token() == Token.PRIOR) {
                    this.lexer.nextToken();
                    hierachical.setPrior(true);
                }
            }
            hierachical.setConnectBy(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.START) {
            this.lexer.nextToken();
            if (hierachical == null) {
                hierachical = new OracleSelectHierachicalQueryClause();
            }
            this.accept(Token.WITH);
            hierachical.setStartWith(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.CONNECT) {
            if (hierachical == null) {
                hierachical = new OracleSelectHierachicalQueryClause();
            }
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token() == Token.PRIOR) {
                this.lexer.nextToken();
                hierachical.setPrior(true);
            }
            if (this.identifierEquals("NOCYCLE")) {
                hierachical.setNoCycle(true);
                this.lexer.nextToken();
                if (this.lexer.token() == Token.PRIOR) {
                    this.lexer.nextToken();
                    hierachical.setPrior(true);
                }
            }
            hierachical.setConnectBy(this.exprParser.expr());
        }
        if (hierachical != null) {
            queryBlock.setHierachicalQueryClause(hierachical);
        }
    }

    @Override
    public SQLTableSource parseTableSource() {
        if (this.lexer.token() == Token.LPAREN) {
            OracleSelectSubqueryTableSource tableSource;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.WITH) {
                tableSource = new OracleSelectSubqueryTableSource(this.select());
            } else if (this.lexer.token() == Token.LPAREN) {
                tableSource = new OracleSelectSubqueryTableSource(this.select());
            } else {
                throw new ParserException("TODO :" + (Object)((Object)this.lexer.token()));
            }
            this.accept(Token.RPAREN);
            this.parsePivot(tableSource);
            return this.parseTableSourceRest(tableSource);
        }
        if (this.lexer.token() == Token.SELECT) {
            throw new ParserException("TODO");
        }
        OracleSelectTableReference tableReference = new OracleSelectTableReference();
        if (this.identifierEquals("ONLY")) {
            this.lexer.nextToken();
            tableReference.setOnly(true);
            this.accept(Token.LPAREN);
            this.parseTableSourceQueryTableExpr(tableReference);
            this.accept(Token.RPAREN);
        } else {
            this.parseTableSourceQueryTableExpr(tableReference);
            this.parsePivot(tableReference);
        }
        return this.parseTableSourceRest(tableReference);
    }

    private void parseTableSourceQueryTableExpr(OracleSelectTableReference tableReference) {
        PartitionExtensionClause partition;
        tableReference.setExpr(this.exprParser.expr());
        FlashbackQueryClause clause = this.flashback();
        tableReference.setFlashback(clause);
        if (this.identifierEquals("SAMPLE")) {
            this.lexer.nextToken();
            SampleClause sample = new SampleClause();
            if (this.identifierEquals("BLOCK")) {
                sample.setBlock(true);
                this.lexer.nextToken();
            }
            this.accept(Token.LPAREN);
            this.exprParser.exprList(sample.getPercent());
            this.accept(Token.RPAREN);
            if (this.identifierEquals("SEED")) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                sample.setSeedValue(this.expr());
                this.accept(Token.RPAREN);
            }
            tableReference.setSampleClause(sample);
        }
        if (this.identifierEquals("PARTITION")) {
            this.lexer.nextToken();
            partition = new PartitionExtensionClause();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                partition.setPartition(this.exprParser.name());
                this.accept(Token.RPAREN);
            } else {
                this.accept(Token.FOR);
                this.accept(Token.LPAREN);
                this.exprParser.names(partition.getFor());
                this.accept(Token.RPAREN);
            }
            tableReference.setPartition(partition);
        }
        if (this.identifierEquals("SUBPARTITION")) {
            this.lexer.nextToken();
            partition = new PartitionExtensionClause();
            partition.setSubPartition(true);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                partition.setPartition(this.exprParser.name());
                this.accept(Token.RPAREN);
            } else {
                this.accept(Token.FOR);
                this.accept(Token.LPAREN);
                this.exprParser.names(partition.getFor());
                this.accept(Token.RPAREN);
            }
            tableReference.setPartition(partition);
        }
        if (this.identifierEquals("VERSIONS")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BETWEEN) {
                this.lexer.nextToken();
                clause = new FlashbackQueryClause.VersionsFlashbackQueryClause();
                if (this.identifierEquals("SCN")) {
                    clause.setType(FlashbackQueryClause.Type.SCN);
                    this.lexer.nextToken();
                } else {
                    this.acceptIdentifier("TIMESTAMP");
                    clause.setType(FlashbackQueryClause.Type.TIMESTAMP);
                }
                SQLBinaryOpExpr binaryExpr = (SQLBinaryOpExpr)this.exprParser.expr();
                if (binaryExpr.getOperator() != SQLBinaryOperator.BooleanAnd) {
                    throw new ParserException("syntax error : " + (Object)((Object)binaryExpr.getOperator()));
                }
                ((FlashbackQueryClause.VersionsFlashbackQueryClause)clause).setBegin(binaryExpr.getLeft());
                ((FlashbackQueryClause.VersionsFlashbackQueryClause)clause).setEnd(binaryExpr.getRight());
                tableReference.setFlashback(clause);
            } else {
                throw new ParserException("TODO");
            }
        }
    }

    private FlashbackQueryClause flashback() {
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.OF) {
            this.lexer.nextToken();
            if (this.identifierEquals("SCN")) {
                FlashbackQueryClause.AsOfFlashbackQueryClause clause = new FlashbackQueryClause.AsOfFlashbackQueryClause();
                clause.setType(FlashbackQueryClause.Type.SCN);
                this.lexer.nextToken();
                clause.setExpr(this.exprParser.expr());
                return clause;
            }
            if (this.identifierEquals("SNAPSHOT")) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                FlashbackQueryClause.AsOfSnapshotClause clause = new FlashbackQueryClause.AsOfSnapshotClause();
                clause.setExpr(this.expr());
                this.accept(Token.RPAREN);
                return clause;
            }
            FlashbackQueryClause.AsOfFlashbackQueryClause clause = new FlashbackQueryClause.AsOfFlashbackQueryClause();
            this.acceptIdentifier("TIMESTAMP");
            clause.setType(FlashbackQueryClause.Type.TIMESTAMP);
            clause.setExpr(this.exprParser.expr());
            return clause;
        }
        return null;
    }

    protected SQLTableSource parseTableSourceRest(OracleSelectTableSource tableSource) {
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OF) {
                tableSource.setFlashback(this.flashback());
            }
            tableSource.setAlias(this.as());
        } else if ((tableSource.getAlias() == null || tableSource.getAlias().length() == 0) && this.lexer.token() != Token.LEFT && this.lexer.token() != Token.RIGHT && this.lexer.token() != Token.FULL) {
            tableSource.setAlias(this.as());
        }
        if (this.lexer.token() == Token.HINT) {
            this.exprParser.parseHints(tableSource.getHints());
        }
        SQLJoinTableSource.JoinType joinType = null;
        if (this.lexer.token() == Token.LEFT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN;
        }
        if (this.lexer.token() == Token.RIGHT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN;
        }
        if (this.lexer.token() == Token.FULL) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.OUTER) {
                this.lexer.nextToken();
            }
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.FULL_OUTER_JOIN;
        }
        if (this.lexer.token() == Token.INNER) {
            this.lexer.nextToken();
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.INNER_JOIN;
        }
        if (this.lexer.token() == Token.CROSS) {
            this.lexer.nextToken();
            this.accept(Token.JOIN);
            joinType = SQLJoinTableSource.JoinType.CROSS_JOIN;
        }
        if (this.lexer.token() == Token.JOIN) {
            this.lexer.nextToken();
            joinType = SQLJoinTableSource.JoinType.JOIN;
        }
        if (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            joinType = SQLJoinTableSource.JoinType.COMMA;
        }
        if (joinType != null) {
            OracleSelectJoin join = new OracleSelectJoin();
            join.setLeft(tableSource);
            join.setJoinType(joinType);
            join.setRight(this.parseTableSource());
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                join.setCondition(this.exprParser.expr());
            } else if (this.lexer.token() == Token.USING) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.exprParser.exprList(join.getUsing());
                this.accept(Token.RPAREN);
            }
            return this.parseTableSourceRest(join);
        }
        return tableSource;
    }

    private void parsePivot(OracleSelectTableSource tableSource) {
        if (this.identifierEquals("PIVOT")) {
            OracleSelectPivot.Item item;
            this.lexer.nextToken();
            OracleSelectPivot pivot = new OracleSelectPivot();
            if (this.identifierEquals("XML")) {
                this.lexer.nextToken();
                pivot.setXml(true);
            }
            this.accept(Token.LPAREN);
            while (true) {
                item = new OracleSelectPivot.Item();
                item.setExpr((OracleAggregateExpr)this.exprParser.expr());
                item.setAlias(this.as());
                pivot.getItems().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.FOR);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                while (true) {
                    pivot.getPivotFor().add(new SQLIdentifierExpr(this.lexer.stringVal()));
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            } else {
                pivot.getPivotFor().add(new SQLIdentifierExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            if (this.lexer.token() == Token.LPAREN) {
                throw new ParserException("TODO");
            }
            if (this.lexer.token() == Token.SELECT) {
                throw new ParserException("TODO");
            }
            while (true) {
                item = new OracleSelectPivot.Item();
                item.setExpr(this.exprParser.expr());
                item.setAlias(this.as());
                pivot.getPivotIn().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            this.accept(Token.RPAREN);
            tableSource.setPivot(pivot);
        } else if (this.identifierEquals("UNPIVOT")) {
            this.lexer.nextToken();
            OracleSelectUnPivot unPivot = new OracleSelectUnPivot();
            if (this.identifierEquals("INCLUDE")) {
                this.lexer.nextToken();
                this.acceptIdentifier("NULLS");
                unPivot.setNullsIncludeType(OracleSelectUnPivot.NullsIncludeType.INCLUDE_NULLS);
            } else if (this.identifierEquals("EXCLUDE")) {
                this.lexer.nextToken();
                this.acceptIdentifier("NULLS");
                unPivot.setNullsIncludeType(OracleSelectUnPivot.NullsIncludeType.EXCLUDE_NULLS);
            }
            this.accept(Token.LPAREN);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.exprList(unPivot.getItems());
                this.accept(Token.RPAREN);
            } else {
                unPivot.getItems().add(this.exprParser.expr());
            }
            this.accept(Token.FOR);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                while (true) {
                    unPivot.getPivotFor().add(new SQLIdentifierExpr(this.lexer.stringVal()));
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            } else {
                unPivot.getPivotFor().add(new SQLIdentifierExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            if (this.lexer.token() == Token.LPAREN) {
                throw new ParserException("TODO");
            }
            if (this.lexer.token() == Token.SELECT) {
                throw new ParserException("TODO");
            }
            while (true) {
                OracleSelectPivot.Item item = new OracleSelectPivot.Item();
                item.setExpr(this.exprParser.expr());
                item.setAlias(this.as());
                unPivot.getPivotIn().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            this.accept(Token.RPAREN);
            tableSource.setPivot(unPivot);
        }
    }

    protected void parseInto(OracleSelectQueryBlock x) {
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            SQLExpr expr = this.expr();
            if (this.lexer.token() != Token.COMMA) {
                x.setInto(expr);
                return;
            }
            SQLListExpr list = new SQLListExpr();
            list.getItems().add(expr);
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                list.getItems().add(this.expr());
            }
            x.setInto(list);
        }
    }

    private void parseHints(OracleSelectQueryBlock queryBlock) {
        this.exprParser.parseHints(queryBlock.getHints());
    }
}

