/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.logging;

import com.alibaba.druid.support.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JImpl
implements Log {
    private static final String callerFQCN = SLF4JImpl.class.getName();
    private static final Logger testLogger = LoggerFactory.getLogger(SLF4JImpl.class);
    private int errorCount;
    private int warnCount;
    private int infoCount;
    private int debugCount;
    private LocationAwareLogger log;

    public SLF4JImpl(LocationAwareLogger log) {
        this.log = log;
    }

    public SLF4JImpl(String loggerName) {
        this.log = (LocationAwareLogger)LoggerFactory.getLogger((String)loggerName);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void error(String msg, Throwable e) {
        this.log.log(null, callerFQCN, 40, msg, null, e);
        ++this.errorCount;
    }

    @Override
    public void error(String msg) {
        this.log.log(null, callerFQCN, 40, msg, null, null);
        ++this.errorCount;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        ++this.infoCount;
        this.log.log(null, callerFQCN, 20, msg, null, null);
    }

    @Override
    public void debug(String msg) {
        ++this.debugCount;
        this.log.log(null, callerFQCN, 10, msg, null, null);
    }

    @Override
    public void debug(String msg, Throwable e) {
        ++this.debugCount;
        this.log.log(null, callerFQCN, 40, msg, null, e);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        this.log.log(null, callerFQCN, 30, msg, null, null);
        ++this.warnCount;
    }

    @Override
    public void warn(String msg, Throwable e) {
        this.log.log(null, callerFQCN, 30, msg, null, e);
        ++this.warnCount;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarnCount() {
        return this.warnCount;
    }

    @Override
    public int getInfoCount() {
        return this.infoCount;
    }

    @Override
    public int getDebugCount() {
        return this.debugCount;
    }

    @Override
    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
        this.debugCount = 0;
    }

    static {
        if (!(testLogger instanceof LocationAwareLogger)) {
            throw new UnsupportedOperationException(testLogger.getClass() + " is not a suitable logger");
        }
    }
}

