/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.hdriver.impl.mapping;

import com.alibaba.druid.hdriver.impl.mapping.HMapping;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class HMappingAdapter
implements HMapping {
    @Override
    public byte[] getQualifier(String columnName) {
        return Bytes.toBytes((String)columnName);
    }

    @Override
    public byte[] getRow(Result result, String columnName) {
        return result.getRow();
    }

    @Override
    public Object getObject(Result result, String columnName) {
        byte[] bytes;
        byte[] family = this.getFamily(columnName);
        if (this.isRow(columnName)) {
            bytes = this.getRow(result, columnName);
        } else {
            byte[] qualifier = Bytes.toBytes((String)columnName);
            bytes = result.getValue(family, qualifier);
        }
        return bytes;
    }

    @Override
    public byte[] toBytes(String columnName, Object value) throws IOException {
        byte[] bytes;
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String strValue = (String)value;
            bytes = Bytes.toBytes((String)strValue);
        } else if (value instanceof Integer) {
            int intValue = (Integer)value;
            bytes = Bytes.toBytes((int)intValue);
        } else if (value instanceof Long) {
            long longValue = (Long)value;
            bytes = Bytes.toBytes((long)longValue);
        } else if (value instanceof Boolean) {
            boolean booleanValue = (Boolean)value;
            bytes = Bytes.toBytes((boolean)booleanValue);
        } else if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            bytes = Bytes.toBytes((BigDecimal)decimalValue);
        } else {
            throw new IOException("TODO");
        }
        return bytes;
    }
}

