/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mapping;

import com.alibaba.druid.mapping.MappingObject;
import com.alibaba.druid.mapping.Property;
import java.util.LinkedHashMap;
import java.util.Map;

public class Entity
extends MappingObject {
    private String name;
    private String description;
    private String tableName;
    private Map<String, Property> properties = new LinkedHashMap<String, Property>();

    public Entity() {
    }

    public Entity(String name, String description, String tableName) {
        this.name = name;
        this.description = description;
        this.tableName = tableName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addProperty(Property property) {
        this.properties.put(property.getName(), property);
    }

    public Property getProperty(String name) {
        Property prop = this.properties.get(name);
        if (prop == null) {
            for (Map.Entry<String, Property> entry : this.properties.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(name)) continue;
                prop = entry.getValue();
                break;
            }
        }
        return prop;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Property> properties) {
        this.properties = properties;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{name=");
        buf.append(this.name);
        buf.append(", tableName=");
        buf.append(this.tableName);
        buf.append("}");
        return buf.toString();
    }
}

