/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mapping.spi;

import com.alibaba.druid.mapping.MappingContext;
import com.alibaba.druid.mapping.MappingEngine;
import com.alibaba.druid.mapping.spi.MappingProvider;
import com.alibaba.druid.mapping.spi.MappingVisitor;
import com.alibaba.druid.mapping.spi.MappingVisitorUtils;
import com.alibaba.druid.mapping.spi.MySqlMappingVisitor;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlExportParameterVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class MySqlMappingProvider
implements MappingProvider {
    @Override
    public MappingVisitor createMappingVisitor(MappingEngine engine) {
        return new MySqlMappingVisitor(engine);
    }

    @Override
    public MappingVisitor createMappingVisitor(MappingEngine engine, MappingContext context) {
        return new MySqlMappingVisitor(engine, context);
    }

    @Override
    public SQLASTOutputVisitor createOutputVisitor(MappingEngine engine, Appendable out) {
        return new MySqlOutputVisitor(out);
    }

    @Override
    public SQLSelectQueryBlock explainToSelectSQLObject(MappingEngine engine, String sql, MappingContext context) {
        MySqlSelectParser selectParser = new MySqlSelectParser(sql);
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)selectParser.query();
        Integer maxLimit = engine.getMaxLimit();
        if (maxLimit != null) {
            if (query.getLimit() == null) {
                MySqlSelectQueryBlock.Limit limit = new MySqlSelectQueryBlock.Limit();
                limit.setRowCount(new SQLIntegerExpr(maxLimit));
                query.setLimit(limit);
            } else {
                SQLNumericLiteralExpr rowCountExpr = (SQLNumericLiteralExpr)query.getLimit().getRowCount();
                int rowCount = rowCountExpr.getNumber().intValue();
                if (rowCount > maxLimit) {
                    rowCountExpr.setNumber(maxLimit);
                }
            }
        }
        return query;
    }

    @Override
    public MySqlDeleteStatement explainToDeleteSQLObject(MappingEngine engine, String sql, MappingContext context) {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        MySqlDeleteStatement stmt = parser.parseDeleteStatement();
        MappingVisitorUtils.setTableSource(engine, stmt, context);
        return stmt;
    }

    @Override
    public SQLUpdateStatement explainToUpdateSQLObject(MappingEngine engine, String sql, MappingContext context) {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        SQLUpdateStatement stmt = parser.parseUpdateStatement();
        MappingVisitorUtils.setTableSource(engine, stmt, context);
        return stmt;
    }

    @Override
    public SQLInsertStatement explainToInsertSQLObject(MappingEngine engine, String sql, MappingContext context) {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        SQLInsertStatement stmt = parser.parseInsert();
        MappingVisitorUtils.setTableSource(engine, stmt, context);
        return stmt;
    }

    @Override
    public ExportParameterVisitor createExportParameterVisitor(List<Object> parameters) {
        return new MySqlExportParameterVisitor(parameters);
    }

    @Override
    public List<SQLStatement> explain(MappingEngine engine, String sql) {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        return parser.parseStatementList();
    }
}

