/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha;

import com.alibaba.druid.pool.ha.MultiDataSource;
import com.alibaba.druid.pool.ha.MultiDataSourceStatManagerMBean;
import com.alibaba.druid.util.ConcurrentIdentityHashMap;
import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiDataSourceStatManager
implements MultiDataSourceStatManagerMBean {
    private static final Log LOG = LogFactory.getLog(MultiDataSourceStatManager.class);
    private static final MultiDataSourceStatManager instance = new MultiDataSourceStatManager();
    private final AtomicLong resetCount = new AtomicLong();
    private static final ConcurrentIdentityHashMap<MultiDataSource, ObjectName> dataSources = new ConcurrentIdentityHashMap();
    private static final String MBEAN_NAME = "com.alibaba.druid.ha:type=HADruidDataSourceStat";

    public static MultiDataSourceStatManager getInstance() {
        return instance;
    }

    public static synchronized void add(MultiDataSource dataSource) {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        if (dataSources.size() == 0) {
            try {
                mbeanServer.registerMBean(instance, new ObjectName(MBEAN_NAME));
            }
            catch (JMException ex) {
                LOG.error((Object)"register mbean error", (Throwable)ex);
            }
        }
        ObjectName objectName = null;
        if (dataSource.getNameInternal() != null) {
            try {
                objectName = new ObjectName("com.alibaba.druid.ha:type=DruidDataSource,id=" + dataSource.getNameInternal());
                mbeanServer.registerMBean(dataSource, objectName);
            }
            catch (JMException ex) {
                LOG.error((Object)"register mbean error", (Throwable)ex);
                objectName = null;
            }
        }
        if (objectName == null) {
            try {
                int id = System.identityHashCode(dataSource);
                objectName = new ObjectName("com.alibaba.druid.ha:type=DruidDataSource,id=" + id);
                mbeanServer.registerMBean(dataSource, objectName);
            }
            catch (JMException ex) {
                LOG.error((Object)"register mbean error", (Throwable)ex);
                objectName = null;
            }
        }
        dataSources.put(dataSource, objectName);
        dataSource.setObjectName(objectName);
    }

    public static synchronized void remove(MultiDataSource dataSource) {
        ObjectName objectName = dataSources.remove(dataSource);
        if (objectName == null) {
            objectName = dataSource.getObjectName();
        }
        if (objectName == null) {
            LOG.error((Object)"unregister mbean failed. ");
            return;
        }
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        if (objectName != null) {
            try {
                mbeanServer.unregisterMBean(objectName);
            }
            catch (JMException ex) {
                LOG.error((Object)"unregister mbean error", (Throwable)ex);
            }
        }
        if (dataSources.size() == 0) {
            try {
                mbeanServer.unregisterMBean(new ObjectName(MBEAN_NAME));
            }
            catch (JMException ex) {
                LOG.error((Object)"unregister mbean error", (Throwable)ex);
            }
        }
    }

    public static Set<MultiDataSource> getDruidDataSourceInstances() {
        return dataSources.keySet();
    }

    public void reset() {
        Set<MultiDataSource> dataSources = MultiDataSourceStatManager.getDruidDataSourceInstances();
        for (MultiDataSource dataSource : dataSources) {
            dataSource.resetStat();
        }
        this.resetCount.incrementAndGet();
    }

    public long getResetCount() {
        return this.resetCount.get();
    }
}

