/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha;

import com.alibaba.druid.pool.WrapperAdapter;
import com.alibaba.druid.pool.ha.MultiDataSourceConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class MultiDataSourceStatement
extends WrapperAdapter
implements Statement {
    private final MultiDataSourceConnection conn;
    private final long id;
    private Integer resultSetType;
    private Integer resultSetConcurrency;
    private Integer resultSetHoldability;
    private Statement stmt;
    private Integer maxFieldSize;
    private Integer maxRows;
    private Boolean escapeProcessing;
    private Integer queryTimeout;
    private String cursorName;
    private Integer fetchDirection;
    private Integer fetchSize;

    void checkStatement(String sql) throws SQLException {
        this.conn.checkConnection(sql);
        this.stmt = this.resultSetType != null && this.resultSetConcurrency != null && this.resultSetHoldability != null ? this.conn.getRawObject().createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability) : (this.resultSetType != null && this.resultSetConcurrency != null ? this.conn.getRawObject().createStatement(this.resultSetType, this.resultSetConcurrency) : this.conn.getRawObject().createStatement());
        if (this.maxFieldSize != null) {
            this.stmt.setMaxFieldSize(this.maxFieldSize);
        }
        if (this.maxRows != null) {
            this.stmt.setMaxRows(this.maxRows);
        }
        if (this.escapeProcessing != null) {
            this.stmt.setEscapeProcessing(this.escapeProcessing);
        }
        if (this.queryTimeout != null) {
            this.stmt.setQueryTimeout(this.queryTimeout);
        }
        if (this.cursorName != null) {
            this.stmt.setCursorName(this.cursorName);
        }
        if (this.fetchDirection != null) {
            this.stmt.setFetchDirection(this.fetchDirection);
        }
        if (this.fetchSize != null) {
            this.stmt.setFetchSize(this.fetchSize);
        }
    }

    public MultiDataSourceStatement(MultiDataSourceConnection conn, long id) {
        this.conn = conn;
        this.id = id;
    }

    public MultiDataSourceStatement(MultiDataSourceConnection conn, long id, int resultSetType, int resultSetConcurrency) {
        this.conn = conn;
        this.id = id;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public MultiDataSourceStatement(MultiDataSourceConnection conn, long id, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.conn = conn;
        this.id = id;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkStatement(sql);
        return this.stmt.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkStatement(sql);
        return this.stmt.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getMaxFieldSize();
        }
        if (this.maxFieldSize == null) {
            return 0;
        }
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (this.stmt != null) {
            this.stmt.setMaxFieldSize(max);
            return;
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getMaxRows();
        }
        if (this.maxRows == null) {
            return 0;
        }
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (this.stmt != null) {
            this.stmt.setMaxRows(max);
            return;
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.stmt != null) {
            this.stmt.setEscapeProcessing(enable);
            return;
        }
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getQueryTimeout();
        }
        if (this.queryTimeout == null) {
            return 0;
        }
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.stmt != null) {
            this.stmt.setQueryTimeout(seconds);
            return;
        }
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        if (this.stmt != null) {
            this.stmt.cancel();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.stmt != null) {
            this.stmt.clearWarnings();
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (this.stmt != null) {
            this.stmt.setCursorName(name);
            return;
        }
        this.cursorName = name;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkStatement(sql);
        return this.stmt.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getResultSet();
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getUpdateCount();
        }
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getMoreResults();
        }
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.stmt != null) {
            this.stmt.setFetchDirection(direction);
            return;
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getFetchDirection();
        }
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.stmt != null) {
            this.stmt.setFetchSize(rows);
            return;
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getFetchSize();
        }
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getResultSetConcurrency();
        }
        if (this.resultSetConcurrency != null) {
            return this.resultSetConcurrency;
        }
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getResultSetType();
        }
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkStatement(sql);
        this.stmt.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.stmt != null) {
            this.stmt.clearBatch();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.executeBatch();
        }
        return new int[0];
    }

    @Override
    public MultiDataSourceConnection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getMoreResults(current);
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getGeneratedKeys();
        }
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkStatement(sql);
        return this.stmt.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkStatement(sql);
        return this.stmt.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkStatement(sql);
        return this.stmt.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkStatement(sql);
        return this.stmt.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkStatement(sql);
        return this.stmt.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkStatement(sql);
        return this.stmt.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getResultSetHoldability();
        }
        if (this.resultSetHoldability != null) {
            return this.resultSetHoldability;
        }
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.stmt != null) {
            return this.stmt.isClosed();
        }
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            return null;
        }
        if (iface.isInstance(this)) {
            return (T)this;
        }
        if (this.stmt != null) {
            return this.stmt.unwrap(iface);
        }
        return null;
    }

    public Boolean isEscapeProcessing() {
        return this.escapeProcessing;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

