/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.cobar;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.ha.DataSourceHolder;
import com.alibaba.druid.pool.ha.MultiDataSource;
import com.alibaba.druid.pool.ha.cobar.CobarConfigLoader;
import com.alibaba.druid.pool.ha.cobar.CobarFailureDetecter;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CobarDataSource
extends MultiDataSource {
    private static final Log LOG = LogFactory.getLog(CobarDataSource.class);
    public static long DEFAULT_FAILURE_DETECT_PERRIOD_MILLIS = 3000L;
    public static long DEFAULT_CONFIG_LOAD_PERRIOD_MILLIS = 180000L;
    private String url;
    private String username;
    private String password;
    private long minEvictableIdleTimeMillis = 180000L;
    private boolean testWhileIdle = true;
    private List<Filter> proxyFilters = new ArrayList<Filter>();
    private String filters;

    public CobarDataSource() {
        this.setFailureDetector(new CobarFailureDetecter());
        this.setFailureDetectPeriodMillis(DEFAULT_FAILURE_DETECT_PERRIOD_MILLIS);
        this.setConfigLoadPeriodMillis(DEFAULT_CONFIG_LOAD_PERRIOD_MILLIS);
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public List<Filter> getProxyFilters() {
        return this.proxyFilters;
    }

    public void setProxyFilters(List<Filter> proxyFilters) {
        this.proxyFilters = proxyFilters;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    @Override
    protected void initInternal() throws SQLException {
        if (this.url == null || this.url.isEmpty()) {
            throw new SQLException("");
        }
        if (CobarConfigLoader.isCobar(this.url)) {
            if (this.getConfigLoader() == null) {
                this.setConfigLoader(new CobarConfigLoader(this));
            }
            int RETRY_COUNT = 3;
            for (int i = 0; i < 3; ++i) {
                try {
                    this.getConfigLoader().load();
                    break;
                }
                catch (Exception ex) {
                    LOG.error("load config error", ex);
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        } else {
            DataSourceHolder holder = this.createDataSourceHolder(this.url, 1);
            this.addDataSource("master", holder);
        }
    }

    protected DataSourceHolder createDataSourceHolder(String url, int weight) throws SQLException {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(url);
        dataSource.setUsername(this.username);
        dataSource.setPassword(this.password);
        dataSource.setMaxActive(this.getMaxPoolSize());
        dataSource.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        dataSource.setTestWhileIdle(this.testWhileIdle);
        if (this.filters != null && !this.filters.isEmpty()) {
            dataSource.setFilters(this.filters);
        }
        dataSource.setProxyFilters(this.proxyFilters);
        DataSourceHolder holder = new DataSourceHolder(this, dataSource);
        holder.setWeight(weight);
        return holder;
    }

    protected void handleDataSourceDiscard(DataSourceHolder holder) {
        LOG.debug("dataSource close");
        JdbcUtils.close(holder);
    }
}

