/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.xa;

import com.alibaba.druid.pool.ConnectionHolder;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAPoolableConnection
extends DruidPooledConnection
implements XAResource {
    private static final Log LOG = LogFactory.getLog(XAPoolableConnection.class);
    protected final XAConnection xaConnection;
    protected final XAResource xaResource;
    protected Xid currentXid;
    private Lock stateLock = new ReentrantLock();

    public XAPoolableConnection(ConnectionHolder holder, XAConnection xaConnection) throws SQLException {
        super(holder);
        this.xaConnection = xaConnection;
        this.xaResource = xaConnection.getXAResource();
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.xaResource.commit(xid, onePhase);
    }

    @Override
    public void end(Xid xid, int arg1) throws XAException {
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xaResource.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource other) throws XAException {
        return this.xaResource.isSameRM(other);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.xaResource.prepare(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.xaResource.rollback(xid);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaResource.setTransactionTimeout(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.holder == null) {
            throw new XAException("connection is closed");
        }
        try {
            this.xaResource.start(xid, flags);
        }
        catch (XAException e) {
            if (this.isFailedXA(e.errorCode)) {
                LOG.error("Start transaction failed for " + this);
            }
            throw e;
        }
        this.stateLock.lock();
        try {
            this.currentXid = xid;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private boolean isFailedXA(int errorCode) {
        return errorCode == -3 || errorCode == -7;
    }
}

